/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui;

import com.google.common.base.Charsets;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.Weigher;
import com.suncode.pwfl.cache.config.InMemoryCacheConfig;
import com.suncode.pwfl.web.ui.DebugMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;

@Component
class WebScriptsCache
implements CacheStrategy<CacheKey, CacheValue> {
    private static final long MAX_SIZE = 0x1400000L;
    private final PlusWorkflowCache<CacheKey, CacheValue> cache;
    private final CacheFactory cacheFactory;

    @Autowired
    public WebScriptsCache(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
        InMemoryCacheConfig cacheConfig = InMemoryCacheConfig.builder().maximumSize(Long.valueOf(0x1400000L)).build();
        this.cache = cacheFactory.createInMemoryCache(SystemCacheId.WEB_SCRIPTS_CACHE, cacheConfig);
    }

    public void invalidate(CacheKey key) {
        this.cache.invalidate((Object)key);
    }

    public CacheValue get(CacheKey key) {
        if (DebugMode.isDebug()) {
            return null;
        }
        return (CacheValue)this.cache.getIfPresent((Object)key);
    }

    public void put(CacheKey key, CacheValue value) {
        if (!DebugMode.isDebug()) {
            this.cache.put((Object)key, (Object)value);
        }
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public void destroy() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    private static class ScriptWeighter
    implements Weigher<CacheKey, CacheValue> {
        private ScriptWeighter() {
        }

        public int weigh(CacheKey key, CacheValue value) {
            int size = 0;
            size += value.getGzippedContent() != null ? value.getGzippedContent().length : 0;
            return size += value.getRawContent().getBytes(Charsets.UTF_8).length;
        }
    }
}

