/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.CipherAlgorithm;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassAssociationService;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.ExpirationType;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.CipherAlgorithmDto;
import com.suncode.pwfl.web.dto.archive.CreateDocumentClassDto;
import com.suncode.pwfl.web.dto.archive.DocumentClassDto;
import com.suncode.pwfl.web.dto.archive.ExpirationTypeDto;
import com.suncode.pwfl.web.dto.archive.ReadDocumentClassDto;
import com.suncode.pwfl.web.dto.archive.UpdateDocumentClassDto;
import com.suncode.pwfl.web.support.DirectoryMapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DocumentClassMapper {
    private static final Logger log = LoggerFactory.getLogger(DocumentClassMapper.class);
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private ArchiveStorageService archiveStorageService;
    @Autowired
    private DirectoryMapper directoryMapper;
    @Autowired
    private DocumentClassAssociationService documentClassAssociationService;

    public DocumentClass toEntity(CreateDocumentClassDto createDocumentClassDto) {
        ExpirationType expirationType;
        DocumentClass documentClass = new DocumentClass();
        String documentClassName = Jsoup.clean((String)createDocumentClassDto.getName().trim(), (Safelist)Safelist.basic());
        documentClass.setName(documentClassName);
        String documentClassDescription = createDocumentClassDto.getDescription() != null ? Jsoup.clean((String)createDocumentClassDto.getDescription().trim(), (Safelist)Safelist.basic()) : "";
        documentClass.setDescription(documentClassDescription);
        if (createDocumentClassDto.getMaxFileSizeMb() != null) {
            documentClass.setMaxFileSize(Long.valueOf(createDocumentClassDto.getMaxFileSizeMb() * 1024L));
        }
        if ((expirationType = createDocumentClassDto.getExpirationType()) == null || StringUtils.isBlank((String)createDocumentClassDto.getExpiration())) {
            documentClass.setExpirationType("on");
            documentClass.setExpiration("");
        } else {
            documentClass.setExpirationType(expirationType.getValue());
            documentClass.setExpiration(createDocumentClassDto.getExpiration());
        }
        if (createDocumentClassDto.getDirectoryId() == null) {
            throw new ServiceException(MessageHelper.getMessage((String)"Nie_wybrano_katalogu"));
        }
        Directory directory = this.archiveStorageService.getDirectory(createDocumentClassDto.getDirectoryId(), new String[0]);
        if (directory == null) {
            throw new ServiceException(MessageHelper.getMessage((String)"Nie_znaleziono_katalogu", (Object[])new Object[]{createDocumentClassDto.getDirectoryId()}));
        }
        documentClass.setDirectory(directory);
        documentClass.setIndexing(createDocumentClassDto.isIndexing());
        documentClass.setEncoding(createDocumentClassDto.isEncoding());
        documentClass.setCompressing(createDocumentClassDto.isCompressing());
        documentClass.setShowByLink(createDocumentClassDto.isShowByLink());
        CipherAlgorithm cipherAlgorithm = createDocumentClassDto.getCipherAlgorithm();
        if (cipherAlgorithm == null || !documentClass.isEncoding()) {
            documentClass.setCipherAlgorithm("");
            documentClass.setKeyLength(Long.valueOf(0L));
        } else {
            documentClass.setCipherAlgorithm(cipherAlgorithm.name());
            documentClass.setKeyLength(createDocumentClassDto.getKeyLength());
        }
        if (StringUtils.isNotBlank((String)createDocumentClassDto.getLogicalConnection())) {
            documentClass.setLogicalConnection(createDocumentClassDto.getLogicalConnection());
        } else {
            documentClass.setLogicalConnection(DocumentClass.DEFAULT_LOGICAL_CONNECTION);
        }
        documentClass.setIconName(createDocumentClassDto.getIconName());
        documentClass.setIconColor(createDocumentClassDto.getIconColor());
        return documentClass;
    }

    public DocumentClass toEntity(UpdateDocumentClassDto updateDocumentClassDto, Long documentClassId) {
        ExpirationType expirationType;
        DocumentClass documentClass = (DocumentClass)this.documentClassService.get((Serializable)documentClassId);
        if (documentClass == null) {
            throw new ServiceException(MessageHelper.getMessage((String)"Nie_znaleziono_klasy_dokumentow", (Object[])new Object[]{documentClassId}));
        }
        String documentClassName = Jsoup.clean((String)updateDocumentClassDto.getName().trim(), (Safelist)Safelist.basic());
        documentClass.setName(documentClassName);
        String documentClassDescription = updateDocumentClassDto.getDescription() != null ? Jsoup.clean((String)updateDocumentClassDto.getDescription().trim(), (Safelist)Safelist.basic()) : "";
        documentClass.setDescription(documentClassDescription);
        if (updateDocumentClassDto.getMaxFileSizeMb() != null) {
            documentClass.setMaxFileSize(Long.valueOf(updateDocumentClassDto.getMaxFileSizeMb() * 1024L));
        }
        if ((expirationType = updateDocumentClassDto.getExpirationType()) == null || StringUtils.isBlank((String)updateDocumentClassDto.getExpiration())) {
            documentClass.setExpirationType("on");
            documentClass.setExpiration("");
        } else {
            documentClass.setExpirationType(expirationType.getValue());
            documentClass.setExpiration(updateDocumentClassDto.getExpiration());
        }
        Directory directory = this.archiveStorageService.getDirectory(updateDocumentClassDto.getDirectoryId(), new String[0]);
        if (directory == null) {
            throw new ServiceException(MessageHelper.getMessage((String)"Nie_znaleziono_katalogu", (Object[])new Object[]{updateDocumentClassDto.getDirectoryId()}));
        }
        documentClass.setDirectory(directory);
        documentClass.setIndexing(updateDocumentClassDto.isIndexing());
        documentClass.setEncoding(updateDocumentClassDto.isEncoding());
        documentClass.setCompressing(updateDocumentClassDto.isCompressing());
        documentClass.setShowByLink(updateDocumentClassDto.isShowByLink());
        CipherAlgorithm cipherAlgorithm = updateDocumentClassDto.getCipherAlgorithm();
        if (cipherAlgorithm == null || !documentClass.isEncoding()) {
            documentClass.setCipherAlgorithm("");
            documentClass.setKeyLength(Long.valueOf(0L));
        } else {
            documentClass.setCipherAlgorithm(cipherAlgorithm.name());
            documentClass.setKeyLength(updateDocumentClassDto.getKeyLength());
        }
        if (StringUtils.isNotBlank((String)updateDocumentClassDto.getLogicalConnection())) {
            documentClass.setLogicalConnection(updateDocumentClassDto.getLogicalConnection());
        }
        documentClass.setIconName(updateDocumentClassDto.getIconName());
        documentClass.setIconColor(updateDocumentClassDto.getIconColor());
        return documentClass;
    }

    public DocumentClassDto toDocumentClassDto(DocumentClass documentClass) {
        Directory directory = documentClass.getDirectory();
        if (directory != null) {
            directory = this.archiveStorageService.getDirectory(directory.getId(), new String[]{"rootDir", "device"});
        }
        Optional<ExpirationType> expirationType = Arrays.stream(ExpirationType.values()).filter(type -> type.getValue().equalsIgnoreCase(documentClass.getExpirationType())).findFirst();
        Optional<CipherAlgorithm> cipherAlgorithm = Arrays.stream(CipherAlgorithm.values()).filter(type -> type.name().equalsIgnoreCase(documentClass.getCipherAlgorithm())).findFirst();
        String translatedName = StringUtils.isNotBlank((String)documentClass.getTranslatedName()) ? documentClass.getTranslatedName() : this.documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.NAME);
        String translatedDescription = StringUtils.isNotBlank((String)documentClass.getTranslatedDescription()) ? documentClass.getTranslatedDescription() : this.documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.DESCRIPTION);
        return DocumentClassDto.builder().id(documentClass.getId()).name(documentClass.getName()).translatedName(translatedName).description(documentClass.getDescription()).translatedDescription(translatedDescription).maxFileSizeMb(documentClass.getMaxFileSize() != null ? Long.valueOf(documentClass.getMaxFileSize() / 1024L) : null).expirationType(expirationType.map(ExpirationTypeDto::from).orElse(null)).expiration(documentClass.getExpiration()).directory(directory != null ? this.directoryMapper.fromEntity(directory) : null).indexing(documentClass.isIndexing()).encoding(documentClass.isEncoding()).cipherAlgorithm(cipherAlgorithm.map(CipherAlgorithmDto::from).orElse(null)).keyLength(documentClass.getKeyLength()).compressing(documentClass.isCompressing()).showByLink(documentClass.isShowByLink()).logicalConnection(documentClass.getLogicalConnection()).iconName(documentClass.getIconName()).iconColor(documentClass.getIconColor()).build();
    }

    public ReadDocumentClassDto toReadDocumentClassDto(DocumentClass documentClass) {
        String translatedName = StringUtils.isNotBlank((String)documentClass.getTranslatedName()) ? documentClass.getTranslatedName() : this.documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.NAME);
        String translatedDescription = StringUtils.isNotBlank((String)documentClass.getTranslatedDescription()) ? documentClass.getTranslatedDescription() : this.documentClassService.getDocumentClassTranslation(documentClass.getId(), TranslatedFieldType.DESCRIPTION);
        List<String> childAssociatedClassesNames = this.documentClassAssociationService.getDocClassAssociationsForParentDocClass(documentClass.getId()).stream().map(documentClassAssociation -> this.documentClassService.getDocumentClassTranslation(documentClassAssociation.getChildClass().getId(), TranslatedFieldType.NAME)).collect(Collectors.toList());
        return ReadDocumentClassDto.builder().id(documentClass.getId()).name(documentClass.getName()).translatedName(translatedName).description(documentClass.getDescription()).translatedDescription(translatedDescription).orderId(documentClass.getOrderId()).iconName(documentClass.getIconName()).iconColor(documentClass.getIconColor()).childAssociatedClassesNames(childAssociatedClassesNames).build();
    }
}

