/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration.email;

import com.suncode.pwfl.administration.email.oauth.client.OAuth2AuthenticationMethod;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2Client;
import com.suncode.pwfl.web.dto.administration.email.OAuth2ConnectionDto;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class OAuth2ClientDto {
    private Long id;
    private String name;
    private OAuth2AuthenticationMethod authenticationMethod;
    private String clientId;
    private String clientSecret;
    private String scope;
    private String authorizationUrl;
    private String tokenUrl;
    private String redirectUrl;
    private boolean pkce;
    private List<OAuth2ConnectionDto> connections;

    public OAuth2ClientDto(OAuth2Client oAuth2Client) {
        this.id = oAuth2Client.getId();
        this.name = oAuth2Client.getName();
        this.clientId = oAuth2Client.getClientId();
        this.clientSecret = oAuth2Client.getDecryptedClientSecret();
        this.scope = oAuth2Client.getScope();
        this.authorizationUrl = oAuth2Client.getAuthorizationUrl();
        this.tokenUrl = oAuth2Client.getTokenUrl();
        this.redirectUrl = oAuth2Client.getRedirectUrl();
        this.authenticationMethod = oAuth2Client.getAuthenticationMethod();
        this.pkce = oAuth2Client.isPkce();
        List<OAuth2ConnectionDto> oAuth2ConnectionDtos = new LinkedList<OAuth2ConnectionDto>();
        if (oAuth2Client.getConnections() != null) {
            oAuth2ConnectionDtos = oAuth2Client.getConnections().stream().map(OAuth2ConnectionDto::new).collect(Collectors.toList());
        }
        this.connections = oAuth2ConnectionDtos;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public OAuth2AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getScope() {
        return this.scope;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public boolean isPkce() {
        return this.pkce;
    }

    public List<OAuth2ConnectionDto> getConnections() {
        return this.connections;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthenticationMethod(OAuth2AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setPkce(boolean pkce) {
        this.pkce = pkce;
    }

    public void setConnections(List<OAuth2ConnectionDto> connections) {
        this.connections = connections;
    }

    public OAuth2ClientDto() {
    }
}

