/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.view;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.AdvanceSearchVariableDto;
import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.database.UserSearchViewProtectionTable;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.suncode.plugin.dashboard.web.support.DynamicListResult;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.distinction.VariableDistinguishDisplayFormat;
import com.suncode.pwfl.distinction.VariableDistinguishDisplayType;
import com.suncode.pwfl.distinction.VariableDistinguishService;
import com.suncode.pwfl.distinction.VariableDistinguishTable;
import com.suncode.pwfl.distinction.domain.Condition;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.AdvanceProcessSearchDBHelper;
import com.suncode.pwfl.search.AdvanceProcessSearchVariablesTypesProvider;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SearchFormModelBuilder;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.ViewVariablesToSearchModelMapper;
import com.suncode.pwfl.search.dynamic.DynamicViewService;
import com.suncode.pwfl.search.dynamic.ProcessSearchView;
import com.suncode.pwfl.search.dynamic.ProcessSearchViewService;
import com.suncode.pwfl.search.dynamic.ProcessSearchViewType;
import com.suncode.pwfl.search.dynamic.dto.DynamicViewDto;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.view.DetailedViewFetchType;
import com.suncode.pwfl.view.ViewFetchType;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.view.dto.ViewDto;
import com.suncode.pwfl.view.dto.ViewWithRightLevelDto;
import com.suncode.pwfl.view.exception.SearchProtectionViewDoesNotExist;
import com.suncode.pwfl.view.exception.UserSearchViewTableNotFoundException;
import com.suncode.pwfl.view.exception.UserSearchViewTableProtectionAlreadyExistsException;
import com.suncode.pwfl.view.exception.VariableDistinguishNotFoundException;
import com.suncode.pwfl.view.exception.ViewDoesNotExistException;
import com.suncode.pwfl.view.service.advancedSearchVariables.AdvanceSearchVariableMapper;
import com.suncode.pwfl.view.service.advancedSearchVariables.AdvanceSearchVariableQueryService;
import com.suncode.pwfl.view.service.advancedSearchVariables.AdvanceSearchVariableService;
import com.suncode.pwfl.view.service.viewProtection.ViewProtectionService;
import com.suncode.pwfl.view.service.viewRights.ViewRightsService;
import com.suncode.pwfl.web.dto.workflow.view.GadgetViewDto;
import com.suncode.pwfl.web.dto.workflow.view.ViewProtectionDto;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.distinction.DistinctionUtil;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.web.support.form.cache.SearchFormCachedItem;
import com.suncode.pwfl.web.support.form.cache.SearchResultActions;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"view"})
@Api(tags={"views"})
public class ViewController {
    private static final Logger log = LoggerFactory.getLogger(ViewController.class);
    private final Map<UUID, List<ViewDto>> exportCache = new HashMap<UUID, List<ViewDto>>();
    private final ViewService viewService;
    private final ExportService exportService;
    private final VariableDistinguishService variableDistinguishService;
    private final ViewProtectionService viewProtectionService;
    private final AdvanceSearchVariableService advanceSearchVariableService;
    private final AdvanceSearchVariableMapper advanceSearchVariableMapper;
    private final SearchFormCache searchFormCache;
    private final AdvanceProcessSearchDBHelper advanceProcessSearchDBHelper;
    private final ViewVariablesToSearchModelMapper viewVariablesToSearchModelMapper;
    private final MessageHelperBean messageHelper;
    private final ViewRightsService viewRightsService;
    private final Experimental experimental;
    private final DynamicViewService dynamicViewService;
    private final ProcessSearchViewService processSearchViewService;
    private final ProcessService processService;
    private final UserService userService;
    private final AdvanceProcessSearchVariablesTypesProvider advanceProcessSearchVariablesTypesProvider;
    private final AuthorizationHelper authorizationHelper;
    private final AdvanceSearchVariableQueryService advanceSearchVariableQueryService;
    private final SearchFormModelBuilder searchFormModelBuilder;

    @ResponseBody
    @GetMapping(value={"shouldseeallviews"})
    @ApiOperation(value="", hidden=true)
    public Boolean getShouldSeeAllViews() {
        return this.viewService.shouldSeeAllViews();
    }

    @ResponseBody
    @GetMapping(value={"cansavegroupacceptation"})
    @ApiOperation(value="", hidden=true)
    public Boolean getCanSaveGroupAcceptation(@RequestParam String processDefinitionId) {
        return this.authorizationHelper.hasSearchProcessAccess(processDefinitionId);
    }

    @ResponseBody
    @GetMapping(value={"{viewId}"})
    @ApiOperation(value="", hidden=true)
    public ViewDto getView(@PathVariable String viewId) throws ViewDoesNotExistException {
        if (!this.viewRightsService.hasRightsToView(Long.valueOf(viewId))) {
            throw new NotFullRightsException();
        }
        return this.viewService.getUserSearchView(viewId);
    }

    @ResponseBody
    @GetMapping(value={"private"})
    @ApiOperation(value="", hidden=true)
    public List<ViewDto> getPrivateViews() {
        return this.viewService.getViews(ViewFetchType.PRIVATE);
    }

    @ResponseBody
    @GetMapping(value={"public"})
    @ApiOperation(value="", hidden=true)
    public List<ViewDto> getPublicViews() {
        return this.viewService.getViews(ViewFetchType.PUBLIC);
    }

    @ResponseBody
    @GetMapping(value={"all"})
    @ApiOperation(value="", hidden=true)
    public List<ViewDto> getAllViews() {
        this.authorizationHelper.assertFullSystemRights(() -> {});
        return this.viewService.getViews(ViewFetchType.ALL);
    }

    @ResponseBody
    @GetMapping(value={"foruser"})
    @ApiOperation(value="Downloading a list of views available to user", notes="Retrieves a list of available views for the logged-in user")
    public List<ViewDto> getViewsForUser() {
        return this.viewService.getViewsForUser(UserContext.current().getUser().getUserName());
    }

    @ResponseBody
    @GetMapping(value={"hasRightsToProcesses/{id}"})
    @ApiOperation(value="", hidden=true)
    public boolean hasRightsToProcessesInView(@PathVariable Long id) {
        return this.viewService.hasRightsToProcessesInView(UserContext.current().getUser().getUserName(), id);
    }

    @ResponseBody
    @GetMapping(value={"available/type"})
    @ApiOperation(value="", hidden=true)
    public List<ViewWithRightLevelDto> getAvailableViews(@RequestParam DetailedViewFetchType viewFetchType) {
        return this.viewService.getAvailableViews(viewFetchType);
    }

    @ResponseBody
    @GetMapping(value={"myViews"})
    @ApiOperation(value="Downloading a list of user's views", notes="Retrieves a list of logged-in user's views")
    public List<ViewDto> getUserViews() {
        String loggedUserName = UserContext.current().getUser().getUserName();
        return this.getEditableViews(loggedUserName);
    }

    @DeleteMapping(value={"myViews/{id}"})
    @ResponseBody
    @ApiOperation(value="Deleting view", notes="Deletes a view with given id")
    public RestResult deleteUserView(HttpServletRequest request, @ApiParam(value="View id", required=true) @PathVariable Long id) throws UserSearchViewTableNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_VIEW).params((Map)new ImmutableMap.Builder().put((Object)"viewId", (Object)id).build());
        try {
            this.viewService.deleteView(id);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @PatchMapping(value={"myViews/{id}"})
    @ResponseBody
    @ApiOperation(value="Changing view", notes="Changes a view with given id. The executed query changes the indicated view. The query is a JSON object with the following fields: \n- **name** - view name \n- **description** - view description")
    public RestResult changeUserView(HttpServletRequest request, @ApiParam(value="View id", required=true) @PathVariable Long id, @RequestBody ViewDto viewDto) throws UserSearchViewTableNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_VIEW);
        ViewDto view = this.viewService.getView(id);
        if (view == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new UserSearchViewTableNotFoundException(this.messageHelper.getMessage("Widok_nie_istnieje"));
        }
        HashMap<String, Object> auditParameters = new HashMap<String, Object>();
        auditParameters.put("viewId", id);
        auditParameters.put("viewName", view.getName() + ";" + viewDto.getName());
        auditParameters.put("viewDescription", view.getDescription() + ";" + viewDto.getDescription());
        auditBuilder.params(auditParameters);
        try {
            this.viewService.changeView(id, viewDto);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @GetMapping(value={"myViews/{id}/protections"})
    @ResponseBody
    @ApiOperation(value="Downloading a list of view protections", notes="Retrieves a list of view's protections")
    public CountedResult<ViewProtectionDto> getUserSearchViewProtections(@ApiParam(value="View id", required=true) @PathVariable Long id, @ApiParam(value="Result number from which results are to be returned", required=true) @RequestParam Integer start, @ApiParam(value="Number of returned results", required=true) @RequestParam Integer limit, @ApiParam(value="Sort by", required=false, defaultValue="isGroup") @RequestParam(required=false, defaultValue="isGroup") String sortBy, @ApiParam(value="Sort direction", required=false, defaultValue="DESC") @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) {
        List viewProtectionForView = this.viewProtectionService.getViewProtections(id).stream().map(ViewProtectionDto::fromEntity).sorted((Comparator<ViewProtectionDto>)DtoComparator.of(ViewProtectionDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(viewProtectionForView).viewPageByOffset(start, limit);
    }

    @GetMapping(value={"myViews/{id}/protections/canEdit"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public boolean getUserSearchViewProtection(@PathVariable Long id) {
        return this.getEditableViews(UserContext.current().getUser().getUserName()).stream().anyMatch(view -> view.getId().equals(id));
    }

    @DeleteMapping(value={"myViews/{id}/protections/{protectionId}"})
    @ResponseBody
    @ApiOperation(value="Deleting view protection", notes="Deletes protection with given id")
    public RestResult deleteUserSearchViewProtection(HttpServletRequest request, @ApiParam(value="View id", required=true) @PathVariable Long id, @ApiParam(value="Protection id", required=true) @PathVariable Long protectionId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_VIEW_PROTECTION).params((Map)ImmutableMap.of((Object)"protectionId", (Object)protectionId, (Object)"viewId", (Object)id));
        try {
            this.viewProtectionService.deleteSearchViewProtection(protectionId);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @PatchMapping(value={"myViews/{id}/protections/{protectionId}"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public RestResult editUserSearchViewProtection(HttpServletRequest request, @PathVariable Long id, @PathVariable Long protectionId, @RequestBody ViewProtectionDto protectionDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_VIEW_PROTECTION);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("protectionId", protectionId);
        auditParams.put("viewId", id);
        auditParams.put("permissionLevel", protectionDto.getPermissionLevel());
        try {
            UserSearchViewProtectionTable oldViewProtection = this.viewProtectionService.getViewProtection(protectionId);
            auditParams.put("oldPermissionLevel", oldViewProtection.getPermissionLevel());
            auditBuilder.params(auditParams);
            this.viewProtectionService.editSearchViewProtection(protectionDto.toEntity());
        }
        catch (Exception e) {
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @PostMapping(value={"myViews/{id}/protections"})
    @ResponseBody
    @ApiOperation(value="Adding view protection", notes="Adds a protection to specified view. The executed query adds protection the indicated view. The query is a JSON object with the following fields: \n- **viewId** - view Id \n- **shareUserId** - user/group name \n- **isGroup** - is resource a group \n- **permissionLevel** - permission level (PREVIEW, EDIT)")
    public RestResult addUserSearchViewProtection(HttpServletRequest request, @ApiParam(value="View id", required=true) @PathVariable Long id, @RequestBody ViewProtectionDto viewProtectionDto) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("viewId", id);
        params.put("protectionName", viewProtectionDto.getShareUserId());
        params.put("protectionIsGroup", viewProtectionDto.getIsGroup());
        params.put("permissionLevel", viewProtectionDto.getPermissionLevel());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_VIEW_PROTECTION).params(params);
        try {
            Long protectionId = this.viewProtectionService.addViewProtection(viewProtectionDto.toEntity());
            params.put("protectionId", protectionId);
            auditBuilder.params(params);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @GetMapping(value={"myViews/{id}/protections/export/{extension}"})
    @ResponseBody
    @ApiOperation(value="Exporting a list of view protections", notes="Exports a list of view's protections")
    public void exportUserSearchViewProtectionForView(@ApiParam(value="View id", required=true) @PathVariable Long id, HttpServletResponse response, @ApiParam(value="Sort by", required=false) @RequestParam(required=false, defaultValue="shareUserId") String sortBy, @ApiParam(value="Sort direction", required=false, defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @ApiParam(value="Extension", required=true) @PathVariable String extension) throws IOException {
        List protections = this.viewProtectionService.getViewProtections(id).stream().sorted(DtoComparator.of(UserSearchViewProtectionTable.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Grupa")).data(protections).by(userSearchViewProtectionTable -> this.messageHelper.getMessage(userSearchViewProtectionTable.getIsGroup())).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Uzytkownik_grupa")).data(protections).by(UserSearchViewProtectionTable::getShareUserId).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Udostepnienia_widoku")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @GetMapping(value={"myViews/{id}/variables"})
    @ResponseBody
    @ApiOperation(value="Downloading a list of view distinctions", notes="Retrieves a list of view's distinctions")
    public CountedResult<VariableDistinguishTableDto> getUserSearchViewVariables(@ApiParam(value="View id", required=true) @PathVariable Long id, @ApiParam(value="Result number from which results are to be returned", required=true) @RequestParam(required=false) Integer start, @ApiParam(value="Number of returned results", required=true) @RequestParam(required=false) Integer limit, @ApiParam(value="Sort by", required=false, defaultValue="variableName") @RequestParam(defaultValue="variableName") String sortBy, @ApiParam(value="Sort direction", required=false, defaultValue="ASC") @RequestParam(defaultValue="ASC") SortDirection sortDirection) throws IOException {
        if (!this.viewRightsService.hasRightsToView(id)) {
            throw new NotFullRightsException();
        }
        ObjectMapper objectMapper = new ObjectMapper();
        List variables = this.variableDistinguishService.getVariableDistinguishTablesForView(id.longValue()).stream().map(distinction -> {
            try {
                AdvanceSearchVariableDto distinguishedSearchVariable = this.advanceSearchVariableQueryService.findAdvanceSearchVariableForView(id, distinction.getVariableId());
                return VariableDistinguishTableDto.from(distinction, distinguishedSearchVariable.getTranslatedName(), objectMapper);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }).sorted((Comparator<VariableDistinguishTableDto>)DtoComparator.of(VariableDistinguishTableDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(variables).viewPageByOffset(start, limit);
    }

    @GetMapping(value={"myViews/{id}/export/variables/{extension}"})
    @ApiOperation(value="", hidden=true)
    public void exportVariableDistinguishTable(HttpServletResponse response, @PathVariable Long id, @RequestParam(required=false, defaultValue="variableName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @PathVariable String extension) throws IOException {
        if (!this.viewRightsService.hasRightsToView(id)) {
            throw new NotFullRightsException();
        }
        List variableDistinguishTablesForView = this.variableDistinguishService.getVariableDistinguishTablesForView(id.longValue()).stream().sorted(DtoComparator.of(VariableDistinguishTable.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        DistinctionUtil.formatConditionsToDisplay(variableDistinguishTablesForView);
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_zmiennej")).data(variableDistinguishTablesForView).by(variableDistinguishTable -> this.advanceSearchVariableQueryService.findAdvanceSearchVariableForView(Long.valueOf(Long.parseLong(variableDistinguishTable.getViewId())), variableDistinguishTable.getVariableId()).getTranslatedName()).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Wartosc")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getVariableValue).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Sposob_wyswietlania")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getViewVariableViewType).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Format_wyswietlania")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getViewVariableFormat).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Kolor")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getColor).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Kolor_tla")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getBackgroundColor).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Wyroznione_zmienne")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @DeleteMapping(value={"myViews/{id}/variables/{variableId}"})
    @ResponseBody
    @ApiOperation(value="Deleting view distinction", notes="Deletes distinction")
    public RestResult deleteVariableDistinguishTable(HttpServletRequest request, @ApiParam(value="View id", required=true) @PathVariable Long id, @ApiParam(value="Distinction id", required=true) @PathVariable Long variableId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_VARIABLE_DISTINGUISH);
        HashMap<String, Object> auditParameters = new HashMap<String, Object>();
        auditParameters.put("variableDistinguishId", variableId);
        auditParameters.put("viewId", id);
        auditBuilder.params(auditParameters);
        if (!this.viewRightsService.hasRightsToView(id)) {
            auditBuilder.buildFailure(request);
            throw new NotFullRightsException();
        }
        VariableDistinguishTable variable = this.variableDistinguishService.getVariableDistinguish(variableId.longValue());
        if (variable == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new ServiceException(this.messageHelper.getMessage("Wyroznienie_zmiennej_nie_istnieje"));
        }
        AdvanceSearchVariableDto distinguishedSearchVariable = this.advanceSearchVariableQueryService.findAdvanceSearchVariableForView(id, variable.getVariableId());
        auditParameters.put("variableName", distinguishedSearchVariable.getTranslatedName());
        auditBuilder.params(auditParameters);
        try {
            this.variableDistinguishService.deleteVariableDistinguish(variableId.longValue());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @GetMapping(value={"myViews/{id}/advanced/variables"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public CountedResult<AdvanceSearchVariableDto> getAdvanceSearchVariablesForView(@PathVariable Long id, @RequestParam(defaultValue="name") String orderBy, @RequestParam(defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        if (!this.viewRightsService.hasRightsToView(id)) {
            throw new NotFullRightsException();
        }
        String processDefinitionId = this.advanceSearchVariableService.getProcessDefinitionIdForView(id);
        List advanceSearchVariables = this.advanceSearchVariableService.getAdvanceSearchVariablesForView(id).stream().map(variable -> this.advanceSearchVariableMapper.fromEntity(variable, processDefinitionId)).sorted((Comparator<AdvanceSearchVariableDto>)DtoComparator.of(AdvanceSearchVariableDto.class, (String)orderBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(advanceSearchVariables).viewPageByOffset(start, limit);
    }

    @GetMapping(value={"myViews/{id}/advanced/variables/distinguish"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public CountedResult<AdvanceSearchVariableDto> getAdvanceSearchVariablesForViewDistinguish(@PathVariable Long id, @RequestParam(defaultValue="name") String orderBy, @RequestParam(defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        if (!this.viewRightsService.hasRightsToView(id)) {
            throw new NotFullRightsException();
        }
        String processDefinitionId = this.advanceSearchVariableService.getProcessDefinitionIdForView(id);
        List advanceSearchVariables = this.advanceSearchVariableService.getAdvanceSearchVariablesForView(id).stream().map(variable -> this.advanceSearchVariableMapper.fromEntity(variable, processDefinitionId)).sorted((Comparator<AdvanceSearchVariableDto>)DtoComparator.of(AdvanceSearchVariableDto.class, (String)orderBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        List viewVariables = advanceSearchVariables.stream().map(variable -> {
            AdvanceVariableForm advanceVariableForm = new AdvanceVariableForm();
            advanceVariableForm.setName(variable.getName());
            return advanceVariableForm;
        }).collect(Collectors.toList());
        boolean isProcessDefIdPresent = viewVariables.stream().anyMatch(variable -> variable.getName().equals("procDefId"));
        if (!isProcessDefIdPresent && StringUtils.isNotBlank((CharSequence)processDefinitionId)) {
            AdvanceVariableForm processDefIdVariable = new AdvanceVariableForm();
            processDefIdVariable.setName("procDefId");
            processDefIdVariable.setValue(processDefinitionId);
            viewVariables.add(processDefIdVariable);
        }
        Map extendedTypeVariables = this.advanceProcessSearchVariablesTypesProvider.getTypesForAdvanceSearchVariables(viewVariables).getExtendedTypeVariables();
        List variablesToDistinguish = advanceSearchVariables.stream().filter(variable -> this.isVariableValidForDistinguishing((AdvanceSearchVariableDto)variable, (String)extendedTypeVariables.get(variable.getName()))).collect(Collectors.toList());
        return Paginator.forAll(variablesToDistinguish).viewPageByOffset(start, limit);
    }

    private boolean isVariableValidForDistinguishing(AdvanceSearchVariableDto advanceSearchVariableDto, String extendedType) {
        if (advanceSearchVariableDto.getName().equals("taskUser") || advanceSearchVariableDto.getName().equals("procInitiator")) {
            return false;
        }
        if (extendedType != null) {
            return !extendedType.equals("USERNAME");
        }
        return true;
    }

    @GetMapping(value={"myViews/export/{extension}"})
    @ApiOperation(value="Exporting a list of user's views", notes="Exporting a list of user's views for the logged-in user")
    public void exportMyViews(HttpServletResponse response, @ApiParam(value="Filter views by name/description/owner", required=false) @RequestParam(required=false, defaultValue="") String query, @ApiParam(value="Sort by", required=false, defaultValue="translatedName") @RequestParam(required=false, defaultValue="translatedName") String sortBy, @ApiParam(value="Sort direction", required=false, defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @ApiParam(value="Extension", required=true) @PathVariable String extension, @ApiParam(value="Cached views identifier", required=false) @RequestParam(required=false) UUID id) throws IOException {
        List<Object> views;
        if (id == null) {
            query = query.toLowerCase().trim();
            views = this.filterViews(this.viewService.getMyViewsForUser(UserContext.current().getUser().getUserName()), query).stream().sorted(DtoComparator.of(ViewDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
            this.exportViews(views, sortBy, sortDirection, response, extension);
        } else {
            views = this.getCachedViews(id);
        }
        this.exportMyViews(views, sortBy, sortDirection, response, extension);
    }

    @PostMapping(value={"myViews/export/{extension}"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public URI exportMyViews(HttpServletRequest request, @RequestBody List<ViewDto> views, @PathVariable String extension, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        return this.getRedirectUri(request, views);
    }

    @GetMapping(value={"private/export/{extension}"})
    @ApiOperation(value="", hidden=true)
    public void exportPrivateViews(HttpServletResponse response, @RequestParam(value="query", required=false, defaultValue="") String rawQuery, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id, @PathVariable String extension) throws IOException {
        List<Object> views;
        if (id == null) {
            String query = rawQuery.trim().toLowerCase();
            views = this.filterViews(this.viewService.getViews(ViewFetchType.PRIVATE), query).stream().sorted(DtoComparator.of(ViewDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        } else {
            views = this.getCachedViews(id);
        }
        this.exportViews(views, sortBy, sortDirection, response, extension);
    }

    @PostMapping(value={"private/export/{extension}"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public URI exportPrivateViews(HttpServletRequest request, @RequestBody List<ViewDto> views, @PathVariable String extension) throws URISyntaxException {
        return this.getRedirectUri(request, views);
    }

    @GetMapping(value={"public/export/{extension}"})
    @ApiOperation(value="", hidden=true)
    public void exportPublicViews(HttpServletResponse response, @RequestParam(value="query", required=false, defaultValue="") String rawQuery, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id, @PathVariable String extension) throws IOException {
        List<Object> views;
        if (id == null) {
            String query = rawQuery.trim().toLowerCase();
            views = this.filterViews(this.viewService.getViews(ViewFetchType.PUBLIC), query).stream().sorted(DtoComparator.of(ViewDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        } else {
            views = this.getCachedViews(id);
        }
        this.exportViews(views, sortBy, sortDirection, response, extension);
    }

    @PostMapping(value={"public/export/{extension}"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public URI exportPublicViews(HttpServletRequest request, @RequestBody List<ViewDto> views, @PathVariable String extension, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws URISyntaxException {
        return this.getRedirectUri(request, views);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"all/export/{extension}"})
    public void exportAllViews(HttpServletResponse response, @RequestParam(value="query", required=false, defaultValue="") String rawQuery, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id, @PathVariable String extension) throws IOException {
        List<Object> views;
        this.authorizationHelper.assertFullSystemRights(() -> {});
        if (id == null) {
            String query = rawQuery.trim().toLowerCase();
            views = this.filterViews(this.viewService.getViews(ViewFetchType.ALL), query).stream().sorted(DtoComparator.of(ViewDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        } else {
            views = this.getCachedViews(id);
        }
        this.exportViews(views, sortBy, sortDirection, response, extension);
    }

    @PostMapping(value={"all/export/{extension}"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public URI exportAllViews(HttpServletRequest request, @RequestBody List<ViewDto> views, @PathVariable String extension, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws URISyntaxException {
        return this.getRedirectUri(request, views);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"available/export/{extension}"})
    public void exportAvailableViews(HttpServletResponse response, @RequestParam(value="query", required=false, defaultValue="") String rawQuery, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id, @RequestParam(required=false) DetailedViewFetchType viewFetchType, @PathVariable String extension) throws IOException {
        List<Object> views;
        if (id == null) {
            String query = rawQuery.trim().toLowerCase();
            List<ViewDto> viewDtos = this.viewService.getAvailableViews(viewFetchType).stream().map(ViewDto.class::cast).collect(Collectors.toList());
            views = this.filterViews(viewDtos, query).stream().sorted(DtoComparator.of(ViewDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        } else {
            views = this.getCachedViews(id);
        }
        this.exportViews(views, sortBy, sortDirection, response, extension);
    }

    @PostMapping(value={"available/export/{extension}"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public URI exportAvailableViews(HttpServletRequest request, @RequestBody List<ViewDto> views, @PathVariable String extension) throws URISyntaxException {
        return this.getRedirectUri(request, views);
    }

    private URI getRedirectUri(HttpServletRequest request, List<ViewDto> views) {
        UUID id;
        while (this.exportCache.containsKey(id = UUID.randomUUID())) {
        }
        this.exportCache.put(id, views);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    private List<ViewDto> getCachedViews(UUID id) {
        List<ViewDto> viewsToExport = this.exportCache.get(id);
        this.exportCache.remove(id);
        return viewsToExport;
    }

    private List<ViewDto> filterViews(List<ViewDto> views, String query) {
        return views.stream().filter(view -> view.getTranslatedName().toLowerCase().contains(query) || view.getTranslatedDescription().toLowerCase().contains(query) || view.getOwnerUsername().toLowerCase().contains(query)).collect(Collectors.toList());
    }

    private void exportViews(List<ViewDto> sortedViews, String sortBy, SortDirection sortDirection, HttpServletResponse response, String extension) throws IOException {
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa")).data(sortedViews).by(ViewDto::getTranslatedName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis")).data(sortedViews).by(ViewDto::getTranslatedDescription).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Wlasciciel")).data(sortedViews).by(ViewDto::getOwnerUsername).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Widoki")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private void exportMyViews(List<ViewDto> sortedViews, String sortBy, SortDirection sortDirection, HttpServletResponse response, String extension) throws IOException {
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa")).data(sortedViews).by(ViewDto::getTranslatedName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis")).data(sortedViews).by(ViewDto::getTranslatedDescription).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Zrodlo_wyszukiwania")).data(sortedViews).by(ViewDto::getSource).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Poziom_dostepu")).data(sortedViews).by(ViewDto::getTranslatedAccessLevel).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Widoki")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"/gadget/views"})
    public DynamicListResult getUserViewsForGadget() {
        DynamicListResult views = new DynamicListResult();
        UserContext userContext = UserContext.current();
        if (userContext.name() == null) {
            return views;
        }
        List userViews = this.viewService.getViews(ViewFetchType.PRIVATE);
        userViews.addAll(this.viewService.getViews(ViewFetchType.PUBLIC));
        userViews = userViews.stream().collect(Collectors.toMap(ViewDto::getId, Function.identity(), (existing, replacement) -> existing)).values().stream().collect(Collectors.toList());
        for (ViewDto view : userViews) {
            String translatedName = StringUtils.isNotBlank((CharSequence)view.getTranslatedName()) ? view.getTranslatedName() : view.getName();
            views.addEntry(translatedName, (Object)view.getId());
        }
        User user = this.userService.getUser(userContext.getUser().getUserName(), new String[0]);
        this.dynamicViewService.getDynamicViewsForUser(user).stream().sorted(Comparator.comparing(DynamicViewDto::getViewName)).forEach(dynamicViewDto -> views.addEntry(dynamicViewDto.getViewName(), (Object)dynamicViewDto.getViewId()));
        return views;
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"/gadget/{viewId}"})
    public ResponseEntity<?> getViewForGadget(@PathVariable Long viewId, HttpServletRequest request) {
        try {
            String processDefId;
            ViewDto view = this.viewService.getUserSearchView(viewId.toString());
            String userName = UserContext.current().getUser().getUserName();
            if (!this.viewRightsService.hasRightsToView(viewId.toString(), view.getOwnerUsername(), userName)) {
                NoRightsResult noRightsResult = NoRightsResult.builder().right("view").build();
                return new ResponseEntity((Object)noRightsResult, (HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            String searchFormModelRaw = view.getSearchFormModel();
            List searchVariablesForView = new ArrayList();
            ObjectMapper mapper = new ObjectMapper();
            if (StringUtils.isBlank((CharSequence)searchFormModelRaw)) {
                searchVariablesForView = this.advanceProcessSearchDBHelper.getSearchVariablesForView(viewId);
                Optional<AdvanceSearchVariableTable> processDefVariableTable = searchVariablesForView.stream().filter(advanceSearchVariableTable -> advanceSearchVariableTable.getName().equals("procDefId")).findFirst();
                processDefId = processDefVariableTable.map(AdvanceSearchVariableTable::getValue).orElse(null);
            } else {
                SearchFormModelDto searchFormModelDto = this.searchFormModelBuilder.buildSearchFormModelWithTypeInfo(searchFormModelRaw);
                processDefId = searchFormModelDto.getProcessDetailsSearchModel().getProcessDefinitionId().getValue();
                searchFormModelRaw = mapper.writeValueAsString((Object)searchFormModelDto);
            }
            if (!this.viewRightsService.hasRightsToProcessInView(processDefId, view.getOwnerUsername(), userName)) {
                NoRightsResult noRightsResult = NoRightsResult.builder().message(this.messageHelper.getMessage("brak_uprawnien_do_procesu_w_widoku", new Object[]{userName, processDefId})).right("process").build();
                return new ResponseEntity((Object)noRightsResult, (HttpStatusCode)HttpStatus.FORBIDDEN);
            }
            if (StringUtils.isBlank((CharSequence)searchFormModelRaw)) {
                searchFormModelRaw = mapper.writeValueAsString((Object)this.viewVariablesToSearchModelMapper.map(searchVariablesForView));
            }
            String searchId = UUID.randomUUID().toString();
            GadgetViewDto gadgetViewDto = GadgetViewDto.builder().viewId(viewId).translatedName(Jsoup.clean((String)view.getTranslatedName(), (Safelist)Safelist.basic())).searchId(searchId).encodedSearchFormModel(this.getEncodedSearchFormModel(request, view, searchId, searchFormModelRaw)).build();
            return new ResponseEntity((Object)gadgetViewDto, (HttpStatusCode)HttpStatus.OK);
        }
        catch (ViewDoesNotExistException e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"/gadget/dynamic"})
    public ResponseEntity<?> getDynamicViewForGadget(@RequestParam String processDefId, @RequestParam ProcessSearchViewType processSearchViewType, HttpServletRequest request) {
        Optional processSearchView = this.processSearchViewService.findViewForProcessDefIdAndType(processDefId, processSearchViewType);
        if (!processSearchView.isPresent()) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        String encodedSearchFormModel = this.processSearchViewService.encodeSearchFormModel((ProcessSearchView)processSearchView.get());
        Cache<String, SearchFormCachedItem> cache = this.searchFormCache.getCache(request.getSession(false));
        ConcurrentMap sessionCache = cache.asMap();
        String searchId = UUID.randomUUID().toString();
        sessionCache.put(searchId, new SearchFormCachedItem(encodedSearchFormModel, Collections.emptyList(), new SearchResultActions(false, false, false)));
        ProcessType processType = (ProcessType)this.processService.getProcessTypesForProcessDefIds(Collections.singletonList(processDefId)).get(0);
        DynamicViewDto dynamicViewDto = this.dynamicViewService.getDynamicViewDto(processType, processSearchViewType);
        GadgetViewDto gadgetViewDto = GadgetViewDto.builder().translatedName(Jsoup.clean((String)dynamicViewDto.getViewName(), (Safelist)Safelist.basic())).searchId(searchId).encodedSearchFormModel(encodedSearchFormModel).dynamic(true).build();
        return new ResponseEntity((Object)gadgetViewDto, (HttpStatusCode)HttpStatus.OK);
    }

    private String getEncodedSearchFormModel(HttpServletRequest request, ViewDto view, String searchId, String searchFormModelRaw) {
        String encodedSearchFormModel = Base64.getEncoder().encodeToString(searchFormModelRaw.getBytes(StandardCharsets.UTF_8));
        this.searchFormCache.cacheSearchForm(request.getSession(false), searchId, new SearchFormCachedItem(encodedSearchFormModel, Collections.emptyList(), new SearchResultActions(view.isAcceptManyTasks(), view.isShowOnlyLatestActivityDetails(), view.isAcceptFromAllPages())));
        return encodedSearchFormModel;
    }

    private List<ViewDto> getEditableViews(String loggedUserName) {
        return this.viewService.getAllEditableViewsForUser(loggedUserName);
    }

    @ExceptionHandler(value={UserSearchViewTableNotFoundException.class, VariableDistinguishNotFoundException.class, SearchProtectionViewDoesNotExist.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={UserSearchViewTableProtectionAlreadyExistsException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public RestResult handleAlreadyExistException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"viewService", "exportService", "variableDistinguishService", "viewProtectionService", "advanceSearchVariableService", "advanceSearchVariableMapper", "searchFormCache", "advanceProcessSearchDBHelper", "viewVariablesToSearchModelMapper", "messageHelper", "viewRightsService", "experimental", "dynamicViewService", "processSearchViewService", "processService", "userService", "advanceProcessSearchVariablesTypesProvider", "authorizationHelper", "advanceSearchVariableQueryService", "searchFormModelBuilder"})
    @Autowired
    public ViewController(ViewService viewService, ExportService exportService, VariableDistinguishService variableDistinguishService, ViewProtectionService viewProtectionService, AdvanceSearchVariableService advanceSearchVariableService, AdvanceSearchVariableMapper advanceSearchVariableMapper, SearchFormCache searchFormCache, AdvanceProcessSearchDBHelper advanceProcessSearchDBHelper, ViewVariablesToSearchModelMapper viewVariablesToSearchModelMapper, MessageHelperBean messageHelper, ViewRightsService viewRightsService, Experimental experimental, DynamicViewService dynamicViewService, ProcessSearchViewService processSearchViewService, ProcessService processService, UserService userService, AdvanceProcessSearchVariablesTypesProvider advanceProcessSearchVariablesTypesProvider, AuthorizationHelper authorizationHelper, AdvanceSearchVariableQueryService advanceSearchVariableQueryService, SearchFormModelBuilder searchFormModelBuilder) {
        this.viewService = viewService;
        this.exportService = exportService;
        this.variableDistinguishService = variableDistinguishService;
        this.viewProtectionService = viewProtectionService;
        this.advanceSearchVariableService = advanceSearchVariableService;
        this.advanceSearchVariableMapper = advanceSearchVariableMapper;
        this.searchFormCache = searchFormCache;
        this.advanceProcessSearchDBHelper = advanceProcessSearchDBHelper;
        this.viewVariablesToSearchModelMapper = viewVariablesToSearchModelMapper;
        this.messageHelper = messageHelper;
        this.viewRightsService = viewRightsService;
        this.experimental = experimental;
        this.dynamicViewService = dynamicViewService;
        this.processSearchViewService = processSearchViewService;
        this.processService = processService;
        this.userService = userService;
        this.advanceProcessSearchVariablesTypesProvider = advanceProcessSearchVariablesTypesProvider;
        this.authorizationHelper = authorizationHelper;
        this.advanceSearchVariableQueryService = advanceSearchVariableQueryService;
        this.searchFormModelBuilder = searchFormModelBuilder;
    }

    record VariableDistinguishTableDto(Long id, String color, String variableId, String variableName, VariableDistinguishDisplayType variableViewType, VariableDistinguishDisplayFormat variableFormat, String variableValue2, String variableValue, String viewId, String backgroundColor, List<Condition> conditionDtoList, byte[] icon) {
        public static VariableDistinguishTableDto from(VariableDistinguishTable distinction, String variableName, ObjectMapper mapper) throws JsonProcessingException {
            List conditions = (List)mapper.readValue(distinction.getVariableValue(), (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, Condition.class));
            return new VariableDistinguishTableDto(distinction.getId(), distinction.getColor(), distinction.getVariableId(), variableName, distinction.getVariableViewType(), distinction.getVariableFormat(), distinction.getVariableValue2(), DistinctionUtil.formatConditions((List)conditions), distinction.getViewId(), distinction.getBackgroundColor(), Collections.unmodifiableList(conditions), distinction.getIcon());
        }

        public String getVariableValueEscapeXml() {
            return Optional.ofNullable(this.variableValue).map(value -> value.replace("<", "&lt;").replace(">", "&gt;").replace("[/br]", "</br>")).orElse(null);
        }

        public String getViewVariableViewType() {
            return Optional.ofNullable(this.variableViewType).map(VariableDistinguishDisplayType::getTranslatedValue).orElse("");
        }

        public String getViewVariableFormat() {
            return Optional.ofNullable(this.variableFormat).map(VariableDistinguishDisplayFormat::getTranslatedValue).orElse("");
        }
    }

    static class NoRightsResult {
        private String message;
        private String right;

        public static NoRightsResultBuilder builder() {
            return new NoRightsResultBuilder();
        }

        public String getMessage() {
            return this.message;
        }

        public String getRight() {
            return this.right;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setRight(String right) {
            this.right = right;
        }

        public NoRightsResult() {
        }

        @ConstructorProperties(value={"message", "right"})
        public NoRightsResult(String message, String right) {
            this.message = message;
            this.right = right;
        }

        public static class NoRightsResultBuilder {
            private String message;
            private String right;

            NoRightsResultBuilder() {
            }

            public NoRightsResultBuilder message(String message) {
                this.message = message;
                return this;
            }

            public NoRightsResultBuilder right(String right) {
                this.right = right;
                return this;
            }

            public NoRightsResult build() {
                return new NoRightsResult(this.message, this.right);
            }

            public String toString() {
                return "ViewController.NoRightsResult.NoRightsResultBuilder(message=" + this.message + ", right=" + this.right + ")";
            }
        }
    }
}

