/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.suncode.pwfl.archive.LinkConnection;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.archive.UpsertLinkConnectionDto;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.AssociatedIndexesDto;
import com.suncode.pwfl.web.dto.archive.LinkAssociationDto;
import com.suncode.pwfl.web.dto.archive.LinkConnectionDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"links/{id}/associations"})
@Api(tags={"document sets"})
public class LinkAssociationsController {
    private static final Logger log = LoggerFactory.getLogger(LinkAssociationsController.class);
    private final AuthorizationHelper authorizationHelper;
    private final LinkService linkService;
    private final MessageHelperBean messageHelper;
    private final ExportService exportService;

    @ApiOperation(value="(Admin) Downloading document set associations", notes="Retrieves a list of document set associations")
    @GetMapping
    @ResponseBody
    public CountedResult<LinkAssociationDto> getAssociationsForLink(@ApiParam(value="Result number from which results are to be returned", defaultValue="0") @RequestParam(required=false, defaultValue="0") Integer start, @ApiParam(value="Number of returned results", defaultValue="20") @RequestParam(required=false, defaultValue="20") Integer limit, @ApiParam(value="Sort by", defaultValue="documentClassTranslatedName") @RequestParam(required=false, defaultValue="documentClassTranslatedName") String orderBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection, @ApiParam(value="Link id", required=true) @PathVariable Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<LinkAssociationDto> associations = this.getLinkAssociationDtos(orderBy, orderDirection, id);
        return Paginator.forAll(associations).viewPageByOffset(start, limit);
    }

    @ApiOperation(value="(Admin) Downloading document set association", notes="Retrieves document set association")
    @GetMapping(value={"{documentClassId}"})
    @ResponseBody
    public List<LinkConnectionDto> getAssociationsBetweenLinkAndDocumentClass(@ApiParam(value="Link id", required=true) @PathVariable Long id, @ApiParam(value="Id of the document class", required=true) @PathVariable Long documentClassId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.linkService.getConnectionsBetweenLinkAndDocumentClass(id, documentClassId, new String[]{"link", "documentClass", "linkIndex", "documentClassIndex"}).stream().map(LinkConnectionDto::fromEntity).collect(Collectors.toList());
    }

    private List<LinkAssociationDto> getLinkAssociationDtos(String orderBy, SortDirection orderDirection, Long id) {
        return this.linkService.getLinkConnectionsForLink(id, new String[]{"link", "documentClass", "linkIndex", "documentClassIndex"}).stream().collect(Collectors.groupingBy(linkConnection -> linkConnection.getDocumentClass().getId(), Collectors.collectingAndThen(Collectors.toList(), list -> LinkAssociationDto.from(list, ((LinkConnection)list.get(0)).getLink(), ((LinkConnection)list.get(0)).getDocumentClass())))).values().stream().sorted((Comparator<LinkAssociationDto>)DtoComparator.of(LinkAssociationDto.class, (String)orderBy, (SortDirection)orderDirection)).collect(Collectors.toList());
    }

    @ApiOperation(value="(Admin) Downloading document set associations", notes="Exports a list of document set associations")
    @GetMapping(value={"export/{extension}"})
    @ResponseBody
    public void exportLinkAssociations(HttpServletResponse response, @ApiParam(value="Link id", required=true) @PathVariable Long id, @ApiParam(value="Sort by", defaultValue="documentClassTranslatedName") @RequestParam(required=false, defaultValue="documentClassTranslatedName") String orderBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection, @ApiParam(value="Extension", required=true) @PathVariable String extension) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<LinkAssociationDto> linkAssociations = this.getLinkAssociationDtos(orderBy, orderDirection, id);
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Powiazana_klasa")).data(linkAssociations).by(LinkAssociationDto::getDocumentClassTranslatedName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Powiazane_indeksy")).data(linkAssociations).by(linkAssociationDto -> this.getFormattedAssociatedIndexes(linkAssociationDto.getAssociatedIndexes(), extension)).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Powiazania")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="(Admin) Deleting document set association", notes="Deletes document set association with given document class")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @DeleteMapping(value={"{documentClassId}"})
    @ResponseBody
    public RestResult deleteLinkAssociation(HttpServletRequest request, @ApiParam(value="Id of the document set", required=true) @PathVariable Long id, @ApiParam(value="Id of the document class", required=true) @PathVariable Long documentClassId) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("linkId", id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_LINK_CONNECTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            List associationIds = this.linkService.deleteLinkAssociationsForDocumentClass(id, documentClassId);
            auditParams.put("connectionId", associationIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
            auditBuilder.params(auditParams);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Adding document set association", notes="Adds document set association")
    @PostMapping(value={"{documentClassId}"})
    @ResponseBody
    public RestResult addLinkAssociation(HttpServletRequest request, @ApiParam(value="Id of the document set", required=true) @PathVariable Long id, @ApiParam(value="Id of the document class", required=true) @PathVariable Long documentClassId, @ApiParam(value="The query contains a JSON object containing association parameters. The definition should include the following fields \n- **linkIndexId** - id of the document set index\n- **documentClassIndexId** - id of the document class index", required=true) @RequestBody List<UpsertLinkConnectionDto> associations) {
        HashMap<String, Long> auditParams = new HashMap<String, Long>();
        auditParams.put("linkId", id);
        auditParams.put("docClassId", documentClassId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_LINK_CONNECTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.linkService.addLinkAssociations(id, documentClassId, associations);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Editing document set association", notes="Edits document set association")
    @PutMapping(value={"{documentClassId}"})
    @ResponseBody
    public RestResult updateLinkAssociation(HttpServletRequest request, @ApiParam(value="Id of the document set", required=true) @PathVariable Long id, @ApiParam(value="Id of the document class", required=true) @PathVariable Long documentClassId, @ApiParam(value="The query contains a JSON object containing association parameters. The definition should include the following fields \n- **linkIndexId** - id of the document set index\n- **documentClassIndexId** - id of the document class index", required=true) @RequestBody List<UpsertLinkConnectionDto> associations) {
        HashMap<String, Long> auditParams = new HashMap<String, Long>();
        auditParams.put("linkId", id);
        auditParams.put("docClassId", documentClassId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_LINK_CONNECTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.linkService.updateLinkAssociations(id, documentClassId, associations);
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            throw e;
        }
        auditBuilder.buildSuccess(request);
        return new RestResult(true);
    }

    private String getFormattedAssociatedIndexes(List<AssociatedIndexesDto> associatedIndexes, String fileExtension) {
        String pattern = "%s -> %s";
        String delimiter = ";";
        if (fileExtension.equals("pdf")) {
            delimiter = ";\n";
        }
        return associatedIndexes.stream().map(index -> String.format("%s -> %s", index.getParentIndexName(), index.getChildIndexName())).collect(Collectors.joining(delimiter));
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"authorizationHelper", "linkService", "messageHelper", "exportService"})
    @Autowired
    public LinkAssociationsController(AuthorizationHelper authorizationHelper, LinkService linkService, MessageHelperBean messageHelper, ExportService exportService) {
        this.authorizationHelper = authorizationHelper;
        this.linkService = linkService;
        this.messageHelper = messageHelper;
        this.exportService = exportService;
    }
}

