/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks;

import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ParameterInfo;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;

public class ScheduledTaskAuditParameter {
    private String componentParameterId;
    private Integer position;
    private String value;

    public static ScheduledTaskAuditParameter from(ParameterInfo parameterInfo) {
        return ScheduledTaskAuditParameter.builder().componentParameterId(parameterInfo.getComponentParameterId()).position(parameterInfo.getPosition()).value(parameterInfo.getValue().toString()).build();
    }

    public String toString() {
        String id = StringUtils.isNotBlank((CharSequence)this.componentParameterId) ? this.componentParameterId : String.valueOf(this.position);
        return String.format("%s -> %s", id, this.value);
    }

    @ConstructorProperties(value={"componentParameterId", "position", "value"})
    ScheduledTaskAuditParameter(String componentParameterId, Integer position, String value) {
        this.componentParameterId = componentParameterId;
        this.position = position;
        this.value = value;
    }

    public static ScheduledTaskAuditParameterBuilder builder() {
        return new ScheduledTaskAuditParameterBuilder();
    }

    public String getComponentParameterId() {
        return this.componentParameterId;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getValue() {
        return this.value;
    }

    public static class ScheduledTaskAuditParameterBuilder {
        private String componentParameterId;
        private Integer position;
        private String value;

        ScheduledTaskAuditParameterBuilder() {
        }

        public ScheduledTaskAuditParameterBuilder componentParameterId(String componentParameterId) {
            this.componentParameterId = componentParameterId;
            return this;
        }

        public ScheduledTaskAuditParameterBuilder position(Integer position) {
            this.position = position;
            return this;
        }

        public ScheduledTaskAuditParameterBuilder value(String value) {
            this.value = value;
            return this;
        }

        public ScheduledTaskAuditParameter build() {
            return new ScheduledTaskAuditParameter(this.componentParameterId, this.position, this.value);
        }

        public String toString() {
            return "ScheduledTaskAuditParameter.ScheduledTaskAuditParameterBuilder(componentParameterId=" + this.componentParameterId + ", position=" + this.position + ", value=" + this.value + ")";
        }
    }
}

