/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.llm;

import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowTempFileCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.TempFileStream;
import com.suncode.pwfl.cache.config.TempFileCacheConfig;
import com.suncode.pwfl.cache.exception.PlusWorkflowCacheException;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.support.ParametrizedRuntimeException;
import com.suncode.pwfl.web.dto.workflow.process.map.ProcessDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.io.DownloadResource;
import com.suncode.pwfl.web.support.workflow.process.map.ProcessMapper;
import com.suncode.pwfl.web.support.workflow.process.summary.ProcessMapSummaryGenerator;
import com.suncode.pwfl.workflow.editor.map.UnknownIntentionException;
import com.suncode.pwfl.workflow.process.map.LlmProcessMapBuilder;
import com.suncode.pwfl.workflow.process.map.Package;
import com.suncode.pwfl.workflow.process.map.Process;
import com.suncode.pwfl.xpdl.builder.XpdlBuilderService;
import jakarta.annotation.PostConstruct;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/llm"})
public class LlmController {
    private static final Logger log = LoggerFactory.getLogger(LlmController.class);
    private final LlmProcessMapBuilder mapBuilder;
    private final ProcessMapper processMapper;
    private final MessageHelperBean messageHelperBean;
    private final XpdlBuilderService xpdlBuilderService;
    private final CacheFactory cacheFactory;
    private final ProcessMapSummaryGenerator processMapSummaryGenerator;
    private PlusWorkflowTempFileCache xpdlCache;

    @PostConstruct
    private void initialize() {
        this.xpdlCache = this.cacheFactory.createTempFileCache(SystemCacheId.XPDL_CACHE, TempFileCacheConfig.builder().build());
    }

    @PostMapping(value={"/process"})
    public LlmResponse buildProcessMapFromPrompt(@RequestBody String prompt) {
        try {
            Process process = this.mapBuilder.buildProcessMapFromPrompt(prompt);
            ProcessDto processDto = this.processMapper.toDto(process);
            return new LlmResponse(processDto, this.processMapSummaryGenerator.generateSummary(processDto), false);
        }
        catch (UnknownIntentionException e) {
            return new LlmResponse(null, this.messageHelperBean.getMessage("Problem_podczas_generowania_mapy_procesu"), true);
        }
    }

    @PostMapping(value={"/process/xpdl"})
    public UUID buildProcessMapFromPrompt(@RequestBody ProcessDto processDto) {
        Process process = this.processMapper.toProcess(processDto);
        String packageId = UUID.randomUUID().toString().substring(0, 10);
        String packageName = "Process Map %s".formatted(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        Package pkg = new Package(packageId, packageName);
        pkg.getProcesses().add(process);
        String xpdlContent = this.xpdlBuilderService.buildBy(pkg);
        return this.xpdlCache.put(packageId + ".xpdl", xpdlContent);
    }

    @GetMapping(value={"/process/xpdl"})
    public DownloadResource getProcessMapAsXpdl(@RequestParam UUID uuid) {
        TempFileStream xpdlStream = (TempFileStream)this.xpdlCache.getValueStream(uuid, true).orElseThrow(() -> new PlusWorkflowCacheException(uuid + " not found in cache"));
        return new DownloadResource(xpdlStream);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResult handleBadRequest(ParametrizedRuntimeException e) {
        return new RestResult(false, this.messageHelperBean.getMessage(e.getMessageKey()));
    }

    @ExceptionHandler(value={PlusWorkflowCacheException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public RestResult handleBadRequest(PlusWorkflowCacheException e) {
        log.warn("Value not found in cache", (Throwable)e);
        return new RestResult(false);
    }

    @ConstructorProperties(value={"mapBuilder", "processMapper", "messageHelperBean", "xpdlBuilderService", "cacheFactory", "processMapSummaryGenerator"})
    @Autowired
    public LlmController(LlmProcessMapBuilder mapBuilder, ProcessMapper processMapper, MessageHelperBean messageHelperBean, XpdlBuilderService xpdlBuilderService, CacheFactory cacheFactory, ProcessMapSummaryGenerator processMapSummaryGenerator) {
        this.mapBuilder = mapBuilder;
        this.processMapper = processMapper;
        this.messageHelperBean = messageHelperBean;
        this.xpdlBuilderService = xpdlBuilderService;
        this.cacheFactory = cacheFactory;
        this.processMapSummaryGenerator = processMapSummaryGenerator;
    }

    record LlmResponse(ProcessDto process, String summary, boolean isError) {
    }
}

