/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.Calendar;
import com.suncode.pwfl.calendar.ExternalCalendar;
import com.suncode.pwfl.calendar.external.api.ExternalCalendarService;
import com.suncode.pwfl.web.dto.calendar.ExternalCalendarDto;
import com.suncode.pwfl.web.dto.calendar.event.ExternalCalendarEventDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calendar/external"})
@Api(hidden=true)
public class ExternalCalendarController {
    private static final Logger log = LoggerFactory.getLogger(ExternalCalendarController.class);
    private final ExternalCalendarService externalCalendarService;
    private final UserService userService;
    private final CalendarMapper calendarMapper;

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public ExternalCalendarDto createExternalCalendar(@RequestBody ExternalCalendarDto externalCalendarDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_EXTERNAL_CALENDAR);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ExternalCalendar externalCalendar = this.calendarMapper.toExternalCalendar(externalCalendarDto);
            externalCalendar.setOwner(user);
            auditParamsBuilder.params(this.paramsFromExternalCalendar(externalCalendar));
            ExternalCalendar createdCalendar = (ExternalCalendar)this.externalCalendarService.createCalendar((Calendar)externalCalendar);
            auditParamsBuilder.params(this.paramsFromExternalCalendar(createdCalendar));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toExternalCalendarDto(createdCalendar);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @PatchMapping(value={"{id}"})
    public ExternalCalendarDto updateExternalCalendar(@PathVariable Long id, @RequestBody ExternalCalendarDto externalCalendarDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_EXTERNAL_CALENDAR);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ExternalCalendar externalCalendar = this.calendarMapper.toExternalCalendar(externalCalendarDto);
            externalCalendar.setOwner(user);
            auditParamsBuilder.params(this.paramsFromExternalCalendar(externalCalendar));
            ExternalCalendar oldExternalCalendar = (ExternalCalendar)this.externalCalendarService.getCalendar(id, user);
            ExternalCalendar updatedCalendar = (ExternalCalendar)this.externalCalendarService.updateCalendar(id.longValue(), (Calendar)externalCalendar);
            auditParamsBuilder.params(this.paramsFromExternalCalendar(oldExternalCalendar, updatedCalendar));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toExternalCalendarDto(updatedCalendar);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{id}"})
    public RestResult deleteExternalCalendar(@PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_EXTERNAL_CALENDAR).params(new AuditParamsBuilder().param("id", (Object)id).build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            this.externalCalendarService.deleteCalendar(id, user);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"{calendarId}/events"})
    public List<ExternalCalendarEventDto> getEventsForExternalCalendar(@PathVariable Long calendarId, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromDateTime, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toDateTime, @RequestParam(name="timeZone") String timeZoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        return this.externalCalendarService.getEventsForExternalCalendarByInterval(calendarId, user, fromDateTime, toDateTime, timeZone).stream().map(this.calendarMapper::toExternalCalendarEventDto).toList();
    }

    @GetMapping(value={"sync/{id}"})
    public RestResult syncCalendar(@PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SYNC_EXTERNAL_CALENDAR).params(new AuditParamsBuilder().param("id", (Object)id).build());
        try {
            this.externalCalendarService.syncCalendar(id);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    private Map<String, Object> paramsFromExternalCalendar(ExternalCalendar externalCalendar) {
        return new AuditParamsBuilder().param("name", (Object)externalCalendar.getName()).param("color", (Object)externalCalendar.getColor()).param("url", (Object)externalCalendar.getUrl()).build();
    }

    private Map<String, Object> paramsFromExternalCalendar(ExternalCalendar oldExternalCalendar, ExternalCalendar newExternalCalendar) {
        return new AuditParamsBuilder().param("name", (Object)oldExternalCalendar.getName(), (Object)newExternalCalendar.getName()).param("color", (Object)oldExternalCalendar.getColor(), (Object)newExternalCalendar.getColor()).param("url", (Object)oldExternalCalendar.getUrl(), (Object)newExternalCalendar.getUrl()).build();
    }

    @ConstructorProperties(value={"externalCalendarService", "userService", "calendarMapper"})
    @Autowired
    public ExternalCalendarController(ExternalCalendarService externalCalendarService, UserService userService, CalendarMapper calendarMapper) {
        this.externalCalendarService = externalCalendarService;
        this.userService = userService;
        this.calendarMapper = calendarMapper;
    }
}

