/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.permissions.exception;

import com.suncode.pwfl.administration.permissions.exception.DeleteAdminPermissionException;
import com.suncode.pwfl.administration.permissions.exception.EmptyPropertyPermissionException;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.support.ParametrizedEmptyPropertyException;
import com.suncode.pwfl.support.ParametrizedRuntimeException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice(basePackages={"com.suncode.pwfl.web.controller.api.administration.permissions"})
public class PermissionsExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(PermissionsExceptionHandler.class);
    private final MessageHelperBean messageHelper;

    @ExceptionHandler(value={EmptyPropertyPermissionException.class, DeleteAdminPermissionException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequestPermissionRuntimeException(RuntimeException e) {
        log.info(e.getMessage(), (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={ParametrizedEmptyPropertyException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequestParametrizedException(ParametrizedRuntimeException e) {
        String exceptionMessage = this.messageHelper.getMessage(e.getMessageKey(), e.getParameters());
        log.info(exceptionMessage, (Throwable)e);
        return new RestResult(false, exceptionMessage);
    }

    @ConstructorProperties(value={"messageHelper"})
    public PermissionsExceptionHandler(MessageHelperBean messageHelper) {
        this.messageHelper = messageHelper;
    }
}

