/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.request;

import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.form.AuditCreatorHandler;
import com.suncode.pwfl.audit.request.RequestParamsAnalyzer;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.audit.util.AuditUrls;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class AuditCreator
implements AuditCreatorHandler {
    @Override
    public Audit createAudit(HttpServletRequest request, AuditUrls auditUrl) {
        RequestParamsAnalyzer analyzer = new RequestParamsAnalyzer();
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        String userId = (String)session.getAttribute("username");
        switch (auditUrl) {
            case LOGOUT: {
                return new Audit(userId, AuditTypes.AUDIT_LOG_OUT);
            }
            case SAVE_ACTIVITY_FORM: {
                return new Audit(userId, AuditTypes.AUDIT_SAVE_ACTIVITY);
            }
            case PROCESS_FLOW_ACCEPT_ACTIVITY: {
                return new Audit(userId, AuditTypes.AUDIT_ACCEPT_ACTIVITY);
            }
            case SEARCH_USER: {
                return new Audit(userId, AuditTypes.AUDIT_SEARCH_USER);
            }
            case ADD_SYSTEM_PROTECTION: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_SYSTEM_PROTECTION);
            }
            case DELETE_SYSTEM_PROTECTION: 
            case DELETE_FLAT_SYSTEM_PROTECTION: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_SYSTEM_PROTECTION);
            }
            case ADD_POSITION: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_POSITION);
            }
            case DELETE_POSITION: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_POSITION);
            }
            case DELETE_ROLE_FROM_POSITION: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_ROLE_FROM_POSITION);
            }
            case SEARCH_POSITION: {
                return new Audit(userId, AuditTypes.AUDIT_SEARCH_POSITION);
            }
            case ADD_ORG_UNIT: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_ORG_UNIT);
            }
            case DELETE_ORG_UNIT: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_ORG_UNIT);
            }
            case SEARCH_ORG_UNIT: {
                return new Audit(userId, AuditTypes.AUDIT_SEARCH_ORG_UNIT);
            }
            case ADD_LINK: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK);
            }
            case ADD_DIRECTORY: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DIRECTORY);
            }
            case DELETE_DIRECTORY: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DIRECTORY);
            }
            case ADD_DEVICE: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DEVICE);
            }
            case DELETE_DEVICE: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DEVICE);
            }
            case ADD_DOMAIN: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LDAP_SERVER);
            }
            case DELETE_DOMAIN: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LDAP_SERVER);
            }
            case STATS: {
                return new Audit(userId, AuditTypes.AUDIT_STATS);
            }
            case CHECKOUT_FILE_FROM_ARCHIVE: {
                return new Audit(userId, AuditTypes.AUDIT_CHECKOUT_FILE_FROM_ARCHIVE);
            }
            case CHECKOUT_FILE_FROM_PROCESS: {
                return new Audit(userId, AuditTypes.AUDIT_CHECKOUT_FILE_FROM_PROCESS);
            }
            case ADD_NOTIFICATION: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_NOTIFICATION);
            }
            case DELETE_NOTIFICATION: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_NOTIFICATION);
            }
            case ADD_DOCUMENT_TEMPLATE: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DOCUMENT_TEMPLATE);
            }
            case DELETE_DOCUMENT_TEMPLATE: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_TEMPLATE);
            }
            case USER_NOTIFICATIONS: {
                String xaction = request.getParameter("xaction");
                if (StringUtils.equals((CharSequence)xaction, (CharSequence)"globalConfig")) {
                    String value = request.getParameter("value");
                    if (StringUtils.equals((CharSequence)value, (CharSequence)"enable")) {
                        return new Audit(userId, AuditTypes.AUDIT_ENABLE_USER_NOTIFICATIONS);
                    }
                    if (StringUtils.equals((CharSequence)value, (CharSequence)"disable")) {
                        return new Audit(userId, AuditTypes.AUDIT_DISABLE_USER_NOTIFICATIONS);
                    }
                } else if (StringUtils.equals((CharSequence)xaction, (CharSequence)"destroy")) {
                    return new Audit(userId, AuditTypes.AUDIT_DELETE_USER_NOTIFICATIONS);
                }
                return null;
            }
            case ADD_PROCESS_PROTECTION: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_PROCESS_PROTECTION);
            }
            case DELETE_PROCESS_PROTECTION: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_PROCESS_PROTECTION);
            }
            case UNINSTALL_MODULE: {
                return new Audit(userId, AuditTypes.AUDIT_UNINSTALL_MODULE);
            }
            case ADD_COMMENT_TO_ACTIVITY: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_COMMENT_TO_ACTIVITY);
            }
            case DELETE_COMMENT_FROM_ACTIVITY: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_COMMENT_FROM_ACTIVITY);
            }
            case DELETE_DOCUMENT_FROM_PROCESS: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_FROM_PROCESS);
            }
            case PROCESS_DETAILS: {
                return new Audit(userId, AuditTypes.AUDIT_PROCESS_DETAILS);
            }
            case ACTIVITY_DETAILS: {
                return new Audit(userId, AuditTypes.AUDIT_ACTIVITY_DETAILS);
            }
            case DELETE_DOCUMENT_FROM_ARCHIVE: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_FROM_ARCHIVE);
            }
            case DELETE_SEARCHED_DOCUMENTS: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_SEARCHED_DOCUMENTS);
            }
            case DEACTIVATE_USER: {
                return new Audit(userId, AuditTypes.AUDIT_DEACTIVATE_USER);
            }
            case EDIT_DEACTIVATED_USER: {
                return new Audit(userId, AuditTypes.AUDIT_EDIT_DEACTIVATED_USER);
            }
            case CHANGE_DOCUMENT_INDEXES: {
                return new Audit(userId, AuditTypes.AUDIT_EDIT_DOCUMENT_INDEXES);
            }
            case DELETE_PROCESSES: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_PROCESSES);
            }
            case SUSPEND_ACTIVITY: {
                return new Audit(userId, AuditTypes.AUDIT_SUSPEND_ACTIVITY);
            }
            case ABORT_ACTIVITY: {
                return new Audit(userId, AuditTypes.AUDIT_ABORT_ACTIVITY);
            }
            case ACCEPT_MANY_ACTIVITIES: {
                return new Audit(userId, AuditTypes.AUDIT_ACCEPT_MANY_ACTIVITIES);
            }
            case ADD_DOCUMENT_VIEW: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DOCUMENT_VIEW);
            }
            case DELETE_DOCUMENT_VIEW: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_VIEW);
            }
            case RUN_VIEW: {
                return new Audit(userId, AuditTypes.AUDIT_RUN_VIEW);
            }
            case LOAD_LICENSE: {
                return new Audit(userId, AuditTypes.AUDIT_LOAD_LICENSE);
            }
            case ADD_LINK_INDEX: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK_INDEX);
            }
            case DELETE_LINK_INDEX: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LINK_INDEX);
            }
            case ADD_LINK_CONNECTION: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK_CONNECTION);
            }
            case DELETE_LINK_CONNECTION: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LINK_CONNECTION);
            }
            case ADD_LINK_PROTECTION: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK_PROTECTION);
            }
            case CHANGE_LINK_PROTECTION: {
                return new Audit(userId, AuditTypes.AUDIT_EDIT_LINK_PROTECTION);
            }
            case DELETE_LINK_PROTECTION: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LINK_PROTECTION);
            }
            case CHANGE_PASSWORD: {
                String change = request.getParameter("change");
                if (StringUtils.isNotBlank((CharSequence)change)) {
                    return new Audit(userId, AuditTypes.AUDIT_CHANGE_PASSWORD);
                }
                return null;
            }
            case PACKAGE_MANAGEMENT: {
                String packageAction = request.getParameter("actionType");
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"loadPackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_LOAD_PACKAGE);
                }
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"updatePackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_UPDATE_PACKAGE);
                }
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"closePackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_CLOSE_PACKAGE);
                }
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"clearPackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_CLEAR_PACKAGE);
                }
                return null;
            }
            case ADD_REPORT: {
                String viewIdAddReport = request.getParameter("viewId");
                String sqlQueryAddReport = request.getParameter("sqlQuery");
                if (StringUtils.isNotBlank((CharSequence)viewIdAddReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_VIEW_REPORT);
                }
                if (StringUtils.isNotBlank((CharSequence)sqlQueryAddReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_SQL_QUERY_REPORT);
                }
                return null;
            }
            case ADD_JASPER_REPORT: {
                String reportIdAddJasperReport = request.getParameter("reportId");
                if (StringUtils.isBlank((CharSequence)reportIdAddJasperReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_JASPER_REPORT);
                }
                return new Audit(userId, AuditTypes.AUDIT_EDIT_JASPER_REPORT);
            }
            case RUN_REPORT: 
            case RUN_REPORT_SQL: {
                String viewIdRunReport = request.getParameter("viewId");
                String sqlQueryRunReport = request.getParameter("sqlQuery");
                String reportIdRunReport = request.getParameter("reportId");
                if (StringUtils.isNotBlank((CharSequence)viewIdRunReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_RUN_VIEW_REPORT);
                }
                if (StringUtils.isNotBlank((CharSequence)sqlQueryRunReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_RUN_SQL_QUERY_REPORT);
                }
                if (StringUtils.isNotBlank((CharSequence)reportIdRunReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_RUN_JASPER_REPORT);
                }
                return null;
            }
            case RUN_SAVED_REPORT: {
                return new Audit(userId, AuditTypes.AUDIT_RUN_SAVED_REPORT);
            }
            case FILTER_REPORT: {
                return new Audit(userId, AuditTypes.AUDIT_FILTER_REPORT);
            }
            case ADD_MODULE_RIGHT: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_MODULE_RIGHT);
            }
            case DELETE_MODULE_RIGHT: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_MODULE_RIGHT);
            }
            case ADD_SCHEDULED_TASK: {
                if (request.getMethod().compareTo("POST") == 0) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_SCHEDULED_TASK);
                }
                return null;
            }
            case MANAGE_SCHEDULED_TASK: {
                String scheduledTaskAction = request.getParameter("action");
                if (StringUtils.equals((CharSequence)scheduledTaskAction, (CharSequence)"remove")) {
                    return new Audit(userId, AuditTypes.AUDIT_DELETE_SCHEDULED_TASK);
                }
                if (StringUtils.equals((CharSequence)scheduledTaskAction, (CharSequence)"execute")) {
                    return new Audit(userId, AuditTypes.AUDIT_MANUAL_RUN_SCHEDULED_TASK);
                }
                if (StringUtils.equals((CharSequence)scheduledTaskAction, (CharSequence)"cancel")) {
                    return new Audit(userId, AuditTypes.AUDIT_STOP_SCHEDULED_TASK);
                }
                return null;
            }
            case AUTO_LOGIN: {
                Principal principal = request.getUserPrincipal();
                if (principal != null) {
                    String domainName = this.getAutoLoginAuditDomainName(principal);
                    String userName = request.getRemoteUser();
                    userId = new String(domainName + "/" + userName);
                    return new Audit(userId, AuditTypes.AUDIT_AUTO_LOG_IN);
                }
                return null;
            }
            case AUTO_LOGOUT: {
                return new Audit(userId, AuditTypes.AUDIT_AUTO_LOG_OUT);
            }
            case ABORT_PROCESSES: {
                return new Audit(userId, AuditTypes.AUDIT_ABORT_PROCESSES);
            }
        }
        return null;
    }

    private String getAutoLoginAuditDomainName(Principal principal) {
        String[] splittedPrincipalName = principal.getName().split("@");
        int dotPos = splittedPrincipalName[1].indexOf(".");
        if (dotPos != -1) {
            return StringUtils.lowerCase((String)splittedPrincipalName[1].substring(0, dotPos));
        }
        return StringUtils.lowerCase((String)splittedPrincipalName[1]);
    }
}

