/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.TabMenuData;
import com.suncode.plugin.framework.web.WebFragmentsManager;
import com.suncode.plugin.framework.web.support.MenuEntry;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.SpringContext;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.core.OrderComparator;

public class ShowUserAccountAction
extends Action {
    public static final Logger log = Logger.getLogger(ShowUserAccountAction.class);
    public static final String TAB_MENU_SECTION = "system.useraccount.menu.top";
    private static final WebFragmentsManager webFragmentsManager = (WebFragmentsManager)SpringContext.getBean(WebFragmentsManager.class);
    private static final Experimental experimental = (Experimental)SpringContext.getBean(Experimental.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            int rights;
            HttpSession session = request.getSession(false);
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("welcome");
            }
            String userName = (String)session.getAttribute("username");
            if (SystemProperties.getBoolean((DefinedSystemParameter)DefinedSystemParameter.OPTIONAL_USER_ACCOUNT_RIGHT).booleanValue() && (rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().userAccount().build(), (String)userName, (boolean)false, (boolean)false)) != 1 && rights != 0) {
                return mapping.findForward("welcome");
            }
            request.setAttribute("SHOW_CALENDAR", (Object)(this.shouldShowCalendarTab(userName) ? "TRUE" : "FALSE"));
            request.setAttribute("tabMenuItems", this.generateUserAccountMenu(userName));
            return mapping.findForward("showUserAccount");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return mapping.findForward("welcome");
        }
    }

    private boolean shouldShowCalendarTab(String userName) {
        if (experimental.hasFeature(ExperimentalFeature.NEW_CALENDAR)) {
            return false;
        }
        int calendarRightLevel = Authorization.CheckRight((String)RightTreeBuilder.builder().system().workflow().calendar().build(), (String)userName, (boolean)false);
        return calendarRightLevel == 1 || calendarRightLevel == 0;
    }

    private List<TabMenuData> generateUserAccountMenu(String userName) {
        ArrayList<TabMenuData> tabs = new ArrayList<TabMenuData>();
        tabs.add(new TabMenuData("viewsettings", MessageHelper.getMessage((String)"Ustawienia_wygladu"), "/ShowViewSettings.do", 0));
        tabs.add(new TabMenuData("userinfo", MessageHelper.getMessage((String)"Informacje_o_uzytkowniku"), "/ShowUserInfo.do", 10));
        tabs.add(new TabMenuData("delegations", MessageHelper.getMessage((String)"Zastepstwa"), "/UserDelegations.do", 20));
        if (!experimental.hasFeature(ExperimentalFeature.NEW_SEARCH_FORM)) {
            tabs.add(new TabMenuData("userviews", MessageHelper.getMessage((String)"Moje_widoki"), "/UserViews.do", 30));
        }
        tabs.add(new TabMenuData("reports", MessageHelper.getMessage((String)"Raporty"), "/ReportsMgmt.do", 40));
        if (this.shouldShowCalendarTab(userName)) {
            tabs.add(new TabMenuData("calendar", MessageHelper.getMessage((String)"Kalendarz"), "/UserCalendarSettings.do", 50));
        }
        tabs.add(new TabMenuData("dashboard", MessageHelper.getMessage((String)"dashboards"), "/UserDashboardSettings.do", 60));
        tabs.add(new TabMenuData("favourites", MessageHelper.getMessage((String)"favourites"), "/UserFavouritesSettings.do", 70));
        for (MenuEntry entry : webFragmentsManager.getMenuEntries(TAB_MENU_SECTION)) {
            if (!entry.meetsCondition()) continue;
            tabs.add(new TabMenuData(entry.getKey(), entry.getLabel(), entry.getLinkPath(), entry.getOrder()));
        }
        OrderComparator.sort(tabs);
        return tabs;
    }
}

