/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.notifications;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.plusmpm.i18n.I18N;
import com.plusmpm.servlet.notifications.NotificationConfigurationGridServlet;
import com.plusmpm.util.json.extjs.gson.GsonFactory;
import com.plusmpm.util.workflowData.ProcessData;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class NotificationConfigurationVariablesServlet
extends HttpServlet {
    private static final long serialVersionUID = -517564114010892629L;
    private static final String VARIABLE_ID_CONST = "variableId";
    private static final String VARIABLE_NAME_CONST = "variableName";
    private static final String VARIABLE_TYPE_CONST = "variableType";
    private static final String PROCESS_VARIABLE_CONST = "processVariable";
    private static final String META_VARIABLE_CONST = "metaVariable";
    private static Logger log = Logger.getLogger(NotificationConfigurationGridServlet.class);

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            log.info((Object)"NotificationConfigurationVariablesServlet.doPost( HttpServletRequest req, HttpServletResponse resp )");
            String processDefId = req.getParameter("processId");
            ArrayList<Map<Object, Object>> result = new ArrayList<Map<Object, Object>>();
            if (!processDefId.equals("default_configuration")) {
                Map variables = ProcessData.getProcessVariableIdNameMap((String)processDefId);
                for (Map.Entry entry : variables.entrySet()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(VARIABLE_ID_CONST, (String)entry.getKey());
                    map.put(VARIABLE_NAME_CONST, entry.getValue().toString());
                    map.put(VARIABLE_TYPE_CONST, PROCESS_VARIABLE_CONST);
                    result.add(map);
                }
            }
            result.addAll(this.getAdditionalMap(new I18N(req)));
            Type collectionType = new TypeToken<List<Map<String, String>>>(){}.getType();
            Gson gson = GsonFactory.getGson();
            String gsoned = gson.toJson(result, collectionType);
            resp.getWriter().write(gsoned);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            resp.setStatus(500);
        }
    }

    private List<Map<String, String>> getAdditionalMap(I18N i18n) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        list.add(this.createMetaMap("processtype", i18n.getString("Typ_procesu")));
        list.add(this.createMetaMap("processname", i18n.getString("Nazwa_procesu")));
        list.add(this.createMetaMap("activitystarttime", i18n.getString("Godzina_uruchomienia_zadania")));
        list.add(this.createMetaMap("activitystartday", i18n.getString("Data_uruchomienia_zadania")));
        list.add(this.createMetaMap("processstarttime", i18n.getString("Godzina_uruchomienia_procesu")));
        list.add(this.createMetaMap("processstartday", i18n.getString("Data_uruchomienia_procesu")));
        list.add(this.createMetaMap("activityendtime", i18n.getString("Godzina_zakonczenia_zadania")));
        list.add(this.createMetaMap("activityendday", i18n.getString("Data_zakonczenia_zadania")));
        list.add(this.createMetaMap("processendtime", i18n.getString("Godzina_zakonczenia_procesu")));
        list.add(this.createMetaMap("processendday", i18n.getString("Data_zakonczenia_procesu")));
        list.add(this.createMetaMap("activityname", i18n.getString("Nazwa_zadania")));
        list.add(this.createMetaMap("historylist", i18n.getString("Link_do_szczegolow_zadania")));
        list.add(this.createMetaMap("link", i18n.getString("Link_do_procesu_zadania")));
        list.add(this.createMetaMap("users_delivered", i18n.getString("Uzytkownicy_otrzymujacy_zadanie")));
        return list;
    }

    private Map<String, String> createMetaMap(String variableId, String variableName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(VARIABLE_ID_CONST, "meta_" + variableId);
        map.put(VARIABLE_NAME_CONST, variableName);
        map.put(VARIABLE_TYPE_CONST, META_VARIABLE_CONST);
        return map;
    }
}

