/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.notifications;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.parser.wrapper.XpdlKey;
import com.plusmpm.servlet.notifications.PackageTreeNode;
import com.plusmpm.servlet.notifications.WorkflowProcessTreeNode;
import com.plusmpm.util.XpdlPackageManager;
import com.plusmpm.util.json.extjs.gson.GsonFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.springframework.context.i18n.LocaleContextHolder;

public class NotificationConfigurationTreeServlet
extends HttpServlet {
    private static final long serialVersionUID = -6429870757312725609L;
    private static Logger log = Logger.getLogger(NotificationConfigurationTreeServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String type = req.getParameter("type");
        if (type.equals("root")) {
            List packagesId = XpdlPackageManager.getInstance().getPackageIds();
            ArrayList<PackageTreeNode> packagesNodes = new ArrayList<PackageTreeNode>();
            for (String packageId : packagesId) {
                PackageTreeNode node = new PackageTreeNode(packageId, packageId, false);
                packagesNodes.add(node);
            }
            Gson gson = GsonFactory.getGson();
            Type collectionType = new TypeToken<List<PackageTreeNode>>(){}.getType();
            resp.getWriter().write(gson.toJson(packagesNodes, collectionType));
            return;
        }
        if (type.equals("PACKAGE")) {
            I18Nxpdl xpdl = new I18Nxpdl(LocaleContextHolder.getLocale());
            String packageName = req.getParameter("node");
            Package pack = XpdlPackageManager.getInstance().getPackage(packageName);
            List processes = XpdlPackageManager.getInstance().getAllWorkflowProcessesForPackage(pack);
            ArrayList<WorkflowProcessTreeNode> processesTreeNode = new ArrayList<WorkflowProcessTreeNode>();
            for (WorkflowProcess process : processes) {
                processesTreeNode.add(new WorkflowProcessTreeNode(process.getId(), true, xpdl.getString(XpdlKey.forPackage((String)pack.getId()).forProcess(process.getId()).getKey())));
            }
            Type collectionType = new TypeToken<List<WorkflowProcessTreeNode>>(){}.getType();
            Gson gson = GsonFactory.getGson();
            String json = gson.toJson(processesTreeNode, collectionType);
            resp.getWriter().write(json);
        }
    }
}

