/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.ServletRequestPathUtils;

public class RoutingServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(RoutingServlet.class);
    private static final String SPRING_CONFIGURATION_PREFIX = "spring.";
    private static final String STRUTS_CONFIGURATION_PREFIX = "struts.";
    private final StrutsActionServlet strutsServlet = new StrutsActionServlet();
    private final DispatcherServlet springMvcServlet = new DispatcherServlet();

    public void init(jakarta.servlet.ServletConfig config) throws jakarta.servlet.ServletException {
        this.strutsServlet.init(new PrefixedServletConfig(STRUTS_CONFIGURATION_PREFIX, config));
        this.springMvcServlet.init((jakarta.servlet.ServletConfig)new PrefixedServletConfig(SPRING_CONFIGURATION_PREFIX, config));
        super.init(config);
    }

    protected void service(HttpServletRequest req, jakarta.servlet.http.HttpServletResponse resp) throws jakarta.servlet.ServletException, IOException {
        if (this.springActionMappingFound(req)) {
            this.springMvcServlet.service((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (this.strutsServlet.actionMappingExists(req)) {
            this.strutsServlet.service(req, resp);
            return;
        }
        this.springMvcServlet.service((ServletRequest)req, (ServletResponse)resp);
    }

    private boolean springActionMappingFound(HttpServletRequest req) {
        ServletRequestPathUtils.parseAndCache((HttpServletRequest)req);
        for (HandlerMapping mapping : Objects.requireNonNull(this.springMvcServlet.getHandlerMappings())) {
            HandlerExecutionChain handler = mapping.getHandler(req);
            if (handler == null) continue;
            return true;
        }
        return false;
    }

    private static class StrutsActionServlet
    extends ActionServlet {
        private StrutsActionServlet() {
        }

        public void init(jakarta.servlet.ServletConfig config) throws jakarta.servlet.ServletException {
            try {
                super.init((ServletConfig)config);
            }
            catch (ServletException e) {
                throw new jakarta.servlet.ServletException((Throwable)e);
            }
        }

        boolean actionMappingExists(HttpServletRequest req) {
            String appPath = ServletRequestPathUtils.parseAndCache((HttpServletRequest)req).pathWithinApplication().value();
            String actionName = StringUtils.substringBeforeLast((String)appPath, (String)".");
            ModuleConfig moduleConfig = this.getModuleConfig((javax.servlet.http.HttpServletRequest)req);
            return moduleConfig.findActionConfig(actionName) != null;
        }

        protected ModuleConfig initModuleConfig(String prefix, String paths) {
            Preconditions.checkState((boolean)prefix.isBlank());
            ModuleConfig rootConfig = super.initModuleConfig(prefix, paths);
            String extraActionsLocation = this.getServletConfig().getInitParameter("config-extra-actions");
            if (extraActionsLocation != null) {
                return this.mergeConfig(rootConfig, extraActionsLocation);
            }
            return rootConfig;
        }

        private ModuleConfig mergeConfig(ModuleConfig rootConfig, String extraActionsLocation) {
            ModuleConfigFactory factoryObject = ModuleConfigFactory.createFactory();
            ModuleConfig config = factoryObject.createModuleConfig(rootConfig.getPrefix());
            URL configURL = this.getServletContext().getResource(extraActionsLocation);
            if (configURL == null) {
                return rootConfig;
            }
            try (InputStream stream = configURL.openStream();){
                this.configDigester.push((Object)config);
                this.configDigester.parse(stream);
            }
            if (config.findActionConfigs().length > 0) {
                log.warn("Deprecation notice: found {} client struts-action in {} - in 4.3 client struts actions will no longer be supported", (Object)config.findActionConfigs().length, (Object)extraActionsLocation);
                for (ActionConfig actionConfig : config.findActionConfigs()) {
                    if (rootConfig.findActionConfig(actionConfig.getPath()) != null) continue;
                    log.debug("Registering extra struts action under {}.do", (Object)actionConfig.getPath());
                    rootConfig.addActionConfig(actionConfig);
                }
            }
            return rootConfig;
        }

        public void service(HttpServletRequest req, jakarta.servlet.http.HttpServletResponse res) throws jakarta.servlet.ServletException, IOException {
            try {
                super.service((javax.servlet.http.HttpServletRequest)req, (HttpServletResponse)res);
            }
            catch (ServletException e) {
                throw new jakarta.servlet.ServletException((Throwable)e);
            }
        }
    }

    private static class PrefixedServletConfig
    implements jakarta.servlet.ServletConfig {
        final String prefix;
        final jakarta.servlet.ServletConfig servletConfig;

        public String getServletName() {
            return this.servletConfig.getServletName();
        }

        public ServletContext getServletContext() {
            return this.servletConfig.getServletContext();
        }

        public String getInitParameter(String name) {
            return this.servletConfig.getInitParameter(this.prefix + name);
        }

        public Enumeration<String> getInitParameterNames() {
            return Iterators.asEnumeration((Iterator)Iterators.transform((Iterator)Iterators.filter(this.servletConfig.getInitParameterNames().asIterator(), name -> name.startsWith(this.prefix)), name -> StringUtils.removeStart((String)name, (String)this.prefix)));
        }

        @ConstructorProperties(value={"prefix", "servletConfig"})
        public PrefixedServletConfig(String prefix, jakarta.servlet.ServletConfig servletConfig) {
            this.prefix = prefix;
            this.servletConfig = servletConfig;
        }
    }
}

