/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.support;

import com.plusmpm.i18n.I18NCustom;
import com.suncode.plugin.dashboard.Dashboard;
import com.suncode.plugin.dashboard.DashboardService;
import com.suncode.plugin.dashboard.web.support.dto.DashboardType;
import com.suncode.plugin.dashboard.web.support.dto.GadgetDashboardDto;
import com.suncode.plugin.dashboard.web.support.dto.GadgetDto;
import com.suncode.plugin.dashboard.web.support.dto.OwnerDto;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.dashboard.internal.SystemDashboard;
import com.suncode.pwfl.dashboard.internal.UserDashboard;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class GadgetDashboardMapper {
    @Autowired
    private DashboardService dashboardService;

    public GadgetDashboardDto fromDashboard(Dashboard dashboard) {
        if (dashboard instanceof SystemDashboard) {
            return this.fromSystemDashboard((SystemDashboard)dashboard);
        }
        if (dashboard instanceof UserDashboard) {
            return this.fromUserDashboard((UserDashboard)dashboard);
        }
        throw new IllegalArgumentException("Dashboard type not recognized");
    }

    private GadgetDashboardDto fromSystemDashboard(SystemDashboard systemDashboard) {
        Assert.notNull((Object)systemDashboard, (String)"Dashboard must not be null");
        List gadgetDtos = Arrays.stream(systemDashboard.getGadgets()).map(GadgetDto::create).collect(Collectors.toList());
        return GadgetDashboardDto.builder().id(systemDashboard.getId()).name(systemDashboard.getName()).description(systemDashboard.getDescription()).gadgets(gadgetDtos).type(DashboardType.SYSTEM).build();
    }

    private GadgetDashboardDto fromUserDashboard(UserDashboard userDashboard) {
        Assert.notNull((Object)userDashboard, (String)"Dashboard must not be null");
        I18NCustom custom = new I18NCustom(LocaleContextHolder.getLocale());
        List gadgetDtos = Arrays.stream(userDashboard.getGadgets()).map(GadgetDto::create).collect(Collectors.toList());
        return GadgetDashboardDto.builder().id(userDashboard.getId().toString()).name(custom.getStringSilent(userDashboard.getName())).translatedName(this.dashboardService.getUserDashboardTranslation(userDashboard.getId(), TranslatedFieldType.NAME)).description(custom.getStringSilent(userDashboard.getDescription())).translatedDescription(this.dashboardService.getUserDashboardTranslation(userDashboard.getId(), TranslatedFieldType.DESCRIPTION)).created(userDashboard.getCreationDate()).owner(OwnerDto.create((User)userDashboard.getOwner())).gadgets(gadgetDtos).type(DashboardType.USER).build();
    }
}

