/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.security;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.glowroot.GlowrootHelper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.workflow.CheckProcessAccess;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import org.glowroot.agent.api.Instrumentation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AuthorizationHelper {
    private final CheckProcessAccess checkProcessAccess;
    private final FileService fileService;
    private final GlowrootHelper glowrootHelper;

    @Instrumentation.TraceEntry(timer="Asserting access to process id by user", message="Asserting access to process id [{{0}}] by user [{{this.userName}}]")
    public void assertProcessAccess(String processId, Runnable callbackIfHasNoRights) {
        if (UserContext.isActive() && !this.checkProcessAccess.canUserViewProcessHistory(UserContext.current().getUser().getUserName(), processId, null)) {
            callbackIfHasNoRights.run();
            throw new NotFullRightsException();
        }
    }

    @Instrumentation.TraceEntry(timer="Ensuring process id access", message="Ensuring process id access [{{0}}] by user [{{this.userName}}]")
    public <T> ResponseEntity<T> ensureProcessAccess(String processId, String rightKey, Callable<T> callable) {
        if (UserContext.isActive() && this.checkProcessAccess.canUserViewProcessHistory(UserContext.current().getUser().getUserName(), processId, rightKey)) {
            return new ResponseEntity(callable.call(), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @Instrumentation.TraceEntry(timer="Checking process def id access", message="Checking process def id access [{{0}}] by user [{{this.userName}}]")
    public Boolean hasSearchProcessAccess(String processDefId) {
        int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().workflow().processes().view().custom((Object)processDefId).build(), (String)UserContext.current().getUser().getUserName(), (boolean)false, (boolean)false);
        return rights == 0;
    }

    @Instrumentation.TraceEntry(timer="Asserting full administration rights", message="Asserting full administration rights by user [{{this.userName}}]")
    public void assertFullAdministrationRights(Runnable callbackIfHasNoRights) {
        String name = UserContext.current().getUser().getUserName();
        int right = Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)name, (boolean)false, (boolean)false);
        if (right != 0) {
            callbackIfHasNoRights.run();
            throw new NotFullRightsException();
        }
    }

    @Instrumentation.TraceEntry(timer="Asserting system rights", message="Asserting system rights by user [{{this.userName}}]")
    public void assertFullSystemRights(Runnable callbackIfHasNoRights) {
        String name = UserContext.current().getUser().getUserName();
        int right = Authorization.checkRight((String)"system", (String)name, (boolean)false, (boolean)false);
        if (right != 0) {
            callbackIfHasNoRights.run();
            throw new NotFullRightsException();
        }
    }

    @Instrumentation.TraceEntry(timer="Asserting full custom rights", message="Asserting full custom rights [{{0}}] by user [{{this.userName}}]")
    public void assertFullRights(String rightsPath, Runnable callbackIfHasNoRights) {
        String name = UserContext.current().getUser().getUserName();
        int right = Authorization.checkRight((String)rightsPath, (String)name, (boolean)false, (boolean)false);
        if (right != 0) {
            callbackIfHasNoRights.run();
            throw new NoRightsException();
        }
    }

    @Instrumentation.TraceEntry(timer="Asserting partial custom rights", message="Asserting partial custom rights [{{0}}] by user [{{this.userName}}]")
    public void assertFullOrPartRights(String rightsPath, Runnable callbackIfHasNoRights) {
        String name = UserContext.current().getUser().getUserName();
        int right = Authorization.checkRight((String)rightsPath, (String)name, (boolean)false, (boolean)false);
        if (right == -1) {
            callbackIfHasNoRights.run();
            throw new NoRightsException();
        }
    }

    @Instrumentation.TraceEntry(timer="Ensuring file id access", message="Ensuring file id access [{{0}}] by user [{{this.userName}}]")
    public <T> ResponseEntity<T> ensureFileAccess(Long fileId, Callable<T> callable) {
        if (UserContext.isActive() && Authorization.hasRightsToReadFile((String)UserContext.current().getUser().getUserName(), (Long)fileId)) {
            return new ResponseEntity(callable.call(), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @Instrumentation.TraceEntry(timer="Ensuring file id modify access", message="Ensuring file id modify access [{{0}}] by user [{{this.userName}}]")
    public <T> ResponseEntity<T> ensureFileModifyAccess(Long fileId, Callable<T> callable) {
        if (UserContext.isActive()) {
            WfFile file = this.fileService.getFile(fileId, new String[]{"documentClass"});
            if (Authorization.hasRightsToModifyFile((String)UserContext.current().getUser().getUserName(), (Long)file.getDocumentClass().getId())) {
                return new ResponseEntity(callable.call(), (HttpStatusCode)HttpStatus.OK);
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @Instrumentation.TraceEntry(timer="Ensuring search access", message="Ensuring search access by user [{{this.userName}}]")
    public <T> ResponseEntity<T> ensureSearchAccess(Callable<T> callable) {
        String currentUsername = UserContext.current().getUser().getUserName();
        String rightLevel = RightTreeBuilder.builder().system().workflow().processes().view().build();
        int rights = Authorization.checkRight((String)rightLevel, (String)currentUsername, (boolean)false, (boolean)false);
        if (rights != 1 && rights != 0) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        return new ResponseEntity(callable.call(), (HttpStatusCode)HttpStatus.OK);
    }

    private String userName() {
        return this.glowrootHelper.getUserName();
    }

    @ConstructorProperties(value={"checkProcessAccess", "fileService", "glowrootHelper"})
    @Autowired
    public AuthorizationHelper(CheckProcessAccess checkProcessAccess, FileService fileService, GlowrootHelper glowrootHelper) {
        this.checkProcessAccess = checkProcessAccess;
        this.fileService = fileService;
        this.glowrootHelper = glowrootHelper;
    }
}

