/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.archive;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkDto;
import com.suncode.pwfl.archive.LinkIndex;
import com.suncode.pwfl.archive.LinkProtection;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.archive.UpsertLinkConnectionDto;
import com.suncode.pwfl.archive.exception.LinkAlreadyExistsException;
import com.suncode.pwfl.archive.exception.LinkNotFoundException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.archive.LinkConnectionDto;
import com.suncode.pwfl.web.dto.archive.LinkIndexDto;
import com.suncode.pwfl.web.dto.archive.search.IndexModelDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"links"})
@Api(tags={"document sets"})
public class LinkController {
    private static final Logger log = LoggerFactory.getLogger(LinkController.class);
    @Autowired
    private LinkService linkService;
    @Autowired
    private ExportService exportService;
    private Map<UUID, List<LinkDto>> exportCache = new HashMap<UUID, List<LinkDto>>();
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private DocumentClassService documentClassService;

    @ApiOperation(value="Downloading document sets", notes="Retrieves a list of available document sets for logged-in user")
    @GetMapping
    @ResponseBody
    public CountedResult<LinkDto> getLinksForUser(@ApiParam(value="Result number from which results are to be returned") @RequestParam(required=false) Integer start, @ApiParam(value="Number of returned results") @RequestParam(required=false) Integer limit, @ApiParam(value="Sort by", defaultValue="id") @RequestParam(required=false, defaultValue="id") String orderBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        List links = this.linkService.getLinks(UserContext.current().getUser().getUserName()).stream().map(LinkDto::fromEntity).sorted((Comparator<LinkDto>)DtoComparator.of(LinkDto.class, (String)orderBy, (SortDirection)orderDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(links).viewPageByOffset(start, limit);
    }

    @ResponseBody
    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"{linkId}"})
    public LinkDto get(@PathVariable Long linkId) {
        String rightLevel = RightTreeBuilder.builder().system().archive().links().custom((Object)linkId).build();
        this.authorizationHelper.assertFullOrPartRights(rightLevel, () -> {
            throw new NotFullRightsException(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        });
        Link link = (Link)this.linkService.get((Serializable)linkId);
        return Optional.ofNullable(link).map(LinkDto::fromEntity).orElseThrow(() -> new IllegalArgumentException(this.messageHelper.getMessage("Nie_znaleziono_zestawu_dokumentow", new Object[]{linkId})));
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"search/{id}/indexes"})
    @ResponseBody
    public List<IndexModelDto> getIndexesForLinkSearch(@PathVariable Long id) {
        List links = this.linkService.getLinkIndicesForLink(id);
        return links.stream().map(IndexModelDto::fromDocumentLinkIndexEntity).toList();
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"search/{id}/classes"})
    @ResponseBody
    public List<DocumentClassLinkModelDto> getClassesForLinkSearch(@PathVariable Long id) {
        Link link = this.linkService.getLink(id, new String[]{"connections", "connections.documentClass"});
        Set<Long> documentClassIds = link.getConnections().stream().map(linkConnection -> linkConnection.getDocumentClass().getId()).collect(Collectors.toSet());
        return this.getDocumentClassesCheckboxes(documentClassIds, UserContext.current().getUser().getUserName());
    }

    private List<DocumentClassLinkModelDto> getDocumentClassesCheckboxes(Set<Long> documentClassIds, String username) {
        return documentClassIds.stream().map(documentClassId -> {
            boolean hasRights;
            DocumentClass docClass = (DocumentClass)this.documentClassService.get((Serializable)documentClassId);
            String name = this.documentClassService.getDocumentClassTranslation(docClass.getId(), TranslatedFieldType.NAME);
            String rightLevel = RightTreeBuilder.builder().system().archive().docClasses().custom((Object)docClass.getId()).build();
            try {
                hasRights = Authorization.checkRight((String)rightLevel, (String)username, (boolean)false, (boolean)false) != -1;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return new DocumentClassLinkModelDto(docClass.getId(), name, hasRights);
        }).toList();
    }

    @ApiOperation(value="(Admin) Downloading document set indices", notes="Retrieves a list of document set indices")
    @GetMapping(value={"/{id}/index"})
    @ResponseBody
    public CountedResult<LinkIndexDto> getIndexesForLink(@ApiParam(value="Result number from which results are to be returned") @RequestParam(required=false) Integer start, @ApiParam(value="Number of returned results") @RequestParam(required=false) Integer limit, @ApiParam(value="Sort by", defaultValue="indexOrder") @RequestParam(required=false, defaultValue="indexOrder") String orderBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection, @ApiParam(value="Link id", required=true) @PathVariable Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Link link = this.linkService.getLink(id, new String[0]);
        List links = this.linkService.getLinkIndicesForLink(id);
        links.forEach(linkIndex -> linkIndex.setLink(link));
        List linksDto = links.stream().map(LinkIndexDto::from).sorted((Comparator<LinkIndexDto>)DtoComparator.of(LinkIndexDto.class, (String)orderBy, (SortDirection)orderDirection).withIgnoreCase(true).withSupport("indexTypeName", LinkIndexDto::getIndexType)).collect(Collectors.toList());
        return Paginator.forAll(linksDto).viewPageByOffset(start, limit);
    }

    @ApiOperation(value="(Admin) Adding document set index", notes="Adds document set index")
    @PostMapping(value={"/{id}/index"})
    @ResponseBody
    public RestResult addIndexForLink(HttpServletRequest request, @ApiParam(value="The query contains a JSON object containing index parameters. The definition should include the following field \n- **indexName** - name of the index\n- **indexDescription** - description of the index\n- **indexType** - type of the index (integer, float, string, date, list, dateTime, boolean)\n- **indexValues** - values of the index", required=true) @RequestBody LinkIndexDto linkIndexDto, @ApiParam(value="Id of the document set", required=true) @PathVariable Long id) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("linkId", id);
        auditParams.put("indexName", StringUtils.defaultString((String)linkIndexDto.getIndexName()));
        auditParams.put("indexDescription", StringUtils.defaultString((String)linkIndexDto.getIndexDescription()));
        auditParams.put("indexType", StringUtils.defaultString((String)linkIndexDto.getIndexType()));
        auditParams.put("indexValue", StringUtils.defaultString((String)linkIndexDto.getIndexValues()));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_LINK_INDEX).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Link link = (Link)this.linkService.get((Serializable)id);
        if (link == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new LinkNotFoundException(this.messageHelper.getMessage("Zestaw_dokumentow_nie_istnieje"));
        }
        LinkIndex linkIndex = LinkIndexDto.toEntity(linkIndexDto, id);
        try {
            this.linkService.addLinkIndex(linkIndex);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Editing document set index", notes="Edits document set index")
    @PatchMapping(value={"/{id}/index/{indexId}"})
    @ResponseBody
    public RestResult updateIndexForLink(HttpServletRequest request, @ApiParam(value="The query contains a JSON object containing index parameters. The definition should include the following fields \n- **indexName** - name of the index\n- **indexDescription** - description of the index\n- **indexType** - type of the index (integer, float, string, date, list, dateTime, boolean)\n- **indexValues** - values of the index", required=true) @RequestBody LinkIndexDto linkIndexDto, @ApiParam(value="Id of the document set", required=true) @PathVariable Long id, @ApiParam(value="Id of the document set index", required=true) @PathVariable Long indexId) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("linkId", id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_LINK_INDEX).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Link link = (Link)this.linkService.get((Serializable)id);
        if (link == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new LinkNotFoundException(this.messageHelper.getMessage("Zestaw_dokumentow_nie_istnieje"));
        }
        LinkIndex linkIndex = this.linkService.getLinkIndex(indexId, new String[0]);
        if (linkIndex == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new ServiceException(this.messageHelper.getMessage("Indeks_zestawu_dokumentow_nie_istnieje"));
        }
        auditParams.put("indexName", linkIndex.getName() + " > " + linkIndexDto.getIndexName());
        auditParams.put("indexDescription", linkIndex.getDescription() + " > " + linkIndexDto.getIndexDescription());
        auditParams.put("indexType", linkIndex.getType() + ";" + linkIndexDto.getIndexType());
        auditParams.put("indexValue", linkIndex.getValues() + " > " + linkIndexDto.getIndexValues());
        auditBuilder.params(auditParams);
        linkIndex.setName(linkIndexDto.getIndexName());
        linkIndex.setDescription(linkIndexDto.getIndexDescription());
        linkIndex.setType(linkIndexDto.getIndexType());
        linkIndex.setValues(linkIndexDto.getIndexValues());
        try {
            this.linkService.updateLinkIndex(linkIndex);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Downloading document set indices", notes="Exports a list of document set indices")
    @GetMapping(value={"/{id}/index/export/{extension}"})
    @ResponseBody
    public void exportLinksIndexes(HttpServletResponse response, @ApiParam(value="Link id", required=true) @PathVariable Long id, @ApiParam(value="Extension", required=true) @PathVariable String extension, @ApiParam(value="Sort by", defaultValue="indexOrder") @RequestParam(required=false, defaultValue="indexOrder") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Link link = this.linkService.getLink(id, new String[0]);
        List links = this.linkService.getLinkIndicesForLink(id);
        links.forEach(linkIndex -> linkIndex.setLink(link));
        List linksDto = links.stream().map(LinkIndexDto::from).sorted((Comparator<LinkIndexDto>)DtoComparator.of(LinkIndexDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true).withSupport("indexTypeName", LinkIndexDto::getIndexType)).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_indeksu")).data(linksDto).by(LinkIndexDto::getTranslatedIndexName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis_indeksu")).data(linksDto).by(LinkIndexDto::getIndexDescription).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Typ_indeksu")).data(linksDto).by(LinkIndexDto::getIndexTypeName).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Indeksy")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping
    @ResponseBody
    public RestResult addLink(HttpServletRequest request, @RequestBody LinkDto link) {
        long linkId;
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("linkName", StringUtils.defaultString((String)link.getName()));
        auditParams.put("linkDescr", StringUtils.defaultString((String)link.getDescription()));
        auditParams.put("icon", StringUtils.defaultString((String)link.getIconName()));
        auditParams.put("iconColor", StringUtils.defaultString((String)link.getIconColor()));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_LINK).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            linkId = this.linkService.addLink(LinkController.toEntity(link));
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        auditParams.put("linkId", linkId);
        auditBuilder.params(auditParams);
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="", hidden=true)
    @PostMapping(value={"/{linkId}/connections"})
    @ResponseBody
    public RestResult addLinkConnection(HttpServletRequest request, @PathVariable Long linkId, @RequestBody UpsertLinkConnectionDto linkConnection) {
        HashMap<String, Long> auditParams = new HashMap<String, Long>();
        auditParams.put("linkId", linkId);
        auditParams.put("docClassId", linkConnection.getDocumentClassId());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_LINK_CONNECTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.linkService.addLinkConnection(linkId.longValue(), linkConnection.getLinkIndexId().longValue(), linkConnection.getDocumentClassId().longValue(), linkConnection.getDocumentClassIndexId().longValue());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Updating document set", notes="Updates document set with given id")
    @PatchMapping(value={"{id}"})
    @ResponseBody
    public RestResult changeLink(HttpServletRequest request, @ApiParam(value="The query contains a JSON object containing document set parameters. The definition should include the following fields\n- **name** - name of the document set\n- **description** - description of the set\n- **iconName** - icon\n- **iconColor** - color of the icon", required=true) @RequestBody LinkDto linkDto, @ApiParam(value="Link id", required=true) @PathVariable Long id) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("linkId", id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_LINK).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Link originalLink = (Link)this.linkService.get((Serializable)id);
        if (originalLink == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new LinkNotFoundException(this.messageHelper.getMessage("Zestaw_dokumentow_nie_istnieje"));
        }
        auditParams.put("linkId", id);
        auditParams.put("linkName", originalLink.getName() + ";" + linkDto.getName());
        auditParams.put("linkDescr", originalLink.getDescription() + ";" + linkDto.getDescription());
        auditParams.put("icon", originalLink.getIconName() + ";" + linkDto.getIconName());
        auditParams.put("iconColor", originalLink.getIconColor() + ";" + linkDto.getIconColor());
        auditBuilder.params(auditParams);
        Link link = LinkController.toEntity(linkDto);
        link.setId(id);
        try {
            this.linkService.changeLink(link);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Deleting document set", notes="Deletes document set with given id")
    @DeleteMapping(value={"{id}"})
    @ResponseBody
    public RestResult deleteLink(HttpServletRequest request, @ApiParam(value="Id of the document set", required=true) @PathVariable Long id) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("linkId", id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_LINK).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        Link link = this.linkService.getLink(id, new String[0]);
        if (link == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new LinkNotFoundException(this.messageHelper.getMessage("Zestaw_dokumentow_nie_istnieje"));
        }
        auditParams.put("linkName", link.getName());
        auditParams.put("linkDescr", link.getDescription());
        auditParams.put("icon", link.getIconName());
        auditParams.put("iconColor", link.getIconColor());
        auditBuilder.params(auditParams);
        try {
            this.linkService.deleteLink(id);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="", hidden=true)
    @DeleteMapping(value={"/{linkId}/index/{id}"})
    @ResponseBody
    public RestResult deleteLinkIndex(HttpServletRequest request, @PathVariable Long linkId, @PathVariable Long id) throws SQLException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_LINK_INDEX).params((Map)new ImmutableMap.Builder().put((Object)"linkId", (Object)linkId).put((Object)"indexId", (Object)id).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (this.linkService.getLink(linkId, new String[0]) == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new LinkNotFoundException(this.messageHelper.getMessage("Zestaw_dokumentow_nie_istnieje"));
        }
        try {
            this.linkService.deleteLinkIndex(id);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="", hidden=true)
    @GetMapping(value={"/{id}/connections"})
    @ResponseBody
    public CountedResult<LinkConnectionDto> getConnectionsForLink(@RequestParam(required=false, defaultValue="0") Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="id") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection, @PathVariable Long id) {
        this.authorizationHelper.assertFullOrPartRights(RightTreeBuilder.builder().system().archive().links().custom((Object)id).build(), () -> {});
        List connections = this.linkService.getLinkConnectionsForLink(id, new String[]{"link", "documentClass", "linkIndex", "documentClassIndex"}).stream().map(LinkConnectionDto::fromEntity).sorted((Comparator<LinkConnectionDto>)DtoComparator.of(LinkConnectionDto.class, (String)orderBy, (SortDirection)orderDirection).withIgnoreCase(true).withSupport("index", linkConnection -> linkConnection.getLinkIndexDto() != null ? linkConnection.getLinkIndexDto().getTranslatedName() : "").withSupport("documentClassIndex", linkConnection -> linkConnection.getDocumentClassIndexDto() != null ? linkConnection.getDocumentClassIndexDto().getTranslatedName() : "").withSupport("documentClass", linkConnection -> linkConnection.getDocumentClassDto() != null ? linkConnection.getDocumentClassDto().getTranslatedName() : "")).collect(Collectors.toList());
        return Paginator.forAll(connections).viewPageByOffset(start, limit);
    }

    @ApiOperation(value="", hidden=true)
    @DeleteMapping(value={"/{linkId}/connections/{id}"})
    @ResponseBody
    public RestResult deleteLinkConnection(HttpServletRequest request, @PathVariable Long linkId, @PathVariable Long id) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_LINK_CONNECTION).params((Map)new ImmutableMap.Builder().put((Object)"linkId", (Object)linkId).put((Object)"connectionId", (Object)id).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            this.linkService.deleteLinkConnection(id);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @GetMapping(value={"/{id}/connections/export/{extension}"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public void exportConnectionsForLink(HttpServletResponse response, @PathVariable String extension, @RequestParam(required=false, defaultValue="id") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection, @PathVariable Long id) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List connections = this.linkService.getLinkConnectionsForLink(id, new String[]{"link", "documentClass", "linkIndex", "documentClassIndex"}).stream().map(LinkConnectionDto::fromEntity).sorted((Comparator<LinkConnectionDto>)DtoComparator.of(LinkConnectionDto.class, (String)orderBy, (SortDirection)orderDirection).withIgnoreCase(true).withSupport("index", linkConnection -> linkConnection.getLinkIndexDto() != null ? linkConnection.getLinkIndexDto().getTranslatedName() : "").withSupport("documentClassIndex", linkConnection -> linkConnection.getDocumentClassIndexDto() != null ? linkConnection.getDocumentClassIndexDto().getTranslatedName() : "").withSupport("documentClass", linkConnection -> linkConnection.getDocumentClassDto() != null ? linkConnection.getDocumentClassDto().getTranslatedName() : "")).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_indeksu")).data(connections).by(linkConnection -> linkConnection.getLinkIndexDto() != null ? linkConnection.getLinkIndexDto().getTranslatedName() : "").build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Indeks")).data(connections).by(linkConnection -> linkConnection.getDocumentClassIndexDto() != null ? linkConnection.getDocumentClassIndexDto().getTranslatedName() : "").build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Klasa_dokumentow")).data(connections).by(linkConnection -> linkConnection.getDocumentClassDto() != null ? linkConnection.getDocumentClassDto().getTranslatedName() : "").build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Powiazania")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"/{linkId}/index/{linkIndexId}/moveUp"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public void moveUpDocumentLinkIndex(@PathVariable Long linkId, @PathVariable Long linkIndexId) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        this.linkService.moveUpDocumentLinkIndex(linkIndexId);
    }

    @ApiOperation(value="Exporting document sets", notes="Exports a list of available document sets for logged-in user")
    @GetMapping(value={"/export/{extension}"})
    @ResponseBody
    public void exportLinks(HttpServletResponse response, @ApiParam(value="Extension", required=true) @PathVariable String extension, @ApiParam(value="Sort by", defaultValue="id") @RequestParam(required=false, defaultValue="id") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id) throws IOException {
        List<Object> links;
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        if (id != null) {
            links = this.exportCache.get(id);
            this.exportCache.remove(id);
        } else {
            links = this.linkService.getLinks(UserContext.current().getUser().getUserName()).stream().map(LinkDto::fromEntity).sorted((Comparator<LinkDto>)DtoComparator.of(LinkDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        }
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_zestawu_dokumentow")).data(links).by(LinkDto::getTranslatedName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis_zestawu_dokumentow")).data(links).by(LinkDto::getTranslatedDescription).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Zestawy_dokumentow")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ApiOperation(value="(Admin) Downloading document set protections", notes="Retrieves a list of document set protections")
    @GetMapping(value={"{id}/protections"})
    @ResponseBody
    public CountedResult<LinkProtection> getLinkProtections(@ApiParam(value="Link id", required=true) @PathVariable Long id, @ApiParam(value="Result number from which results are to be returned", required=true) @RequestParam Integer start, @ApiParam(value="Number of returned results", required=true) @RequestParam Integer limit, @ApiParam(value="Sort by", defaultValue="userName") @RequestParam(required=false, defaultValue="userName") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List linkProtections = this.linkService.getLinkProtections(id).stream().sorted(DtoComparator.of(LinkProtection.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(linkProtections).viewPageByOffset(start, limit);
    }

    @ApiOperation(value="(Admin) Adding document set index", notes="Adds document set index")
    @PostMapping(value={"{id}/protections"})
    @ResponseBody
    public RestResult addLinkProtection(HttpServletRequest request, @ApiParam(value="Id of the document set", required=true) @PathVariable Long id, @ApiParam(value="The query contains a JSON object containing index parameters. The definition should include the following field \n- **userName** - name of the resource\n- **isGroup** - is resource a group", required=true) @RequestBody LinkProtection protection) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("linkId", id);
        auditParams.put("userName", protection.getUserName());
        auditParams.put("isGroup", protection.getIsGroup().toString());
        auditParams.put("rightLevel", protection.getRightLevel());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_LINK_PROTECTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (this.linkService.get((Serializable)id) == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new LinkNotFoundException(this.messageHelper.getMessage("Zestaw_dokumentow_nie_istnieje"));
        }
        try {
            this.linkService.addLinkProtection(id, protection);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Deleting document set protection", notes="Deletes document set protection")
    @DeleteMapping(value={"{id}/protections"})
    @ResponseBody
    public RestResult deleteLinkProtection(HttpServletRequest request, @ApiParam(value="Id of the document set", required=true) @PathVariable Long id, @ApiParam(value="Name of the resource", required=true) @RequestParam String username, @ApiParam(value="Is resource a group", required=true) @RequestParam Boolean isGroup) {
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("linkId", id);
        auditParams.put("userId", username);
        auditParams.put("isGroup", isGroup.toString());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_LINK_PROTECTION).params(auditParams);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        if (this.linkService.get((Serializable)id) == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new LinkNotFoundException(this.messageHelper.getMessage("Zestaw_dokumentow_nie_istnieje"));
        }
        try {
            this.linkService.deleteLinkProtection(id, username, isGroup);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @ApiOperation(value="(Admin) Downloading document set protections", notes="Exports a list of document set protections")
    @GetMapping(value={"{id}/protections/export/{extension}"})
    @ResponseBody
    public void exportLinkProtections(@ApiParam(value="Link id", required=true) @PathVariable Long id, HttpServletResponse response, @ApiParam(value="Extension", required=true) @PathVariable String extension, @ApiParam(value="Sort by", defaultValue="userName") @RequestParam(required=false, defaultValue="userName") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List linkProtections = this.linkService.getLinkProtections(id).stream().sorted(DtoComparator.of(LinkProtection.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_uzytkownika_grupy")).data(linkProtections).by(LinkProtection::getUserName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Grupa")).data(linkProtections).by(linkProtection -> this.messageHelper.getMessage(String.valueOf(linkProtection.getIsGroup()))).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Poziom_uprawnienia")).data(linkProtections).by(linkProtection -> this.messageHelper.getMessage(StringUtils.capitalize((String)linkProtection.getRightLevel()))).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Uprawnienia")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"/export/{extension}"})
    @ResponseBody
    @ApiOperation(value="", hidden=true)
    public URI exportFilteredLinks(HttpServletRequest request, @RequestBody List<LinkDto> links, @PathVariable String extension) throws URISyntaxException {
        UUID id;
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        while (this.exportCache.containsKey(id = UUID.randomUUID())) {
        }
        this.exportCache.put(id, links);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    private static Link toEntity(LinkDto dto) {
        Link link = new Link();
        link.setName(dto.getName());
        link.setDescription(dto.getDescription());
        link.setIconName(dto.getIconName());
        link.setIconColor(dto.getIconColor());
        return link;
    }

    @ExceptionHandler(value={LinkAlreadyExistsException.class, LinkNotFoundException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleNotFoundAndAlreadyExistsException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NoRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNoRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    record DocumentClassLinkModelDto(Long id, String name, boolean hasRights) {
    }
}

