/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.system;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.configuration.ImmutableSystemParameters;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.SystemParameterFinder;
import com.suncode.pwfl.administration.configuration.SystemParameterService;
import com.suncode.pwfl.administration.configuration.exception.SystemParameterAlreadyExists;
import com.suncode.pwfl.administration.configuration.exception.SystemParameterNotExists;
import com.suncode.pwfl.administration.configuration.exception.UnauthorizedHiddenSystemParameterException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.dto.administration.CategoryDto;
import com.suncode.pwfl.web.dto.administration.ComboValueDto;
import com.suncode.pwfl.web.dto.administration.SystemParameterDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.util.JsonMessage;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/system/parameters"})
public class SystemParameterController {
    private static final Logger log = LoggerFactory.getLogger(SystemParameterController.class);
    private static final String KEY_AUDIT_PARAM = "parameterKey";
    private static final String TYPE_AUDIT_PARAM = "type";
    private static final String VALUE_AUDIT_PARAM = "value";
    private final SystemParameterService paramService;
    private final SystemParameterFinder paramFinder;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @ResponseBody
    @RequestMapping(value={"all"}, method={RequestMethod.GET})
    public List<CategoryDto> getAll(HttpSession session) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        String username = (String)session.getAttribute("username");
        boolean showHiddenParameters = username.equals("admin");
        List categories = this.paramFinder.getAllCategories(new String[]{"systemParameters"});
        return categories.stream().map(CategoryDto::create).peek(category -> category.getSystemParameters().removeIf(parameter -> !showHiddenParameters && parameter.isHidden())).peek(category -> Collections.sort(category.getSystemParameters())).sorted().collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"category"}, method={RequestMethod.GET})
    public List<SystemParameterDto> getParameters(@RequestParam String category, HttpSession session) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        String username = (String)session.getAttribute("username");
        boolean showHiddenParameters = username.equals("admin");
        List parameters = this.paramFinder.findByCategory(category, new String[0]);
        return parameters.stream().filter(parameter -> showHiddenParameters || !parameter.isHidden()).map(SystemParameterDto::create).sorted().collect(Collectors.toList());
    }

    @ResponseBody
    @RequestMapping(value={"update/multiple"}, method={RequestMethod.POST})
    public JsonMessage updateParameters(@RequestBody List<SystemParameterDto> systemParameters, HttpServletRequest request, HttpSession session) throws Exception {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SYSTEM_PARAMETER_CHANGED);
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        HashMap<String, String> oldValues = new HashMap<String, String>();
        String username = (String)session.getAttribute("username");
        boolean updateHiddenParameters = username.equals("admin");
        try {
            Set updatedParameters = systemParameters.stream().peek(parameter -> {
                String parameterKey = parameter.getParameterKey();
                if (!ImmutableSystemParameters.canChange((String)parameterKey)) {
                    throw new IllegalArgumentException(this.messageHelper.getMessage("Parametr_nie_moze_zostac_zmieniony", new Object[]{parameterKey}));
                }
            }).filter(parameter -> {
                if (updateHiddenParameters || !parameter.isHidden()) {
                    String parameterKey = parameter.getParameterKey();
                    SystemParameter systemParameter = this.paramService.getParameter(parameterKey);
                    oldValues.put(parameterKey, systemParameter.getValueString());
                    return this.updateParameter((SystemParameterDto)parameter, systemParameter);
                }
                return false;
            }).collect(Collectors.toCollection(HashSet::new));
            request.setAttribute("audit", (Object)auditBuilder.params((Map)ImmutableMap.of((Object)"changedParameters", (Object)this.formatAuditParameters(updatedParameters, oldValues))).buildSuccess());
        }
        catch (UnauthorizedHiddenSystemParameterException e) {
            log.error(e.getMessage(), (Throwable)e);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new JsonMessage(false, ex.getMessage());
        }
        return new JsonMessage();
    }

    private boolean updateParameter(SystemParameterDto parameterDto, SystemParameter systemParameter) {
        boolean comboUpdated = false;
        boolean valueUpdated = this.paramService.updateValue(parameterDto.getValue(), systemParameter);
        List<ComboValueDto> comboValuesDto = parameterDto.getComboValues();
        if (CollectionUtils.isNotEmpty(comboValuesDto) && systemParameter.getParameterType().equals((Object)ParameterType.COMBOBOX)) {
            List comboValues = comboValuesDto.stream().map(comboValueDto -> comboValueDto.convert(systemParameter)).collect(Collectors.toList());
            comboUpdated = this.paramService.updateComboValues(systemParameter, comboValues);
            parameterDto.setValue(systemParameter.getValue().toString());
        }
        return valueUpdated || comboUpdated;
    }

    @ResponseBody
    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public JsonMessage createParameter(@RequestBody SystemParameterDto parameterDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SYSTEM_PARAMETER_CREATED).params((Map)ImmutableMap.builder().put((Object)KEY_AUDIT_PARAM, (Object)parameterDto.getParameterKey()).put((Object)TYPE_AUDIT_PARAM, (Object)this.translateParameterType(parameterDto.getParameterType())).put((Object)VALUE_AUDIT_PARAM, (Object)this.formatAuditParameterValue(parameterDto.getValue(), parameterDto.getParameterType())).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        try {
            parameterDto.validate();
        }
        catch (IllegalArgumentException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new JsonMessage(false, ex.getMessage());
        }
        try {
            this.paramService.create(parameterDto.convert());
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new JsonMessage();
        }
        catch (SystemParameterAlreadyExists ex) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new JsonMessage(false, this.messageHelper.getMessage("Parametr_juz_istnieje"));
        }
        catch (UnauthorizedHiddenSystemParameterException e) {
            log.error(e.getMessage(), (Throwable)e);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @Transactional
    @RequestMapping(value={"delete/{parameterKey}"}, method={RequestMethod.DELETE})
    public JsonMessage deleteParameter(@PathVariable String parameterKey, HttpServletRequest request) throws SystemParameterNotExists {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SYSTEM_PARAMETER_REMOVED).params((Map)ImmutableMap.of((Object)KEY_AUDIT_PARAM, (Object)parameterKey));
        this.authorizationHelper.assertFullAdministrationRights(() -> auditBuilder.buildFailure(request));
        SystemParameter param = this.paramService.getParameter(parameterKey);
        if (param == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new JsonMessage(false, this.messageHelper.getMessage("Parametr_systemowy_nie_istnieje"));
        }
        if (!param.isRemovable()) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            return new JsonMessage(false, this.messageHelper.getMessage("Nie_mozna_usunac_parametru"));
        }
        try {
            this.paramService.delete(parameterKey);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new JsonMessage();
        }
        catch (UnauthorizedHiddenSystemParameterException e) {
            log.error(e.getMessage(), (Throwable)e);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"canSeeHidden"}, method={RequestMethod.GET})
    public Boolean canSeeHiddenParams(HttpSession session) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        String username = (String)session.getAttribute("username");
        return username.equals("admin");
    }

    private String formatAuditParameters(Collection<SystemParameterDto> systemParameters, Map<String, String> oldValues) {
        return systemParameters.stream().map(parameter -> this.formatAuditParameter((SystemParameterDto)parameter, (String)oldValues.get(parameter.getParameterKey()))).collect(Collectors.joining("; "));
    }

    private String formatAuditParameter(SystemParameterDto parameter, String oldParamValue) {
        String paramType = parameter.getParameterType();
        String value = this.formatAuditParameterValue(parameter.getValue(), paramType);
        String oldValue = this.formatAuditParameterValue(oldParamValue, paramType);
        StringBuilder builder = new StringBuilder();
        builder.append(parameter.getParameterKey()).append(": ").append(oldValue).append(" > ").append(value);
        return builder.toString();
    }

    private String formatAuditParameterValue(String value, String type) {
        if (ParameterType.valueOf((String)type) == ParameterType.PASSWORD) {
            return IntStream.range(0, 8).mapToObj(val -> "*").collect(Collectors.joining(""));
        }
        return StringUtils.isBlank((CharSequence)value) ? "" : value;
    }

    private String translateParameterType(String parameterType) {
        switch (parameterType) {
            case "TEXT": {
                return this.messageHelper.getMessage("Tekstowy");
            }
            case "DATE": {
                return this.messageHelper.getMessage("Datowy");
            }
            case "LONG": {
                return this.messageHelper.getMessage("Calkowity");
            }
            case "BOOLEAN": {
                return this.messageHelper.getMessage("Logiczny");
            }
            case "COMBOBOX": {
                return this.messageHelper.getMessage("Lista_wartosci");
            }
            case "PASSWORD": {
                return this.messageHelper.getMessage("Haslo");
            }
            case "DOUBLE": {
                return this.messageHelper.getMessage("Zmiennoprzecinkowy");
            }
        }
        return parameterType;
    }

    @ExceptionHandler(value={NotFullRightsException.class, UnauthorizedHiddenSystemParameterException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public JsonMessage handleUnauthorizedException(Exception e) {
        String message = e instanceof NotFullRightsException ? this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji") : e.getMessage();
        log.info(message);
        return new JsonMessage(false, message);
    }

    @ConstructorProperties(value={"paramService", "paramFinder", "authorizationHelper", "messageHelper"})
    @Autowired
    public SystemParameterController(SystemParameterService paramService, SystemParameterFinder paramFinder, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.paramService = paramService;
        this.paramFinder = paramFinder;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

