/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.substitutions;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemPropertiesBean;
import com.suncode.pwfl.administration.substitution.Substitution;
import com.suncode.pwfl.administration.substitution.SubstitutionAddingType;
import com.suncode.pwfl.administration.substitution.SubstitutionDto;
import com.suncode.pwfl.administration.substitution.SubstitutionFormDto;
import com.suncode.pwfl.administration.substitution.SubstitutionHook;
import com.suncode.pwfl.administration.substitution.SubstitutionService;
import com.suncode.pwfl.administration.substitution.SubstitutionType;
import com.suncode.pwfl.administration.substitution.exception.SubstitutionException;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.hook.HookRegistry;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.controller.api.substitutions.SubstitutionMapper;
import com.suncode.pwfl.web.security.exception.NoRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"substitutions"})
@Api(tags={"substitutions"})
public class SubstitutionController {
    private static final Logger log = LoggerFactory.getLogger(SubstitutionController.class);
    private final SubstitutionService substitutionService;
    private final SystemPropertiesBean systemProperties;
    private final ExportService exportService;
    private final MessageHelperBean messageHelper;
    private final SubstitutionMapper substitutionMapper;
    private final HookRegistry hookRegistry;
    private final ProcessService processService;

    @ApiOperation(value="Downloading a list of system substitutions", notes="Retrieves a list of substitutions for logged-in user")
    @GetMapping
    @ResponseBody
    public CountedResult<SubstitutionDto> getSubstitutions(HttpServletRequest request, SubstitutionFormDto substitutionFormDto, @ApiParam(value="Result number from which results are to be returned", required=true) @RequestParam Integer start, @ApiParam(value="Number of returned results", required=true) @RequestParam Integer limit, @ApiParam(value="Sort by", defaultValue="lStartDate") @RequestParam(required=false, defaultValue="lStartDate") String sortBy, @ApiParam(value="Sort direction", defaultValue="DESC", allowableValues="ASC,DESC") @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) {
        String username = UserContext.current().getUser().getUserName();
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("processName", (Object)StringUtils.defaultString((String)substitutionFormDto.getProcessDefId(), (String)"*")).param("participantName", (Object)StringUtils.defaultString((String)substitutionFormDto.getRoleId(), (String)"*")).param("usernameId", (Object)StringUtils.defaultString((String)substitutionFormDto.getSubstitutedUsername())).param("delegatedUserName", (Object)StringUtils.defaultString((String)substitutionFormDto.getSubstituteUsername())).param("startDate", (Object)StringUtils.defaultIfEmpty((String)substitutionFormDto.getStartDate(), (String)"*")).param("finishDate", (Object)StringUtils.defaultIfEmpty((String)substitutionFormDto.getFinishDate(), (String)"*"));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_SUBSTITUTIONS).params(auditParamsBuilder.build());
        auditBuilder.buildSuccess(request);
        return this.substitutionService.findSubstitutionsByFilters(username, this.getDisplayType(username), substitutionFormDto, start, limit, sortBy, sortDirection, substitutionFormDto.getOnlyActive());
    }

    private String getDisplayType(String username) {
        String displayType = this.systemProperties.getString(DefinedSystemParameter.DELEGATION_TYPE);
        if (displayType == null || Authorization.checkIsUserAdmin((String)username)) {
            displayType = SubstitutionType.ALL.toString();
        }
        return displayType;
    }

    @ApiOperation(value="Adding a new substitution", notes="Adds a new substitution")
    @PostMapping
    @ResponseBody
    public RestResult addSubstitution(@ApiParam(value="The executed query saves new calendar share. The query is a JSON object with the following fields\n- **processDefId** - Name of the process definition\n- **roleId** - Id of the role in that process\n- **substitutedUsername** - Name of the substituted user\n- **substituteUsername** - Name of the substitute\n- **startDate** - Start date\n- **finishDate** - Finish date", required=true) @RequestBody SubstitutionFormDto substitutionFormDto) throws ParseException {
        String username = UserContext.current().getUser().getUserName();
        if (!substitutionFormDto.getSubstitutedUsername().equals(username) && !this.loggedUserHasAdminRights()) {
            throw new NoRightsException(this.messageHelper.getMessage("Brak_uprawnien_do_dodania_zastepstwa_dla_innego_uzytkownika"));
        }
        if (this.hookRegistry.hasHooks(SubstitutionHook.class) && substitutionFormDto.getProcessDefId().equals("*")) {
            LinkedList<Substitution> substitutions = new LinkedList<Substitution>();
            Substitution substitution = this.substitutionMapper.toEntity(substitutionFormDto);
            List userProcessesTypes = ((SubstitutionHook)this.hookRegistry.invoke(SubstitutionHook.class)).filterProcesses(substitutionFormDto.getSubstitutedUsername(), this.processService.getAllProcessTypes(false));
            for (ProcessType processType : userProcessesTypes) {
                Substitution toAdd = new Substitution(null, processType.getProcessDefId(), substitution.getRole(), substitution.getSubstituted(), substitution.getSubstitute(), null, null);
                toAdd.setFinishDate(substitution.getFinishDate());
                toAdd.setStartDate(substitution.getStartDate());
                substitutions.add(toAdd);
            }
            this.substitutionService.addSubstitutions(substitutions);
            return new RestResult(true, SubstitutionAddingType.SUBSTITUTION_NEW.toString());
        }
        Substitution substitution = this.substitutionMapper.toEntity(substitutionFormDto);
        SubstitutionAddingType substitutionAddingType = this.substitutionService.addSubstitution(substitution);
        return new RestResult(true, substitutionAddingType.toString());
    }

    @ApiOperation(value="Deleting substitution", notes="Deletes substitution with given id")
    @DeleteMapping(value={"{id}"})
    @ResponseBody
    public RestResult deleteSubstitution(@ApiParam(value="Id of the substitution", required=true) @PathVariable Long id) {
        this.substitutionService.deleteSubstitution(id);
        return new RestResult(true);
    }

    @ApiOperation(value="Exporting a list of system substitutions", notes="Exports a list of substitutions for logged-in user")
    @GetMapping(value={"export/{extension}"})
    public void exportSubstitutions(HttpServletResponse response, SubstitutionFormDto substitutionFormDto, @ApiParam(value="Extension", required=true) @PathVariable String extension, @ApiParam(value="Sort by", defaultValue="substitute") @RequestParam(required=false, defaultValue="substitute") String sortBy, @ApiParam(value="Sort direction", defaultValue="ASC", allowableValues="ASC,DESC") @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws IOException {
        String username = UserContext.current().getUser().getUserName();
        List substitutions = substitutionFormDto != null ? this.substitutionService.findSubstitutionsByFilters(username, this.getDisplayType(username), substitutionFormDto, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), sortBy, sortDirection, substitutionFormDto.getOnlyActive()).getData() : this.substitutionService.findSubstitutions(UserContext.current().getUser().getUserName(), this.getDisplayType(username), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), sortBy, sortDirection).getData();
        List<ExportColumn> columns = Arrays.asList(this.buildExportColumn(this.messageHelper.getMessage("Proces"), substitutions, SubstitutionDto::getProcessDefName), this.buildExportColumn(this.messageHelper.getMessage("Uczestnik"), substitutions, SubstitutionDto::getRoleName), this.buildExportColumn(this.messageHelper.getMessage("Uzytkownik"), substitutions, SubstitutionDto::getSubstitutedFullName), this.buildExportColumn(this.messageHelper.getMessage("Zastepca"), substitutions, SubstitutionDto::getSubstituteFullName), this.buildExportColumn(this.messageHelper.getMessage("Od"), substitutions, SubstitutionDto::getStartDate), this.buildExportColumn(this.messageHelper.getMessage("Do"), substitutions, SubstitutionDto::getFinishDate));
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Zastepstwa")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private ExportColumn buildExportColumn(String name, List<SubstitutionDto> data, Function<SubstitutionDto, String> supplier) {
        return ExportColumnBuilder.create().name(name).data(data).by(supplier).build();
    }

    private boolean loggedUserHasAdminRights() {
        String username = UserContext.current().getUser().getUserName();
        try {
            return Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)username, (boolean)false, (boolean)false) == 0;
        }
        catch (SQLException e) {
            throw new ServiceException(this.messageHelper.getMessage("Blad_przy_sprawdzaniu_uprawnien_dla_uzytkownika", new Object[]{username}), (Throwable)e);
        }
    }

    @ExceptionHandler(value={SubstitutionException.class, ServiceException.class, NoRightsException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleBadRequest(Exception e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ConstructorProperties(value={"substitutionService", "systemProperties", "exportService", "messageHelper", "substitutionMapper", "hookRegistry", "processService"})
    @Autowired
    public SubstitutionController(SubstitutionService substitutionService, SystemPropertiesBean systemProperties, ExportService exportService, MessageHelperBean messageHelper, SubstitutionMapper substitutionMapper, HookRegistry hookRegistry, ProcessService processService) {
        this.substitutionService = substitutionService;
        this.systemProperties = systemProperties;
        this.exportService = exportService;
        this.messageHelper = messageHelper;
        this.substitutionMapper = substitutionMapper;
        this.hookRegistry = hookRegistry;
        this.processService = processService;
    }
}

