/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.scheduledtasks.method;

import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskMethodDto;
import com.suncode.pwfl.administration.scheduledtask.exception.ScheduledTaskParameterNotCompatibleException;
import com.suncode.pwfl.administration.scheduledtask.info.exceptions.ScheduledTaskParameterNotFoundException;
import com.suncode.pwfl.administration.scheduledtask.parameter.ScheduledTaskParameterFinder;
import com.suncode.pwfl.administration.scheduledtask.parameter.ScheduledTaskParameterSelector;
import com.suncode.pwfl.administration.scheduledtask.service.ScheduledTaskHelper;
import com.suncode.pwfl.web.controller.api.scheduledtasks.FileInfo;
import com.suncode.pwfl.web.controller.api.scheduledtasks.ScheduledTaskParameterBuilder;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ParameterInfo;
import com.suncode.pwfl.web.controller.api.scheduledtasks.dto.ParameterValue;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTaskReceivedParametersValidator {
    @Autowired
    private ScheduledTaskHelper scheduledTaskHelper;
    @Autowired
    private ScheduledTaskParameterFinder scheduledTaskParameterFinder;
    @Autowired
    private ScheduledTaskParameterBuilder scheduledTaskParameterBuilder;

    public void validateReceivedParametersAgainstMethod(List<ParameterInfo> receivedParameters, ScheduledTaskMethodDto methodDto, boolean isNewTask) {
        this.assertThatReceivedParametersAreConsistentAgainstMethod(receivedParameters, methodDto, isNewTask);
        this.assertThatAllReceivedParametersExistsInMethod(receivedParameters, methodDto);
    }

    private void assertThatReceivedParametersAreConsistentAgainstMethod(List<ParameterInfo> receivedParameters, ScheduledTaskMethodDto methodDto, boolean isNewTask) {
        for (ScheduledTaskMethodDto.Parameter methodParameterDto : methodDto.getParameters()) {
            boolean parameterCannotBeEmpty;
            boolean isParameterRequired = methodParameterDto.getIsOptional() == false && methodParameterDto.getDefaultValue() == null;
            Optional foundReceivedOpt = this.scheduledTaskParameterFinder.findIn(receivedParameters, this::toSelector).by(methodParameterDto);
            if (!foundReceivedOpt.isPresent()) {
                if (!isParameterRequired) continue;
                throw new ScheduledTaskParameterNotFoundException(String.format("Parameter of method %s at position %d of type %s is required, but received parameter is not present", methodDto, methodParameterDto.getPosition(), methodParameterDto));
            }
            ParameterInfo receivedParameter = (ParameterInfo)foundReceivedOpt.get();
            if (!StringUtils.equals((CharSequence)receivedParameter.getType(), (CharSequence)methodParameterDto.getType())) {
                throw new ScheduledTaskParameterNotCompatibleException(String.format("Parameter of method %s at position %d of type %s is not compatible with received parameter of type %s", methodDto, methodParameterDto.getPosition(), methodParameterDto, receivedParameter.getType()));
            }
            boolean isParameterEmptyAnywhere = this.isParameterEmptyAnywhere(receivedParameter);
            boolean bl = parameterCannotBeEmpty = isNewTask || !this.scheduledTaskHelper.isAnyFileType(receivedParameter.getType());
            if (!isParameterRequired || !isParameterEmptyAnywhere || !parameterCannotBeEmpty) continue;
            throw new ScheduledTaskParameterNotCompatibleException(String.format("Parameter of method %s at position %d of type %s is required, but received parameter is empty or one of its values is empty", methodDto, methodParameterDto.getPosition(), methodParameterDto));
        }
    }

    private boolean isParameterEmptyAnywhere(ParameterInfo receivedParameter) {
        if (receivedParameter.getValue() == null) {
            return true;
        }
        if (receivedParameter.getValue().isArray()) {
            ParameterValue.ArrayValue arrayValue = (ParameterValue.ArrayValue)receivedParameter.getValue();
            List<ParameterValue.SingleValue> values = arrayValue.getValue();
            if (this.scheduledTaskHelper.isFileTypeArray(receivedParameter.getType())) {
                return values.stream().map(this.scheduledTaskParameterBuilder::readFileInfo).anyMatch(fileInfo -> !fileInfo.isUploaded());
            }
            return values.stream().map(ParameterValue.SingleValue::getValue).anyMatch(StringUtils::isEmpty);
        }
        ParameterValue.SingleValue singleValue = (ParameterValue.SingleValue)receivedParameter.getValue();
        if (this.scheduledTaskHelper.isFileType(receivedParameter.getType())) {
            FileInfo fileInfo2 = this.scheduledTaskParameterBuilder.readFileInfo(singleValue);
            return !fileInfo2.isUploaded();
        }
        String value = singleValue.getValue();
        return StringUtils.isEmpty((CharSequence)value);
    }

    private void assertThatAllReceivedParametersExistsInMethod(List<ParameterInfo> receivedParameters, ScheduledTaskMethodDto methodDto) {
        for (ParameterInfo receivedParameter : receivedParameters) {
            this.scheduledTaskParameterFinder.findInMethod(methodDto).by((Object)receivedParameter, this::toSelector).orElseThrow(() -> new ScheduledTaskParameterNotCompatibleException(String.format("Received parameter at position %d does not exists in method %s", receivedParameter.getPosition(), methodDto)));
        }
    }

    private ScheduledTaskParameterSelector toSelector(ParameterInfo parameterInfo) {
        return new ScheduledTaskParameterSelector(parameterInfo.getComponentParameterId(), parameterInfo.getPosition());
    }
}

