/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.resource.share.CalendarResourceShare;
import com.suncode.pwfl.calendar.resource.share.CalendarResourceShareService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"calendar/resource/share"})
@Api(hidden=true)
public class CalendarResourceShareController {
    private static final Logger log = LoggerFactory.getLogger(CalendarResourceShareController.class);
    private final CalendarResourceShareService calendarResourceShareService;
    private final AuthorizationHelper authorizationHelper;

    @GetMapping
    public List<CalendarResourceShare> getCalendarResourceShares() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.calendarResourceShareService.getCalendarResourceShares();
    }

    @GetMapping(value={"/{id}"})
    public CalendarResourceShare getCalendarResourceShare(@PathVariable Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.calendarResourceShareService.getCalendarResourceShare(id);
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public CalendarResourceShare createCalendarResourceShare(@RequestBody CalendarResourceShare calendarResourceShare, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().params(this.paramsFromCalendarResourceShare(calendarResourceShare));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(calendarResourceShare.getResourceId() != null ? AuditTypes.AUDIT_CREATE_CALENDAR_RESOURCE_SHARE : AuditTypes.AUDIT_CREATE_CALENDAR_RESOURCE_GROUP_SHARE).params(auditParamsBuilder.build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            CalendarResourceShare createdCalendarResourceShare = this.calendarResourceShareService.createCalendarResourceShare(calendarResourceShare);
            auditParamsBuilder.param("id", (Object)createdCalendarResourceShare.getId()).params(this.paramsFromCalendarResourceShare(createdCalendarResourceShare));
            auditBuilder.params(auditParamsBuilder.build());
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return createdCalendarResourceShare;
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"/{id}"})
    public RestResult deleteCalendarResourceShare(@PathVariable Long id, @RequestParam CalendarResourceShareType shareType, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(shareType == CalendarResourceShareType.RESOURCE ? AuditTypes.AUDIT_DELETE_CALENDAR_RESOURCE_SHARE : AuditTypes.AUDIT_DELETE_CALENDAR_RESOURCE_GROUP_SHARE).params(new AuditParamsBuilder().param("id", (Object)id).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            CalendarResourceShare calendarResourceShare = this.calendarResourceShareService.getCalendarResourceShare(id);
            auditBuilder.type(calendarResourceShare.getResourceId() != null ? AuditTypes.AUDIT_DELETE_CALENDAR_RESOURCE_SHARE : AuditTypes.AUDIT_DELETE_CALENDAR_RESOURCE_GROUP_SHARE);
            this.calendarResourceShareService.deleteCalendarResourceShare(id);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"/resource/{resourceId}"})
    private CountedResult<CalendarResourceShare> getCalendarResourceSharesForResource(@PathVariable Long resourceId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="id") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<CalendarResourceShare> shares = this.calendarResourceShareService.getSharesForResource(resourceId).stream().sorted(this.getSharesComparator(sortBy, sortDirection)).toList();
        return Paginator.forAll(shares).viewPageByOffset(start, limit);
    }

    @GetMapping(value={"/group/{resourceGroupId}"})
    private CountedResult<CalendarResourceShare> getCalendarResourceSharesForResourceGroup(@PathVariable Long resourceGroupId, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false, defaultValue="id") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List<CalendarResourceShare> shares = this.calendarResourceShareService.getSharesForResourceGroup(resourceGroupId).stream().sorted(this.getSharesComparator(sortBy, sortDirection)).toList();
        return Paginator.forAll(shares).viewPageByOffset(start, limit);
    }

    private Comparator<CalendarResourceShare> getSharesComparator(String sortBy, SortDirection sortDirection) {
        return DtoComparator.of(CalendarResourceShare.class, (String)sortBy, (SortDirection)sortDirection).withSupport("userOrGroup", share -> share.getUsername() != null ? share.getUsername() : share.getGroup()).withSupport("isGroup", share -> share.getGroup() != null).withIgnoreCase(true);
    }

    private Map<String, Object> paramsFromCalendarResourceShare(CalendarResourceShare calendarResourceShare) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        if (calendarResourceShare.getUsername() != null) {
            auditParamsBuilder.param("username", (Object)calendarResourceShare.getUsername());
        }
        if (calendarResourceShare.getGroup() != null) {
            auditParamsBuilder.param("group", (Object)calendarResourceShare.getGroup());
        }
        if (calendarResourceShare.getResourceId() != null) {
            auditParamsBuilder.param("resourceId", (Object)calendarResourceShare.getResourceId());
        }
        if (calendarResourceShare.getResourceGroupId() != null) {
            auditParamsBuilder.param("resourceGroupId", (Object)calendarResourceShare.getResourceGroupId());
        }
        return auditParamsBuilder.build();
    }

    @ConstructorProperties(value={"calendarResourceShareService", "authorizationHelper"})
    @Autowired
    public CalendarResourceShareController(CalendarResourceShareService calendarResourceShareService, AuthorizationHelper authorizationHelper) {
        this.calendarResourceShareService = calendarResourceShareService;
        this.authorizationHelper = authorizationHelper;
    }

    private static enum CalendarResourceShareType {
        RESOURCE,
        GROUP;

    }
}

