/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.email;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2Client;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2ClientService;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2ConnectionService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.administration.email.OAuth2ClientDto;
import com.suncode.pwfl.web.dto.administration.email.OAuth2ConnectionDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.OAuth2ClientMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/oauth/clients"})
@Api(tags={"oauth"})
public class OAuth2ClientController {
    private static final Logger log = LoggerFactory.getLogger(OAuth2ClientController.class);
    @Autowired
    private OAuth2ClientService oAuth2ClientService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private OAuth2ConnectionService oAuth2ConnectionService;
    @Autowired
    private MessageHelperBean messageHelperBean;
    @Autowired
    private OAuth2ClientMapper oAuth2ClientMapper;

    @ApiOperation(value="(Admin) Downloading oAuth clients", notes="Retrieves a list of oAuth clients")
    @ResponseBody
    @GetMapping
    public List<OAuth2ClientDto> getAll() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.oAuth2ClientService.getAll(new String[]{"connections"}).stream().map(OAuth2ClientDto::new).sorted((Comparator<OAuth2ClientDto>)DtoComparator.of(OAuth2ClientDto.class, (String)"id", (SortDirection)SortDirection.ASC)).collect(Collectors.toList());
    }

    @ApiOperation(value="(Admin) Downloading oAuth client", notes="Retrieves oAuth client with given id")
    @ResponseBody
    @GetMapping(value={"/{id}"})
    public ResponseEntity<OAuth2ClientDto> get(@ApiParam(value="oAuth client id", required=true) @PathVariable Long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        OAuth2Client oAuth2Client = (OAuth2Client)this.oAuth2ClientService.get((Serializable)id, new String[]{"connections"});
        if (oAuth2Client == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new OAuth2ClientDto(oAuth2Client), (HttpStatusCode)HttpStatus.OK);
    }

    @ApiOperation(value="(Admin) Adding new oAuth client", notes="Adds new oAuth client")
    @ResponseBody
    @PostMapping
    public OAuth2ClientDto newClient(@ApiParam(value="The query contains a JSON object containing definition of oauth client to add. The definition should include the following fields\n- **name** - name\n- **authenticationMethod** - authentication method ('AUTHORIZATION_CODE', 'CLIENT_CREDENTIALS')\n- **clientId** - client id\n- **clientSecret** - client secret\n- **scope** - scope\n- **authorizationUrl** - authorization url\n- **authorizationUrl** - token url\n- **redirectUrl** - redirect url", required=true) @RequestBody OAuth2ClientDto oAuth2ClientDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_OAUTH2_CLIENT);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        auditBuilder.params((Map)this.clientAuditParamsBuilder(oAuth2ClientDto).build());
        try {
            OAuth2Client oAuth2Client = this.oAuth2ClientMapper.toEntity(oAuth2ClientDto);
            this.oAuth2ClientService.validate(oAuth2Client);
            this.oAuth2ClientService.save((Object)oAuth2Client);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new OAuth2ClientDto(oAuth2Client);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="(Admin) Adding new oAuth client", notes="Adds new oAuth client")
    @ResponseBody
    @PatchMapping
    public void update(@ApiParam(value="The query contains a JSON object containing definition of oauth client to add. The definition should include the following fields\n- **name** - name\n- **authenticationMethod** - authentication method ('AUTHORIZATION_CODE', 'CLIENT_CREDENTIALS')\n- **clientId** - client id\n- **clientSecret** - client secret\n- **scope** - scope\n- **authorizationUrl** - authorization url\n- **authorizationUrl** - token url\n- **redirectUrl** - redirect url", required=true) @RequestBody OAuth2ClientDto oAuth2ClientDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_OAUTH2_CLIENT);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            OAuth2Client oAuth2Client = Optional.ofNullable((OAuth2Client)this.oAuth2ClientService.get((Serializable)oAuth2ClientDto.getId(), new String[]{"connections"})).orElseThrow(() -> new ServiceException(this.messageHelperBean.getMessage("Nie_znaleziono_klienta_oauth_o_podanym_identyfikatorze", new Object[]{oAuth2ClientDto.getId()})));
            auditBuilder.params((Map)this.clientChangeAuditParamsBuilder(oAuth2Client, oAuth2ClientDto).build());
            if (oAuth2Client.getAuthenticationMethod() != oAuth2ClientDto.getAuthenticationMethod()) {
                throw new ServiceException(this.messageHelperBean.getMessage("Nie_mozna_zmienic_metody_autentykacji"));
            }
            OAuth2Client oAuth2ClientNew = this.oAuth2ClientMapper.toEntity(oAuth2ClientDto);
            this.oAuth2ClientService.validate(oAuth2ClientNew);
            oAuth2ClientNew.setConnections(oAuth2Client.getConnections());
            this.oAuth2ClientService.update((Object)oAuth2ClientNew);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="(Admin) Deleting oAuth client", notes="Deletes oAuth client with given id")
    @ResponseBody
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<?> delete(@ApiParam(value="oAuth client id", required=true) @PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_OAUTH2_CLIENT);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        auditBuilder.params((Map)ImmutableMap.of((Object)"OAUTH2_CLIENT_ID", (Object)id));
        try {
            OAuth2Client oAuth2Client = Optional.ofNullable((OAuth2Client)this.oAuth2ClientService.get((Serializable)id, new String[]{"connections"})).orElseThrow(() -> new ServiceException(this.messageHelperBean.getMessage("Nie_znaleziono_klienta_oauth_o_podanym_identyfikatorze", new Object[]{id})));
            if (this.oAuth2ConnectionService.hasConnectionInUse(oAuth2Client)) {
                throw new ServiceException(this.messageHelperBean.getMessage("oauth_client_connection_used_error"));
            }
            this.oAuth2ClientService.delete((Object)oAuth2Client);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="", hidden=true)
    @ResponseBody
    @GetMapping(value={"/{id}/connections"})
    public CountedResult<OAuth2ConnectionDto> getClientConnections(@PathVariable Long id, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, @RequestParam(required=false) String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Sorter sorter = new Sorter(orderBy, orderDirection);
        CountedResult countedConnections = this.oAuth2ConnectionService.getByClientId(id.longValue(), start.intValue(), limit.intValue(), sorter);
        List connectionDtos = countedConnections.getData().stream().map(OAuth2ConnectionDto::new).collect(Collectors.toList());
        return new CountedResult(countedConnections.getTotal(), connectionDtos);
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={EmptyPropertyException.class})
    @ResponseStatus(value=HttpStatus.PARTIAL_CONTENT)
    @ResponseBody
    public RestResult handleEmptyPropertyException(EmptyPropertyException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    private ImmutableMap.Builder<String, Object> clientAuditParamsBuilder(OAuth2ClientDto oAuth2ClientDto) {
        return ImmutableMap.builder().put((Object)"OAUTH2_CLIENT_NAME", (Object)Objects.toString(oAuth2ClientDto.getName(), "")).put((Object)"OAUTH2_AUTHENTICATION_METHOD", (Object)Objects.toString(oAuth2ClientDto.getAuthenticationMethod(), "")).put((Object)"OAUTH2_CLIENT_CLIENT_ID", (Object)Objects.toString(oAuth2ClientDto.getClientId(), "")).put((Object)"OAUTH2_CLIENT_SCOPE", (Object)Objects.toString(oAuth2ClientDto.getScope(), "")).put((Object)"OAUTH2_CLIENT_AUTHORIZATION_URL", (Object)Objects.toString(oAuth2ClientDto.getAuthorizationUrl(), "")).put((Object)"OAUTH2_CLIENT_TOKEN_URL", (Object)Objects.toString(oAuth2ClientDto.getTokenUrl(), ""));
    }

    private ImmutableMap.Builder<String, Object> clientChangeAuditParamsBuilder(OAuth2Client oldClient, OAuth2ClientDto newClient) {
        return ImmutableMap.builder().put((Object)"OAUTH2_CLIENT_ID", (Object)this.generateChangeString(oldClient.getId(), newClient.getId())).put((Object)"OAUTH2_AUTHENTICATION_METHOD", (Object)this.generateChangeString(oldClient.getAuthenticationMethod(), newClient.getAuthenticationMethod())).put((Object)"OAUTH2_CLIENT_NAME", (Object)this.generateChangeString(oldClient.getName(), newClient.getName())).put((Object)"OAUTH2_CLIENT_CLIENT_ID", (Object)this.generateChangeString(oldClient.getClientId(), newClient.getClientId())).put((Object)"OAUTH2_CLIENT_SCOPE", (Object)this.generateChangeString(oldClient.getScope(), newClient.getScope())).put((Object)"OAUTH2_CLIENT_AUTHORIZATION_URL", (Object)this.generateChangeString(oldClient.getAuthorizationUrl(), newClient.getAuthorizationUrl())).put((Object)"OAUTH2_CLIENT_TOKEN_URL", (Object)this.generateChangeString(oldClient.getTokenUrl(), newClient.getTokenUrl()));
    }

    private String generateChangeString(Object oldValue, Object newValue) {
        String oldValueString = Objects.toString(oldValue, "");
        String newValueString = Objects.toString(newValue, "");
        return oldValueString + ";" + newValueString;
    }
}

