/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.servlet;

import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.license.InternalLicenseService;
import com.suncode.pwfl.license.LicenseData;
import com.suncode.pwfl.license.LicenseFile;
import com.suncode.pwfl.license.LicenseVerificator;
import com.suncode.pwfl.license.TempLicenseFile;
import com.suncode.pwfl.license.exceptions.LicenseInvalidException;
import com.suncode.pwfl.util.SpringContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LicensePreview
extends HttpServlet {
    private static final Logger log = Logger.getLogger(LicensePreview.class);
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block26: {
            PrintWriter printWriter = null;
            JSONObject answer = null;
            InputStream is = null;
            Part licensePart = null;
            HttpSession session = request.getSession(false);
            if (session != null && session.getAttribute("username") != null) {
                block23: {
                    Iterator iterator = request.getParts().iterator();
                    if (iterator.hasNext()) {
                        Part part = (Part)iterator.next();
                        is = part.getInputStream();
                        licensePart = part;
                    }
                    LicenseFile license = new LicenseFile(is);
                    InternalLicenseService ls = (InternalLicenseService)SpringContext.getBean((String)"internalLicenseService");
                    List parameters = ls.readLicenseData(license);
                    if (parameters.size() != LicenseData.getNumberOfParams()) {
                        answer = this.badFileJson(licensePart);
                    } else {
                        TempLicenseFile tlf = TempLicenseFile.getInstance();
                        tlf.setLicenseData(license.getEncryptedData());
                        tlf.setPublicKey(license.getPublicKey().getEncoded());
                        answer = this.getLicenseInfo(parameters, licensePart);
                    }
                    if (is == null) break block23;
                    is.close();
                    licensePart.delete();
                }
                try {
                    printWriter = response.getWriter();
                    printWriter.print(answer);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                if (printWriter != null) {
                    printWriter.close();
                }
                break block26;
                catch (LicenseInvalidException e) {
                    block24: {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        answer = this.badFileJson(licensePart);
                        if (is == null) break block24;
                        is.close();
                        licensePart.delete();
                    }
                    try {
                        printWriter = response.getWriter();
                        printWriter.print(answer);
                    }
                    catch (Exception e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                    }
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
                catch (Exception e2) {
                    block25: {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                        answer = this.badFileJson(licensePart);
                        if (is == null) break block25;
                        {
                            catch (Throwable throwable) {
                                if (is != null) {
                                    is.close();
                                    licensePart.delete();
                                }
                                try {
                                    printWriter = response.getWriter();
                                    printWriter.print(answer);
                                }
                                catch (Exception e3) {
                                    log.error((Object)e3.getMessage(), (Throwable)e3);
                                }
                                if (printWriter != null) {
                                    printWriter.close();
                                }
                                throw throwable;
                            }
                        }
                        is.close();
                        licensePart.delete();
                    }
                    try {
                        printWriter = response.getWriter();
                        printWriter.print(answer);
                    }
                    catch (Exception e4) {
                        log.error((Object)e4.getMessage(), (Throwable)e4);
                    }
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
            }
        }
    }

    private JSONObject getLicenseInfo(List<String> parameters, Part fileItem) throws JSONException {
        JSONArray restrictions = new JSONArray();
        JSONObject fileInfo = new JSONObject();
        fileInfo.put("filename", (Object)fileItem.getSubmittedFileName());
        restrictions.put((Object)fileInfo);
        fileInfo = new JSONObject();
        fileInfo.put("filesize", fileItem.getSize());
        restrictions.put((Object)fileInfo);
        JSONObject restriction = new JSONObject();
        restriction.put("type", (Object)MessageHelper.getMessage((String)"Data_wygasniecia_licencji"));
        restriction.put("value", (Object)(parameters.get(5).equals("0") ? "N/A" : parameters.get(5).split(" ")[0]));
        restrictions.put((Object)restriction);
        restriction = new JSONObject();
        restriction.put("type", (Object)MessageHelper.getMessage((String)"Maksymalna_liczba_uzytkownikow"));
        restriction.put("value", (Object)(parameters.get(2).equals("0") ? "N/A" : parameters.get(2)));
        restrictions.put((Object)restriction);
        restriction = new JSONObject();
        restriction.put("type", (Object)MessageHelper.getMessage((String)"Maksymalna_liczba_zalogowanych_uzytkownikow"));
        restriction.put("value", (Object)(parameters.get(3).equals("0") ? "N/A" : parameters.get(3)));
        restrictions.put((Object)restriction);
        restriction = new JSONObject();
        restriction.put("type", (Object)MessageHelper.getMessage((String)"Maksymalna_liczba_definicji_procesow"));
        restriction.put("value", (Object)(parameters.get(6).equals("0") ? "N/A" : parameters.get(6)));
        restrictions.put((Object)restriction);
        ArrayList<String> processesId = new ArrayList<String>(Arrays.asList(parameters.get(7).split(";")));
        Object processes = "";
        for (String process : processesId) {
            if (((String)processes).equals("")) {
                processes = (String)processes + process;
                continue;
            }
            processes = (String)processes + ", " + process;
        }
        restriction = new JSONObject();
        restriction.put("type", (Object)MessageHelper.getMessage((String)"Id_procesow"));
        restriction.put("value", ((String)processes).equals("0") ? "N/A" : processes);
        restrictions.put((Object)restriction);
        JSONObject data = new JSONObject();
        data.put("success", true);
        String canLicenseBeLoaded = LicenseVerificator.canLicenseBeLoaded(parameters);
        if (!canLicenseBeLoaded.equals("")) {
            data.put("canBeLoaded", false);
            data.put("errortext", (Object)canLicenseBeLoaded);
        } else {
            data.put("canBeLoaded", true);
        }
        data.put("badfile", false);
        data.put("data", (Object)restrictions);
        return data;
    }

    private JSONObject badFileJson(Part fileItem) {
        JSONObject data = new JSONObject();
        try {
            data.put("success", true);
            data.put("badfile", true);
            data.put("errortext", (Object)(MessageHelper.getMessage((String)"Plik_z_licencja_jest_uszkodzony") + "."));
            JSONArray fileInfo = new JSONArray();
            JSONObject info = new JSONObject();
            info.put("filename", (Object)fileItem.getSubmittedFileName());
            fileInfo.put((Object)info);
            info = new JSONObject();
            info.put("filesize", fileItem.getSize());
            fileInfo.put((Object)info);
            data.put("data", (Object)fileInfo);
        }
        catch (JSONException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return data;
    }
}

