/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.util.GroupInfo;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserGroupFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;

public class GetGroupListAction
extends Action {
    public static Logger log = Logger.getLogger(GetGroupListAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List<GroupInfo> groupList;
        log.info((Object)"******************************GetGroupListAction********************");
        String userName = request.getParameter("userName");
        String groupId = request.getParameter("groupId");
        String userType = request.getParameter("userType");
        String actionLink = request.getParameter("actionLink");
        String groupName = request.getParameter("searchGroupName");
        String groupDescription = request.getParameter("searchGroupDesc");
        boolean tableAction = Boolean.valueOf(request.getParameter("tableAction"));
        DetachedCriteria dc = DetachedCriteria.forClass(UserGroup.class);
        UserGroupFinder userGroupFinder = FinderFactory.getUserGroupFinder();
        if ("groupUserSel".equals(userType) || "ldapUserGroupName".equals(userType)) {
            List<UserGroup> userGroups = this.getGroupsFromSearchCriteria(userGroupFinder, dc, groupName, groupDescription);
            groupList = this.mapUserGroupsToGroupsInfo(userGroups, null);
            actionLink = "shortGroupsLink";
        } else if ("allGroupsExceptOne".equals(userType)) {
            dc.add((Criterion)Restrictions.ne((String)"name", (Object)groupId));
            List<UserGroup> userGroups = this.getGroupsFromSearchCriteria(userGroupFinder, dc, groupName, groupDescription);
            groupList = this.mapUserGroupsToGroupsInfo(userGroups, groupId);
            request.setAttribute("destinationGroup", (Object)groupId);
            actionLink = "shortTaskGroupLink";
        } else if ("addgroup".equals(userType)) {
            this.addRestrictionsForNotEqualsUserGroups(dc, userName);
            List<UserGroup> userGroups = this.getGroupsFromSearchCriteria(userGroupFinder, dc, groupName, groupDescription);
            groupList = this.mapUserGroupsToGroupsInfo(userGroups, userName);
            actionLink = "shortAddGroupLink";
        } else {
            List<UserGroup> userGroups = this.getGroupsFromSearchCriteria(userGroupFinder, dc, groupName, groupDescription);
            groupList = this.mapUserGroupsToGroupsInfo(userGroups, null);
            actionLink = "shortGroupLink";
        }
        request.setAttribute("groupId", (Object)groupId);
        request.setAttribute("groupList", groupList);
        request.setAttribute("userType", (Object)userType);
        request.setAttribute("actionLink", (Object)actionLink);
        request.setAttribute("userName", (Object)userName);
        String redirectAction = tableAction ? "showSearchedGroup" : "showSearchGroup";
        return mapping.findForward(redirectAction);
    }

    private List<GroupInfo> mapUserGroupsToGroupsInfo(List<UserGroup> userGroups, String specialValue) {
        return userGroups.stream().map(userGroup -> this.mapUserGroupToGroupInfo((UserGroup)userGroup, specialValue)).collect(Collectors.toList());
    }

    private GroupInfo mapUserGroupToGroupInfo(UserGroup userGroup, String specialValue) {
        GroupInfo groupInfo = new GroupInfo();
        groupInfo.setM_sGroupDescription(userGroup.getDescription());
        groupInfo.setM_sGroupName(userGroup.getName());
        groupInfo.setM_sSpecialValue(specialValue);
        return groupInfo;
    }

    private void addRestrictionsForNotEqualsUserGroups(DetachedCriteria dc, String userName) {
        UserService service = ServiceFactory.getUserService();
        User user = service.getUser(userName, new String[]{"groups"});
        user.getGroups().forEach(group -> dc.add((Criterion)Restrictions.ne((String)"name", (Object)group.getName())));
    }

    private List<UserGroup> getGroupsFromSearchCriteria(UserGroupFinder userGroupFinder, DetachedCriteria dc, String groupName, String groupDescription) {
        if (DBUtils.isConjunctionSearch((String)groupName)) {
            dc.add((Criterion)this.conjunctionSearchCriteria(groupName, "name"));
        } else if (StringUtils.isNotBlank((String)groupName)) {
            dc.add(Restrictions.ilike((String)"name", (Object)("%" + groupName.replaceAll(" +", "%") + "%")));
        }
        if (DBUtils.isConjunctionSearch((String)groupDescription)) {
            dc.add((Criterion)this.conjunctionSearchCriteria(groupDescription, "description"));
        } else if (StringUtils.isNotBlank((String)groupDescription)) {
            dc.add(Restrictions.ilike((String)"description", (Object)("%" + groupDescription.replaceAll(" +", "%") + "%")));
        }
        return userGroupFinder.findByCriteria(dc);
    }

    private Conjunction conjunctionSearchCriteria(String value, String propertyName) {
        Conjunction conjunction = Restrictions.conjunction();
        List searchValues = DBUtils.searchCriteriaForConjunctionLike((List)DBUtils.conjunctionValuesForLike((String)value));
        searchValues.forEach(searchValue -> conjunction.add(Restrictions.ilike((String)propertyName, (Object)searchValue)));
        return conjunction;
    }
}

