/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.virtualtables;

import com.plusmpm.CUF.util.extension.ServletTools;
import com.plusmpm.database.virtualtables.Column;
import com.plusmpm.database.virtualtables.Table;
import com.plusmpm.util.virtualtables.MyJXLException;
import com.plusmpm.util.virtualtables.Record;
import com.plusmpm.util.virtualtables.RecordHelper;
import com.plusmpm.util.virtualtables.TablesImporter;
import com.plusmpm.util.virtualtables.VColumn;
import com.plusmpm.util.virtualtables.VTable;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;

@MultipartConfig(maxRequestSize=1200000L)
public class fileUpload
extends HttpServlet {
    protected String userId;
    protected String tableId;
    protected List<Part> parts;
    private static final long serialVersionUID = 1L;
    public static Logger log = Logger.getLogger(fileUpload.class);
    private boolean czyTxt;
    private boolean czyXls;
    private static final String DEFAULT_CHARSET = "ISO-8859-1";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.tableId = null;
        this.parts = null;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jsonResult;
        this.userId = String.valueOf(request.getSession().getAttribute("username"));
        if (!this.isMultipartContent(request)) {
            Object msg = "Pr\u00f3ba wys\u0142ania niepoprawnej tre\u015bci do servletu.\n ";
            msg = (String)msg + "\tpowinno by\u0107 'multipart/form-data.";
            log.error(msg);
            return;
        }
        this.parts = null;
        this.parts = (List)request.getParts();
        try {
            jsonResult = this.doFileUpload(this.parts);
        }
        catch (MyJXLException e) {
            log.error((Object)"nie znaleziono \u017cadnej odpowiadaj\u0105cej kolumny w pliku", (Throwable)e);
            jsonResult = "{success : false, msg : PW.t('brak_odpow_kolumny') }";
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"Dokument zawiera\u0142 niedozwolone znaki", (Throwable)e);
            jsonResult = "{success : false, msg : PW.t('niedozwolone_znaki') }";
        }
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println(jsonResult);
        log.info((Object)("wys\u0142ano odpowied\u017a: " + jsonResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doFileUpload(List<Part> items) throws MyJXLException {
        boolean clear = false;
        String result = null;
        this.czyTxt = false;
        this.czyXls = false;
        InputStream uploadedStream = null;
        try {
            Object object;
            for (Part part : items) {
                if (ServletTools.isFormField((Part)part)) {
                    if ("tableId".equals(ServletTools.getFieldName((Part)part))) {
                        this.tableId = new String(IOUtils.toByteArray((InputStream)part.getInputStream()), fileUpload.getCharsetFromContentTypeString(part.getContentType()));
                    }
                    if (!"clear".equals(ServletTools.getFieldName((Part)part))) continue;
                    clear = true;
                    continue;
                }
                if (this.czyZleRozszerzenie(part.getName())) {
                    result = this.badFilExtensionJSON();
                    log.error((Object)("pr\u00f3ba importu z pliku o nazwie: " + part.getName()));
                    String string = result;
                    IOUtils.closeQuietly((InputStream)uploadedStream);
                    return string;
                }
                try {
                    uploadedStream = part.getInputStream();
                }
                catch (IOException e) {
                    log.error((Object)("problemy z przetwarzaniem przeslanego pliku: " + part.getName()));
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (this.czyTxt) {
                object = this.importFromTxt(this.tableId, uploadedStream, clear);
                return object;
            }
            if (this.czyXls) {
                object = this.importFromXls(this.tableId, uploadedStream, clear);
                return object;
            }
            object = null;
            return object;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly(uploadedStream);
        }
    }

    public String importFromTxt(String tableId, InputStream uploadedStream, boolean clear) throws MyJXLException {
        return (String)TransactionWrapper.get().doInHibernateTransaction(session -> {
            String result;
            BufferedReader br = new BufferedReader(new InputStreamReader(uploadedStream));
            ArrayList records = null;
            try {
                String line = br.readLine();
                ArrayList<Column> columns = this.rozpoznajKolumny(line, tableId);
                if (columns.size() <= 0) {
                    log.error((Object)"powinna by\u0107 jaka\u015b kolumna w pliku tekstowym!");
                    throw new MyJXLException("nie znaleziono \u017cadnej odpowiadaj\u0105cej kolumny!");
                }
                log.info((Object)("kolumn: " + columns.size()));
                if (log.isDebugEnabled()) {
                    for (Column c : columns) {
                        log.info((Object)("kolumna " + c.getId() + "nazwa: " + c.getName()));
                    }
                }
                TablesImporter tti = new TablesImporter();
                records = tti.getRecords(br, columns);
                if (log.isDebugEnabled()) {
                    log.info((Object)("mamy rekord\u00f3w: " + records.size()));
                    for (Record r : records) {
                        log.info((Object)r.toJsonString());
                    }
                }
                if (clear) {
                    VTable.clearTableValues((String)tableId);
                }
                result = this.saveRecords(records, tableId);
            }
            catch (MyJXLException | IOException e) {
                log.error((Object)"problemy z przetwarzaniem pliku uploadowanego", e);
                log.error((Object)e.getMessage(), e);
                result = "{success : false, msg : PW.t('problemy_z_przetw') }";
            }
            return result;
        });
    }

    private String importFromXls(String tableId, InputStream uploadedStream, boolean clear) throws MyJXLException {
        return (String)TransactionWrapper.get().doInHibernateTransaction(session -> {
            ArrayList<Column> columns = null;
            String result = null;
            Sheet sheet = null;
            try {
                Workbook workbook = Workbook.getWorkbook((InputStream)uploadedStream);
                sheet = workbook.getSheet(0);
                columns = this.rozpoznajKolumny(sheet, tableId);
                if (columns.get(0) == null) {
                    log.error((Object)"powinna by\u0107 jaka\u015b kolumna w arkuszu Excela!");
                    throw new MyJXLException("nie znaleziono \u017cadnej odpowiadaj\u0105cej kolumny!");
                }
                log.info((Object)("pr\u00f3ba wczytania rekord\u00f3w do tabeli: " + tableId));
                ArrayList<Record> records = this.readRecordsFromSheet(sheet, columns);
                if (clear) {
                    VTable.clearTableValues((String)tableId);
                }
                result = this.saveRecords(records, tableId);
            }
            catch (BiffException e) {
                log.error((Object)"czytanie pliku BIFF? nie powinno mie\u0107 miejsca..", (Throwable)e);
                result = "{success : false , msg: PW.t('problemy_z_przetw') }";
            }
            catch (MyJXLException | IOException e) {
                log.error((Object)"b\u0142\u0105d w czytaniu pliku xls", e);
                result = "{success : false , msg: PW.t('problemy_z_przetw') }";
            }
            return result;
        });
    }

    private ArrayList<Record> readRecordsFromSheet(Sheet sheet, ArrayList<Column> columns) {
        int ileKolumn = columns.size();
        if (ileKolumn <= 0) {
            return null;
        }
        ArrayList<Record> records = new ArrayList<Record>();
        int ile = sheet.getRows();
        for (int i = 1; i < ile; ++i) {
            Record rec = new Record(i);
            for (int j = 0; j < ileKolumn; ++j) {
                String value = sheet.getCell(j, i).getContents();
                Column c = columns.get(j);
                if (c == null) {
                    log.error((Object)("wyst\u0105pi\u0142a pusta kolumna. indeks kolumny: " + j));
                    continue;
                }
                log.info((Object)("ustawiam warto\u015b\u0107: " + value + " w kolumnie: " + c.getId()));
                rec.setValue(c.getId(), value, c.getType().getId());
            }
            records.add(rec);
        }
        return records;
    }

    private ArrayList<Column> rozpoznajKolumny(Sheet sheet, String tableId) {
        return (ArrayList)TransactionWrapper.get().doInHibernateTransaction(session -> {
            int ile = sheet.getColumns();
            if (ile <= 0) {
                log.error((Object)("J Excel API mowi, \u017ce w arkuszu jest 0 kolumn! ilosc kolumn: " + sheet.getColumns()));
            }
            ArrayList<Column> cols = new ArrayList<Column>();
            for (int i = 0; i < ile; ++i) {
                String columnId = sheet.getCell(i, 0).getContents();
                if (columnId.compareTo("") == 0) {
                    return cols;
                }
                cols.add(VColumn.getColumn((String)tableId, (String)columnId));
            }
            return cols;
        });
    }

    private String saveRecords(ArrayList<Record> records, String tableId) {
        TransactionWrapper.get().doInHibernateTransaction(session -> {
            RecordHelper rh = new RecordHelper(tableId);
            rh.load();
            Table table = (Table)session.get(Table.class, (Serializable)((Object)tableId));
            if (table == null) {
                log.error((Object)("nie istnieje tabela: " + tableId));
                throw new HibernateException("nie istnieje tabela: " + tableId, (Throwable)new Exception());
            }
            int rowNo = table.getRows();
            for (Record rec : records) {
                if (rec.isEmpty()) continue;
                rh.saveRecord(rowNo, rec, this.userId);
                ++rowNo;
            }
            table.setRows(table.getRows() + records.size());
            session.update((Object)table);
        });
        return "{success : true, msg: PW.t('udalo_sie') }";
    }

    private ArrayList<Column> rozpoznajKolumny(String line, String tableId) {
        return (ArrayList)TransactionWrapper.get().doInHibernateTransaction(session -> {
            Column c;
            int index;
            int separator = 59;
            ArrayList<Column> columns = new ArrayList<Column>();
            String tmp = line;
            while ((index = tmp.indexOf(separator)) >= 0) {
                String value = tmp.substring(0, index);
                tmp = tmp.substring(index + 1);
                c = VColumn.getColumn((String)tableId, (String)value);
                if (c == null) continue;
                columns.add(c);
            }
            c = VColumn.getColumn((String)tableId, (String)tmp);
            if (c != null) {
                columns.add(c);
            }
            return columns;
        });
    }

    private String badFilExtensionJSON() {
        return "{success : false, msg : PW.t('zle_rozsz_pliku')}";
    }

    private boolean czyZleRozszerzenie(String name) {
        String tmp = name.substring(name.length() - 4);
        if (tmp.compareToIgnoreCase(".txt") == 0) {
            this.czyTxt = true;
            return false;
        }
        if (tmp.compareToIgnoreCase(".xls") == 0) {
            this.czyXls = true;
            return false;
        }
        return true;
    }

    private boolean isMultipartContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/");
    }

    private static String getCharsetFromContentTypeString(String contentType) {
        String charset;
        String pattern;
        Matcher matcher;
        if (contentType != null && (matcher = Pattern.compile(pattern = "charset=([a-z\\d\\-]*)", 2).matcher(contentType)).find() && Charset.isSupported(charset = matcher.group(1))) {
            return charset;
        }
        return DEFAULT_CHARSET;
    }
}

