/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.simulation.duplicated.context.process;

import com.plusmpm.util.CoreTools;
import com.plusmpm.util.SharkFunctions;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.util.Sneaky;
import com.suncode.pwfl.workflow.activity.ActivityState;
import com.suncode.pwfl.workflow.simulation.delegated.context.process.CreatedProcessDto;
import com.suncode.pwfl.workflow.simulation.duplicated.SimulationUtils;
import com.suncode.pwfl.workflow.simulation.duplicated.context.activity.SimulationActivityService;
import com.suncode.pwfl.workflow.simulation.duplicated.context.process.SimulationProcessService;
import com.suncode.pwfl.workflow.simulation.duplicated.exception.SimulationException;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.xpdl.elements.Package;
import org.springframework.beans.factory.annotation.Autowired;

public class SimulationProcessServiceImpl
implements SimulationProcessService {
    private final TransactionWrapper transactionWrapper;
    private final SimulationActivityService activityService;

    public CreatedProcessDto createProcess(String packageId, String processDefinitionId) {
        return (CreatedProcessDto)this.transactionWrapper.doInSharkTransaction(sharkTransaction -> {
            try {
                WfProcess wfProcess = SharkUtils.createSharkConnection((String)"admin").createProcess(sharkTransaction, packageId, processDefinitionId);
                Package pack = SharkFunctions.getPackageManager().getPackageByWfProcess(sharkTransaction, wfProcess);
                CoreTools.SetDefaultVariablesForCreateProcess((SharkTransaction)sharkTransaction, (String)"admin", (WfProcess)wfProcess, (String)processDefinitionId, (Package)pack);
                wfProcess.start(sharkTransaction);
                String processId = wfProcess.key(sharkTransaction);
                List openedActivityIds = this.activityService.streamActivitiesByState(sharkTransaction, wfProcess, ActivityState::isOpen).map(wfActivity -> (String)Sneaky.throwing(() -> wfActivity.key(sharkTransaction))).collect(Collectors.toCollection(ArrayList::new));
                return CreatedProcessDto.builder().packageId(packageId).processId(processId).openedActivityIds(openedActivityIds).build();
            }
            catch (Exception e) {
                throw new SimulationException(String.format("Failed to create process by definition [%s] from package [%s]", processDefinitionId, packageId), (Throwable)e);
            }
        });
    }

    @ConstructorProperties(value={"transactionWrapper", "activityService"})
    @Autowired
    public SimulationProcessServiceImpl(TransactionWrapper transactionWrapper, SimulationActivityService activityService) {
        this.transactionWrapper = transactionWrapper;
        this.activityService = activityService;
    }

    static {
        SimulationUtils.assertIsInSimulation();
    }
}

