/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.webapp.controllers;

import com.suncode.plugin.dashboard.Dashboard;
import com.suncode.plugin.dashboard.DashboardService;
import com.suncode.plugin.framework.defaultView.DefaultView;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserInfoCache;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.util.ServiceFactory;
import java.beans.ConstructorProperties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShowUserDefaultViewController {
    private static final Logger log = LoggerFactory.getLogger(ShowUserDefaultViewController.class);
    private final DashboardService dashboardService;
    private final UserSettingsService userSettingsService;
    private final Experimental experimental;

    @RequestMapping(value={"/", "/default.do", "/ShowUserDefaultView.do"})
    public String execute(HttpServletRequest request, HttpSession session) throws Exception {
        String username = (String)session.getAttribute("username");
        String sMain = request.getParameter("main");
        if (sMain != null) {
            session.setAttribute("m_bFilterSearch", null);
            session.setAttribute("filterVariableListForm", null);
            session.setAttribute("iOffset", null);
            session.setAttribute("iSortOrderType", null);
            session.setAttribute("sSortColumnName", null);
            session.setAttribute("advanceSearchBean", null);
            session.setAttribute("viewName", null);
        }
        log.info("Pobieramy widok domy\u015blny:");
        String defaultViewId = this.getDefaultView(username);
        log.info("Widok domy\u015blny:" + defaultViewId);
        String url = this.userSettingsService.getDefaultUserViews(username).stream().filter(defaultView -> defaultView.id().equalsIgnoreCase(defaultViewId)).map(DefaultView::url).map(this::cleanUrl).findFirst().map(defaultUrl -> "redirect:/" + defaultUrl).orElse("forward:/ShowWorkListAction.do");
        if (url.equals("redirect:/plugin/com.suncode.plugin-calendar/") && this.experimental.hasFeature(ExperimentalFeature.NEW_CALENDAR)) {
            url = "redirect:/Calendar.do";
        }
        return url;
    }

    private String getDefaultView(String username) {
        String defaultView = ServiceFactory.getUserSettingsService().getSetting(username, UserSettingsService.UserSetting.DEFAULT_VIEW);
        if (defaultView == null) {
            String string = defaultView = this.isAnonymousUser(username) ? "dashboard" : "";
        }
        if (this.isAnonymousUser(username)) {
            Dashboard defaultDashboard = this.dashboardService.getDefaultDashboard();
            if (defaultView.equals("dashboard") && defaultDashboard == null) {
                defaultView = "myviews";
                log.info("Nast\u0119puje przekierowanie u\u017cytkownika anonimowego na widok: " + defaultView);
            } else if (!(defaultView.equals("createprocess") || defaultView.equals("myviews") || defaultView.startsWith("myview_"))) {
                defaultView = defaultDashboard != null ? "dashboard" : "myviews";
                log.info("Nast\u0119puje przekierowanie u\u017cytkownika anonimowego na widok: " + defaultView);
            }
        }
        return defaultView;
    }

    private boolean isAnonymousUser(String username) {
        UserInfo userInfo = UserInfoCache.get().get(username);
        return userInfo != null && userInfo.isAnonymous();
    }

    private String cleanUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replaceFirst("^/+", "");
    }

    @ConstructorProperties(value={"dashboardService", "userSettingsService", "experimental"})
    public ShowUserDefaultViewController(DashboardService dashboardService, UserSettingsService userSettingsService, Experimental experimental) {
        this.dashboardService = dashboardService;
        this.userSettingsService = userSettingsService;
        this.experimental = experimental;
    }
}

