/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.security.advice;

import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class UnauthorizedAdvice {
    private final MessageHelperBean messageHelper;

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseBody
    public RestResult handleNotFullRightsException() {
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"messageHelper"})
    @Autowired
    public UnauthorizedAdvice(MessageHelperBean messageHelper) {
        this.messageHelper = messageHelper;
    }
}

