/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.workflow.search;

import com.suncode.pwfl.distinction.VariableDistinguishService;
import com.suncode.pwfl.search.results.AdvanceProcessSearchResultValue;
import com.suncode.pwfl.search.results.AdvanceProcessSearchResultsRow;
import com.suncode.pwfl.search.results.HeaderToColumnMapper;
import com.suncode.pwfl.web.dto.workflow.search.AdvanceSearchResultColumnDto;
import com.suncode.pwfl.web.dto.workflow.search.SearchResultsRowExportDto;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExportDtoToSearchResultsRowMapper {
    @Autowired
    private VariableDistinguishService variableDistinguishService;
    @Autowired
    private HeaderToColumnMapper headerToColumnMapper;

    public AdvanceProcessSearchResultsRow map(SearchResultsRowExportDto searchResultsRowExportDto) {
        return AdvanceProcessSearchResultsRow.builder().processId(searchResultsRowExportDto.getProcessId()).activityId(searchResultsRowExportDto.getActivityId()).values(searchResultsRowExportDto.getValues()).build();
    }

    public List<AdvanceProcessSearchResultsRow> getExportResultsWithSanitizedVariables(Long viewId, List<AdvanceProcessSearchResultsRow> rowsToSanitize, List<AdvanceSearchResultColumnDto> columns) {
        ArrayList variableDistinguishForView = new ArrayList();
        if (viewId != null) {
            variableDistinguishForView.addAll(this.variableDistinguishService.getVariableDistinguishTablesForView(viewId.longValue()).stream().map((? super T variable) -> this.headerToColumnMapper.fromHeaderToColumn(variable.getVariableId())).collect(Collectors.toList()));
        }
        List arrayColumns = columns.stream().filter(AdvanceSearchResultColumnDto::isTableVariable).collect(Collectors.toList());
        rowsToSanitize.forEach(row -> {
            List values = row.getValues().stream().map((? super T cell) -> {
                String cellValue = cell.getValue().replaceAll("&nbsp;", "");
                if (arrayColumns.stream().noneMatch(column -> column.getId().equals(cell.getColumnId()))) {
                    if (!variableDistinguishForView.contains(cell.getColumnId())) {
                        return new AdvanceProcessSearchResultValue(cell.getColumnId(), cellValue, cell.getMetaValue());
                    }
                    String sanitizedValue = ExportDtoToSearchResultsRowMapper.sanitizeValue(cellValue);
                    return new AdvanceProcessSearchResultValue(cell.getColumnId(), sanitizedValue, cell.getMetaValue());
                }
                String sanitizedValue = this.sanitizeTableVariableValue(cellValue);
                return new AdvanceProcessSearchResultValue(cell.getColumnId(), sanitizedValue, cell.getMetaValue());
            }).collect(Collectors.toList());
            row.setValues(values);
        });
        return rowsToSanitize;
    }

    public Stream<AdvanceProcessSearchResultsRow> getExportResultsWithSanitizedVariables(Long viewId, Stream<AdvanceProcessSearchResultsRow> rowsToSanitize, List<AdvanceSearchResultColumnDto> columns) {
        ArrayList variableDistinguishForView = new ArrayList();
        if (viewId != null) {
            variableDistinguishForView.addAll(this.variableDistinguishService.getVariableDistinguishTablesForView(viewId.longValue()).stream().map((? super T variable) -> this.headerToColumnMapper.fromHeaderToColumn(variable.getVariableId())).collect(Collectors.toList()));
        }
        List arrayColumns = columns.stream().filter(AdvanceSearchResultColumnDto::isTableVariable).collect(Collectors.toList());
        return rowsToSanitize.peek(row -> {
            List values = row.getValues().stream().map((? super T cell) -> {
                String cellValue = cell.getValue().replaceAll("&nbsp;", "");
                if (arrayColumns.stream().noneMatch(column -> column.getId().equals(cell.getColumnId()))) {
                    if (!variableDistinguishForView.contains(cell.getColumnId())) {
                        return new AdvanceProcessSearchResultValue(cell.getColumnId(), cellValue, cell.getMetaValue());
                    }
                    String sanitizedValue = ExportDtoToSearchResultsRowMapper.sanitizeValue(cellValue);
                    return new AdvanceProcessSearchResultValue(cell.getColumnId(), sanitizedValue, cell.getMetaValue());
                }
                String sanitizedValue = this.sanitizeTableVariableValue(cellValue);
                return new AdvanceProcessSearchResultValue(cell.getColumnId(), sanitizedValue, cell.getMetaValue());
            }).collect(Collectors.toList());
            row.setValues(values);
        });
    }

    private static String sanitizeValue(String value) {
        Document document = Jsoup.parse((String)value);
        return document.body().text();
    }

    private String sanitizeTableVariableValue(String value) {
        return ExportDtoToSearchResultsRowMapper.sanitizeValue(value.replaceAll("<hr>", ";")).replaceAll(" ; ", ";");
    }
}

