/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.archive;

import com.plusmpm.util.Tools;
import com.suncode.pwfl.administration.archive.DisplayedIndex;
import com.suncode.pwfl.archive.WfDocument;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AssociatedDocumentDto {
    private Long id;
    private Long documentClassId;
    private String name;
    private String documentClassName;
    private String encodedFileId;
    private Map<String, Object> displayedIndexes;

    public static AssociatedDocumentDto fromDocument(WfDocument document, List<DisplayedIndex> displayedIndexes) {
        return AssociatedDocumentDto.builder().id(document.getFile().getId()).documentClassId(document.getDocumentClassId()).name(document.getFile().getFileName()).documentClassName(document.getFile().getDocumentClass().getName()).encodedFileId(Tools.encodeStringBase64((String)String.valueOf(document.getFile().getId()))).displayedIndexes(AssociatedDocumentDto.getDisplayedIndexesValues(document, displayedIndexes)).build();
    }

    private static Map<String, Object> getDisplayedIndexesValues(WfDocument document, List<DisplayedIndex> displayedIndexes) {
        return displayedIndexes.stream().collect(Collectors.toMap(x -> x.getIndex().getName(), x -> document.getIndexById(x.getIndex().getId()).getValue()));
    }

    public static AssociatedDocumentDtoBuilder builder() {
        return new AssociatedDocumentDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getDocumentClassId() {
        return this.documentClassId;
    }

    public String getName() {
        return this.name;
    }

    public String getDocumentClassName() {
        return this.documentClassName;
    }

    public String getEncodedFileId() {
        return this.encodedFileId;
    }

    public Map<String, Object> getDisplayedIndexes() {
        return this.displayedIndexes;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDocumentClassId(Long documentClassId) {
        this.documentClassId = documentClassId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDocumentClassName(String documentClassName) {
        this.documentClassName = documentClassName;
    }

    public void setEncodedFileId(String encodedFileId) {
        this.encodedFileId = encodedFileId;
    }

    public void setDisplayedIndexes(Map<String, Object> displayedIndexes) {
        this.displayedIndexes = displayedIndexes;
    }

    @ConstructorProperties(value={"id", "documentClassId", "name", "documentClassName", "encodedFileId", "displayedIndexes"})
    public AssociatedDocumentDto(Long id, Long documentClassId, String name, String documentClassName, String encodedFileId, Map<String, Object> displayedIndexes) {
        this.id = id;
        this.documentClassId = documentClassId;
        this.name = name;
        this.documentClassName = documentClassName;
        this.encodedFileId = encodedFileId;
        this.displayedIndexes = displayedIndexes;
    }

    public AssociatedDocumentDto() {
    }

    public static class AssociatedDocumentDtoBuilder {
        private Long id;
        private Long documentClassId;
        private String name;
        private String documentClassName;
        private String encodedFileId;
        private Map<String, Object> displayedIndexes;

        AssociatedDocumentDtoBuilder() {
        }

        public AssociatedDocumentDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AssociatedDocumentDtoBuilder documentClassId(Long documentClassId) {
            this.documentClassId = documentClassId;
            return this;
        }

        public AssociatedDocumentDtoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AssociatedDocumentDtoBuilder documentClassName(String documentClassName) {
            this.documentClassName = documentClassName;
            return this;
        }

        public AssociatedDocumentDtoBuilder encodedFileId(String encodedFileId) {
            this.encodedFileId = encodedFileId;
            return this;
        }

        public AssociatedDocumentDtoBuilder displayedIndexes(Map<String, Object> displayedIndexes) {
            this.displayedIndexes = displayedIndexes;
            return this;
        }

        public AssociatedDocumentDto build() {
            return new AssociatedDocumentDto(this.id, this.documentClassId, this.name, this.documentClassName, this.encodedFileId, this.displayedIndexes);
        }

        public String toString() {
            return "AssociatedDocumentDto.AssociatedDocumentDtoBuilder(id=" + this.id + ", documentClassId=" + this.documentClassId + ", name=" + this.name + ", documentClassName=" + this.documentClassName + ", encodedFileId=" + this.encodedFileId + ", displayedIndexes=" + this.displayedIndexes + ")";
        }
    }
}

