/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration;

import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import java.beans.ConstructorProperties;

public class RoleDto {
    private Long id;
    private String roleId;
    private String roleName;
    private String packageId;
    private String processDefId;

    public static RoleDto fromDomain(Role domain) {
        return RoleDto.builder().id(domain.getId()).packageId(domain.getPackageId()).processDefId(domain.getProcessDefId()).roleId(domain.getRoleId()).build();
    }

    public static RoleDto translatedFromDomain(Role domain) {
        return RoleDto.builder().id(domain.getId()).packageId(PackageTranslationHelper.getPackageName((String)domain.getPackageId())).roleId(domain.getRoleId()).roleName(domain.getRoleName()).processDefId(PackageTranslationHelper.getProcessName((String)domain.getPackageId(), (String)domain.getProcessDefId())).build();
    }

    public static RoleDtoBuilder builder() {
        return new RoleDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    public RoleDto() {
    }

    @ConstructorProperties(value={"id", "roleId", "roleName", "packageId", "processDefId"})
    public RoleDto(Long id, String roleId, String roleName, String packageId, String processDefId) {
        this.id = id;
        this.roleId = roleId;
        this.roleName = roleName;
        this.packageId = packageId;
        this.processDefId = processDefId;
    }

    public static class RoleDtoBuilder {
        private Long id;
        private String roleId;
        private String roleName;
        private String packageId;
        private String processDefId;

        RoleDtoBuilder() {
        }

        public RoleDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public RoleDtoBuilder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public RoleDtoBuilder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public RoleDtoBuilder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public RoleDtoBuilder processDefId(String processDefId) {
            this.processDefId = processDefId;
            return this;
        }

        public RoleDto build() {
            return new RoleDto(this.id, this.roleId, this.roleName, this.packageId, this.processDefId);
        }

        public String toString() {
            return "RoleDto.RoleDtoBuilder(id=" + this.id + ", roleId=" + this.roleId + ", roleName=" + this.roleName + ", packageId=" + this.packageId + ", processDefId=" + this.processDefId + ")";
        }
    }
}

