/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.documents;

import com.plusmpm.util.Authorization;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.document.DocumentSearchInformationService;
import com.suncode.pwfl.archive.document.dto.DocumentData;
import com.suncode.pwfl.archive.document.dto.ExtendedDocumentData;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/documents/{documentClassId}/info/{documentId}/{fileId}"})
@Api(hidden=true)
public class DocumentSearchInformationController {
    private final DocumentSearchInformationService documentSearchInformationService;

    @GetMapping
    public DocumentData getDocumentInfo(@PathVariable Long documentClassId, @PathVariable Long fileId, @PathVariable Long documentId) {
        boolean hasRightsToReadFile = Authorization.hasRightsToReadFile((String)UserContext.current().getUser().getUserName(), (Long)fileId);
        if (!hasRightsToReadFile) {
            throw new NotFullRightsException();
        }
        return this.documentSearchInformationService.getDocumentData(documentClassId, documentId);
    }

    @GetMapping(value={"extended"})
    public ExtendedDocumentData getExtendedDocumentInfo(@PathVariable Long documentClassId, @PathVariable Long documentId, @PathVariable Long fileId) {
        boolean hasRightsToReadFile = Authorization.hasRightsToReadFile((String)UserContext.current().getUser().getUserName(), (Long)fileId);
        if (!hasRightsToReadFile) {
            throw new NotFullRightsException();
        }
        return this.documentSearchInformationService.getExtendedDocumentData(documentClassId, documentId, fileId);
    }

    @ConstructorProperties(value={"documentSearchInformationService"})
    @Autowired
    public DocumentSearchInformationController(DocumentSearchInformationService documentSearchInformationService) {
        this.documentSearchInformationService = documentSearchInformationService;
    }
}

