/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.dashboards;

import com.suncode.plugin.dashboard.SystemDashboardService;
import com.suncode.plugin.dashboard.web.support.dto.DashboardDto;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserGroup;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.exception.GroupNotFoundException;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import com.suncode.pwfl.dashboard.internal.support.DashboardMapper;
import com.suncode.pwfl.dashboard.persistence.DashboardFinder;
import com.suncode.pwfl.dashboard.persistence.Pagination;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"dashboards"})
public class DashboardQueryController {
    private static final Logger log = LoggerFactory.getLogger(DashboardQueryController.class);
    private final DashboardFinder dashboardFinder;
    private final UserService userService;
    private final DashboardMapper dashboardMapper;
    private final SystemDashboardService systemDashboardService;
    private final AuthorizationHelper authorizationHelper;
    private final MessageHelperBean messageHelper;

    @RequestMapping(value={"query"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DashboardDto> findDashboards(@RequestParam String type, @RequestParam(required=false) String query, @RequestParam(value="user", required=false) String username, @RequestParam(value="group", required=false) String groupname, Pagination pagination) throws GroupNotFoundException {
        CountedResult results;
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        if (StringUtils.hasText((String)username)) {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            user = this.userService.getUser(username, new String[]{"groups"});
            if (user == null) {
                throw new UserNotFoundException();
            }
        }
        UserGroup group = null;
        if (StringUtils.hasText((String)groupname)) {
            this.authorizationHelper.assertFullAdministrationRights(() -> {});
            group = this.userService.getGroup(groupname, new String[0]);
            if (group == null) {
                throw new GroupNotFoundException();
            }
        }
        if ("created".equalsIgnoreCase(type)) {
            results = this.dashboardFinder.findCreatedBy(user);
        } else if ("shared".equalsIgnoreCase(type)) {
            results = this.dashboardFinder.findSharedTo(user);
        } else {
            if ("all".equalsIgnoreCase(type)) {
                CountedResult results2 = group != null ? this.dashboardFinder.findAvailableTo(group) : this.dashboardFinder.findAvailableTo(user);
                List systemDashboards = group != null ? this.systemDashboardService.getSystemDashboardsForGroup(group) : this.systemDashboardService.getSystemDashboardsForUser(user);
                return this.dashboardMapper.getPagedDashboards(systemDashboards, results2.getData(), pagination, query);
            }
            throw new IllegalArgumentException("Invalid query type");
        }
        List dashboardDtos = results.getData().stream().filter(Objects::nonNull).map(arg_0 -> ((DashboardMapper)this.dashboardMapper).fromDashboard(arg_0)).collect(Collectors.toList());
        return this.dashboardMapper.convert(dashboardDtos, pagination, query);
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"dashboardFinder", "userService", "dashboardMapper", "systemDashboardService", "authorizationHelper", "messageHelper"})
    @Autowired
    public DashboardQueryController(DashboardFinder dashboardFinder, UserService userService, DashboardMapper dashboardMapper, SystemDashboardService systemDashboardService, AuthorizationHelper authorizationHelper, MessageHelperBean messageHelper) {
        this.dashboardFinder = dashboardFinder;
        this.userService = userService;
        this.dashboardMapper = dashboardMapper;
        this.systemDashboardService = systemDashboardService;
        this.authorizationHelper = authorizationHelper;
        this.messageHelper = messageHelper;
    }
}

