/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.calendar;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.builder.AuditParamsBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.calendar.Calendar;
import com.suncode.pwfl.calendar.ViewCalendar;
import com.suncode.pwfl.calendar.api.CalendarFacade;
import com.suncode.pwfl.calendar.view.api.ViewCalendarService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.web.dto.calendar.CalendarDto;
import com.suncode.pwfl.web.dto.calendar.ViewCalendarDto;
import com.suncode.pwfl.web.dto.calendar.event.ViewCalendarEventDto;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.calendar.CalendarMapper;
import com.suncode.pwfl.web.support.form.cache.MissingSearchCriteriaException;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import io.swagger.annotations.Api;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.fortuna.ical4j.data.CalendarOutputter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"calendar/view"})
@Api(hidden=true)
public class ViewCalendarController {
    private static final Logger log = LoggerFactory.getLogger(ViewCalendarController.class);
    private final CalendarFacade calendarFacade;
    private final UserService userService;
    private final CalendarMapper calendarMapper;
    private final ViewCalendarService viewCalendarService;
    private final SearchFormCache searchFormCache;
    private final MessageHelperBean messageHelperBean;

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public CalendarDto createViewCalendar(@RequestBody ViewCalendarDto calendarDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_VIEW_CALENDAR);
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder();
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ViewCalendar viewCalendar = this.calendarMapper.toViewCalendar(calendarDto);
            viewCalendar.setOwner(user);
            auditParamsBuilder.params(this.paramsFromViewCalendar(viewCalendar));
            ViewCalendar createdCalendar = (ViewCalendar)this.calendarFacade.createCalendar((Calendar)viewCalendar);
            auditParamsBuilder.params(this.paramsFromViewCalendar(createdCalendar));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toCalendarDto((Calendar)createdCalendar);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @PatchMapping(value={"{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public CalendarDto updateViewCalendar(@PathVariable Long id, @RequestBody ViewCalendarDto calendarDto, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)id);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_VIEW_CALENDAR);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ViewCalendar viewCalendar = this.calendarMapper.toViewCalendar(calendarDto);
            viewCalendar.setOwner(user);
            auditParamsBuilder.params(this.paramsFromViewCalendar(viewCalendar));
            ViewCalendar oldViewCalendar = (ViewCalendar)this.viewCalendarService.getCalendar(id, user);
            ViewCalendar updatedCalendar = (ViewCalendar)this.calendarFacade.updateCalendar(id.longValue(), (Calendar)viewCalendar);
            auditParamsBuilder.params(this.paramsFromViewCalendar(oldViewCalendar, updatedCalendar));
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.calendarMapper.toCalendarDto((Calendar)updatedCalendar);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{id}"})
    public RestResult deleteViewCalendar(@PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_VIEW_CALENDAR).params(new AuditParamsBuilder().param("id", (Object)id).build());
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ViewCalendar viewCalendar = new ViewCalendar(id);
            this.calendarFacade.deleteCalendar((Calendar)viewCalendar, user);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"{calendarId}/events"})
    public List<ViewCalendarEventDto> getEventsForViewCalendar(@PathVariable Long calendarId, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime fromDateTime, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) OffsetDateTime toDateTime, @RequestParam(required=false) String searchId, @RequestParam(name="timeZone", required=false, defaultValue="UTC") String timeZoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[]{"groups"});
        ViewCalendar calendar = new ViewCalendar(calendarId);
        SearchFormModelDto searchFormModel = searchId == null ? null : this.searchFormCache.getSearchFormFromCache(searchId).orElseThrow(() -> new MissingSearchCriteriaException(this.messageHelperBean.getMessage("Niepoprawne_kryteria_wyszukiwania")));
        return this.viewCalendarService.getEventsForCalendarByInterval(calendar.getId(), user, fromDateTime, toDateTime, searchFormModel, timeZone).stream().map(this.calendarMapper::toViewCalendarEventDto).toList();
    }

    @Nullable
    @GetMapping(value={"{calendarId}/share/link"})
    public String getCalendarShareLink(@PathVariable Long calendarId) {
        User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
        Calendar calendar = this.calendarFacade.getCalendarForUser((Calendar)new ViewCalendar(calendarId), user);
        return calendar.getShareLinkId() != null ? this.buildShareCalendarUrl(calendar.getShareLinkId()) : null;
    }

    @GetMapping(value={"{calendarId}/share/link/generate"})
    public String generateCalendarShareLink(@PathVariable Long calendarId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)calendarId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_GENERATE_VIEW_CALENDAR_SHARE_LINK);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ViewCalendar viewCalendar = (ViewCalendar)this.viewCalendarService.getCalendar(calendarId, user);
            auditParamsBuilder.param("name", (Object)viewCalendar.getName());
            String shareLinkId = this.calendarFacade.generateCalendarShareLink((Calendar)new ViewCalendar(calendarId), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return this.buildShareCalendarUrl(shareLinkId);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @DeleteMapping(value={"{calendarId}/share/link"})
    public RestResult deleteCalendarShareLink(@PathVariable Long calendarId, HttpServletRequest request) {
        AuditParamsBuilder auditParamsBuilder = new AuditParamsBuilder().param("id", (Object)calendarId);
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_VIEW_CALENDAR_SHARE_LINK);
        try {
            User user = this.userService.getUser(UserContext.current().getUser().getUserName(), new String[0]);
            ViewCalendar viewCalendar = (ViewCalendar)this.viewCalendarService.getCalendar(calendarId, user);
            auditParamsBuilder.param("name", (Object)viewCalendar.getName());
            this.calendarFacade.deleteCalendarShareLink((Calendar)new ViewCalendar(calendarId), user);
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildSuccess());
            return new RestResult(true);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.params(auditParamsBuilder.build()).buildFailure());
            throw e;
        }
    }

    @GetMapping(value={"share/link/{shareLinkId}"})
    public ResponseEntity<byte[]> getCalendarIcalResource(@PathVariable String shareLinkId) {
        net.fortuna.ical4j.model.Calendar icalCalendar = this.calendarFacade.buildIcalCalendar((Calendar)new ViewCalendar(shareLinkId));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CalendarOutputter outputter = new CalendarOutputter();
        try {
            outputter.output(icalCalendar, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            log.error("Error on creating ICS file for resource " + shareLinkId, (Throwable)e);
            return new ResponseEntity((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
        byte[] icalBytes = byteArrayOutputStream.toByteArray();
        String fileFormat = ".ics";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"text/calendar"));
        headers.setContentDispositionFormData("attachment", shareLinkId + ".ics");
        return new ResponseEntity((Object)icalBytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    private String buildShareCalendarUrl(String shareLinkId) {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path("/api/calendar/view/share/link/{shareLinkId}").buildAndExpand(new Object[]{shareLinkId}).toUriString();
    }

    private Map<String, Object> paramsFromViewCalendar(ViewCalendar viewCalendar) {
        return new AuditParamsBuilder().param("name", (Object)StringUtils.defaultString((String)viewCalendar.getName())).param("color", (Object)StringUtils.defaultString((String)viewCalendar.getColor())).param("viewId", (Object)Optional.ofNullable(viewCalendar.getView().getId()).map(String::valueOf).orElse("")).param("variableIdStartDateTime", (Object)StringUtils.defaultString((String)viewCalendar.getVariableIdStartDateTime())).param("variableIdEndDateTime", (Object)StringUtils.defaultString((String)viewCalendar.getVariableIdEndDateTime())).param("durationMinutes", (Object)Optional.ofNullable(viewCalendar.getDurationMinutes()).map(String::valueOf).orElse("")).param("allDay", (Object)viewCalendar.isAllDay()).param("nameTemplate", (Object)StringUtils.defaultString((String)viewCalendar.getNameTemplate())).param("nameTemplateMonth", (Object)StringUtils.defaultString((String)viewCalendar.getNameTemplateMonth())).param("nameTemplateWeek", (Object)StringUtils.defaultString((String)viewCalendar.getNameTemplateWeek())).param("nameTemplateDay", (Object)StringUtils.defaultString((String)viewCalendar.getNameTemplateDay())).param("descriptionTemplate", (Object)StringUtils.defaultString((String)viewCalendar.getDescriptionTemplate())).build();
    }

    private Map<String, Object> paramsFromViewCalendar(ViewCalendar oldViewCalendar, ViewCalendar newViewCalendar) {
        return new AuditParamsBuilder().param("name", (Object)StringUtils.defaultString((String)oldViewCalendar.getName()), (Object)StringUtils.defaultString((String)newViewCalendar.getName())).param("color", (Object)StringUtils.defaultString((String)oldViewCalendar.getColor()), (Object)StringUtils.defaultString((String)newViewCalendar.getColor())).param("viewId", (Object)Optional.ofNullable(oldViewCalendar.getView().getId()).map(String::valueOf).orElse(""), (Object)Optional.ofNullable(newViewCalendar.getView().getId()).map(String::valueOf).orElse("")).param("variableIdStartDateTime", (Object)StringUtils.defaultString((String)oldViewCalendar.getVariableIdStartDateTime()), (Object)StringUtils.defaultString((String)newViewCalendar.getVariableIdStartDateTime())).param("variableIdEndDateTime", (Object)StringUtils.defaultString((String)oldViewCalendar.getVariableIdEndDateTime()), (Object)StringUtils.defaultString((String)newViewCalendar.getVariableIdEndDateTime())).param("durationMinutes", (Object)Optional.ofNullable(oldViewCalendar.getDurationMinutes()).map(String::valueOf).orElse(""), (Object)Optional.ofNullable(newViewCalendar.getDurationMinutes()).map(String::valueOf).orElse("")).param("allDay", (Object)oldViewCalendar.isAllDay(), (Object)newViewCalendar.isAllDay()).param("nameTemplate", (Object)StringUtils.defaultString((String)oldViewCalendar.getNameTemplate()), (Object)StringUtils.defaultString((String)newViewCalendar.getNameTemplate())).param("nameTemplateMonth", (Object)StringUtils.defaultString((String)oldViewCalendar.getNameTemplateMonth()), (Object)StringUtils.defaultString((String)newViewCalendar.getNameTemplateMonth())).param("nameTemplateWeek", (Object)StringUtils.defaultString((String)oldViewCalendar.getNameTemplateWeek()), (Object)StringUtils.defaultString((String)newViewCalendar.getNameTemplateWeek())).param("nameTemplateDay", (Object)StringUtils.defaultString((String)oldViewCalendar.getNameTemplateDay()), (Object)StringUtils.defaultString((String)newViewCalendar.getNameTemplateDay())).param("descriptionTemplate", (Object)StringUtils.defaultString((String)oldViewCalendar.getDescriptionTemplate()), (Object)StringUtils.defaultString((String)newViewCalendar.getDescriptionTemplate())).build();
    }

    @ConstructorProperties(value={"calendarFacade", "userService", "calendarMapper", "viewCalendarService", "searchFormCache", "messageHelperBean"})
    @Autowired
    public ViewCalendarController(CalendarFacade calendarFacade, UserService userService, CalendarMapper calendarMapper, ViewCalendarService viewCalendarService, SearchFormCache searchFormCache, MessageHelperBean messageHelperBean) {
        this.calendarFacade = calendarFacade;
        this.userService = userService;
        this.calendarMapper = calendarMapper;
        this.viewCalendarService = viewCalendarService;
        this.searchFormCache = searchFormCache;
        this.messageHelperBean = messageHelperBean;
    }
}

