/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.user;

import com.suncode.pwfl.administration.user.DefaultUserSettingsService;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.web.controller.api.administration.user.UserSettingsHelper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import java.beans.ConstructorProperties;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"user/settings/default"})
public class DefaultUserSettingsController {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserSettingsController.class);
    private static final String DEFAULT_VIEW_NAME_PROP = "defaultViewName";
    private final DefaultUserSettingsService defaultUserSettingsService;
    private final UserSettingsHelper userSettingsHelper;

    @GetMapping
    public Map<String, String> getDefaultSettings() {
        Map defaultSettings = this.defaultUserSettingsService.getDefaultSettings();
        defaultSettings.put(DEFAULT_VIEW_NAME_PROP, this.getDefaultViewName(defaultSettings));
        return defaultSettings;
    }

    private String getDefaultViewName(Map<String, String> defaultSettings) {
        String defaultView = defaultSettings.getOrDefault(UserSettingsService.UserSetting.DEFAULT_VIEW.getName(), "");
        return this.userSettingsHelper.getDefaultViewName(new AtomicReference<String>(defaultView));
    }

    @PostMapping
    public RestResult getDefaultSettings(@RequestBody DefaultUserSettings defaultUserSettings) {
        try {
            this.defaultUserSettingsService.saveDefaultSettings(this.toSettingsMap(defaultUserSettings));
            return new RestResult(true);
        }
        catch (Exception e) {
            log.info("Failed to save global user settings", (Throwable)e);
            return new RestResult(false, e.getMessage());
        }
    }

    private Map<UserSettingsService.UserSetting, String> toSettingsMap(DefaultUserSettings defaultSettings) {
        EnumMap<UserSettingsService.UserSetting, String> settings = new EnumMap<UserSettingsService.UserSetting, String>(UserSettingsService.UserSetting.class);
        if (defaultSettings.language() != null) {
            settings.put(UserSettingsService.UserSetting.LANGUAGE, defaultSettings.language());
        }
        if (defaultSettings.pageSize() != null) {
            settings.put(UserSettingsService.UserSetting.PAGE_SIZE, defaultSettings.pageSize());
        }
        if (defaultSettings.template() != null) {
            settings.put(UserSettingsService.UserSetting.TEMPLATE, defaultSettings.template());
        }
        if (defaultSettings.compactTemplate() != null) {
            settings.put(UserSettingsService.UserSetting.COMPACT_TEMPLATE, defaultSettings.compactTemplate());
        }
        if (defaultSettings.defaultView() != null) {
            settings.put(UserSettingsService.UserSetting.DEFAULT_VIEW, defaultSettings.defaultView());
        }
        if (defaultSettings.notifs() != null) {
            settings.put(UserSettingsService.UserSetting.NOTIFICATIONS, defaultSettings.notifs());
        }
        if (defaultSettings.emails() != null) {
            settings.put(UserSettingsService.UserSetting.EMAILS, defaultSettings.emails());
        }
        if (defaultSettings.taskAvatar() != null) {
            settings.put(UserSettingsService.UserSetting.TASK_AVATAR, defaultSettings.taskAvatar());
        }
        if (defaultSettings.viewAvatar() != null) {
            settings.put(UserSettingsService.UserSetting.VIEW_AVATAR, defaultSettings.viewAvatar());
        }
        return settings;
    }

    @ConstructorProperties(value={"defaultUserSettingsService", "userSettingsHelper"})
    public DefaultUserSettingsController(DefaultUserSettingsService defaultUserSettingsService, UserSettingsHelper userSettingsHelper) {
        this.defaultUserSettingsService = defaultUserSettingsService;
        this.userSettingsHelper = userSettingsHelper;
    }

    private record DefaultUserSettings(String language, String pageSize, String template, String compactTemplate, String defaultView, String notifs, String emails, String taskAvatar, String viewAvatar) {
    }
}

