/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.administration.email;

import com.google.common.collect.ImmutableMap;
import com.suncode.pwfl.administration.email.EmailMessage;
import com.suncode.pwfl.administration.email.EmailService;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.administration.email.configuration.EmailConfigurationService;
import com.suncode.pwfl.administration.email.oauth.connection.ConnectionRefreshException;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.translation.TranslationService;
import com.suncode.pwfl.translation.TranslatorScope;
import com.suncode.pwfl.util.exception.EmptyPropertyException;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.dto.administration.email.AddOrUpdateEmailConfigurationDto;
import com.suncode.pwfl.web.dto.administration.email.EmailConfigurationDto;
import com.suncode.pwfl.web.dto.administration.email.TestResultDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.support.EmailConfigurationMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/email/config"})
@Api(tags={"email config"})
public class EmailConfigurationController {
    private static final Logger log = LoggerFactory.getLogger(EmailConfigurationController.class);
    @Autowired
    private EmailConfigurationService emailConfigurationService;
    @Autowired
    private AuthorizationHelper authorizationHelper;
    @Autowired
    private TranslationService translationService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private EmailConfigurationMapper emailConfigurationMapper;
    @Autowired
    private MessageHelperBean messageHelperBean;

    @ApiOperation(value="(Admin) Adding email configuration", notes="The executed query saves new email configuration. The query is a JSON object with the following fields: \n- **id** - Id of the configuration\n- **name** - Name of the configuration\n- **email** - Email address displayed as a sender\n- **defaultConfiguration** - Specify whether this is the default configuration\n- **mailServer** - Server name displayed in the email sender's address\n- **smtpMailServer** - Address of the SMTP server responsible for sending messages\n- **smtpPortNumber** - Port number of the SMTP server\n- **sourceAddress** - Alias of the box sending notifications\n- **timeout** - Maximum waiting time for connection to a server (in milliseconds)\n- **mailUser** - User name displayed in the email sender's address\n- **useSSL** - This parameter defines if a safe SSL/TLS connection is to be used\n- **userStartTLS** - This parameter defines if a StartTls is to be used\n- **smtpUser** - Name of the SMTP server user responsible for sending messages\n- **userPassword** - Password of the SMTP server user responsible for sending messages\n- **debug** - Logging details of messages sent. Messages are logged in the \"com.plusmpm.email.MailClient\" logger\n- **emailAuthenticationMethod** - Authentication method; PASSWORD/OAUTH\n- **oauth2Connection** - list of indexes to display\n- **bufferSender** - buffered send\n- **if bufferSender = true**\n- **maxAttempts** - Number of message sending attempts in case the first attempt fails\n- **period** - Frequency with which the system checks if there are any messages to send (in milliseconds)\n- **tryAfter** - Minimum time after which message sending is retried (in milliseconds)\n- **sendCopy** - send copies to given addresses\n- **if sendCopy = true**\n- **sendCopyRecipients** - addresses(seperated by semicolon)\n- **sendCopyRecipientsType** - type of copy (TO, COPY, BLIND_COPY)")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    @ResponseBody
    @PostMapping
    public EmailConfigurationDto createNew(@ApiParam(value="Email configuration", required=true) @RequestBody AddOrUpdateEmailConfigurationDto addOrUpdateEmailConfigurationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_EMAIL_CONFIGURATION);
        auditBuilder.params((Map)this.emailConfigAuditParamsBuilder(addOrUpdateEmailConfigurationDto).build());
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            EmailConfiguration emailConfiguration = this.emailConfigurationMapper.toEntity(addOrUpdateEmailConfigurationDto);
            this.emailConfigurationService.save((Object)emailConfiguration);
            if (emailConfiguration.getBufferedSender().booleanValue()) {
                this.emailService.startTimer((EmailConfiguration)this.emailConfigurationService.get((Serializable)emailConfiguration.getId()));
            }
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new EmailConfigurationDto(emailConfiguration);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="(Admin) Downloading a list of email configurations", notes="Retrieves a list of available email configurations")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @GetMapping
    public List<EmailConfigurationDto> getAll() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        return this.emailConfigurationService.getAll(new String[]{"oauth2Connection"}).stream().map(EmailConfigurationDto::new).collect(Collectors.toList());
    }

    @ApiOperation(value="(Admin) Downloading an email configuration", notes="Retrieves a email configuration with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @GetMapping(value={"/{id}"})
    public ResponseEntity<EmailConfigurationDto> getById(@ApiParam(value="Id of the email configuration", required=true) @PathVariable long id) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        EmailConfiguration emailConfiguration = (EmailConfiguration)this.emailConfigurationService.get((Serializable)Long.valueOf(id), new String[]{"oauth2Connection"});
        if (emailConfiguration == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new EmailConfigurationDto(emailConfiguration), (HttpStatusCode)HttpStatus.OK);
    }

    @ApiOperation(value="(Admin) Editing email configuration", notes="The executed query saves new email configuration. The query is a JSON object with the following fields: \n- **id** - Id of the configuration\n- **name** - Name of the configuration\n- **email** - Email address displayed as a sender\n- **defaultConfiguration** - Specify whether this is the default configuration\n- **mailServer** - Server name displayed in the email sender's address\n- **smtpMailServer** - Address of the SMTP server responsible for sending messages\n- **smtpPortNumber** - Port number of the SMTP server\n- **sourceAddress** - Alias of the box sending notifications\n- **timeout** - Maximum waiting time for connection to a server (in milliseconds)\n- **mailUser** - User name displayed in the email sender's address\n- **useSSL** - This parameter defines if a safe SSL/TLS connection is to be used\n- **userStartTLS** - This parameter defines if a StartTls is to be used\n- **smtpUser** - Name of the SMTP server user responsible for sending messages\n- **userPassword** - Password of the SMTP server user responsible for sending messages\n- **debug** - Logging details of messages sent. Messages are logged in the \"com.plusmpm.email.MailClient\" logger\n- **emailAuthenticationMethod** - Authentication method; PASSWORD/OAUTH\n- **oauth2Connection** - list of indexes to display\n- **bufferSender** - buffered send\n- **if bufferSender = true**\n- **maxAttempts** - Number of message sending attempts in case the first attempt fails\n- **period** - Frequency with which the system checks if there are any messages to send (in milliseconds)\n- **tryAfter** - Minimum time after which message sending is retried (in milliseconds)\n- **sendCopy** - send copies to given addresses\n- **if sendCopy = true**\n- **sendCopyRecipients** - addresses(seperated by semicolon)\n- **sendCopyRecipientsType** - type of copy (TO, COPY, BLIND_COPY)")
    @ApiResponses(value={@ApiResponse(code=200, message="OK")})
    @ResponseBody
    @PatchMapping
    public ResponseEntity<RestResult> update(@ApiParam(value="Email configuration", required=true) @RequestBody AddOrUpdateEmailConfigurationDto addOrUpdateEmailConfigurationDto, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_EMAIL_CONFIGURATION);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        try {
            EmailConfiguration emailConfiguration = Optional.ofNullable((EmailConfiguration)this.emailConfigurationService.get((Serializable)addOrUpdateEmailConfigurationDto.getId(), new String[]{"oauth2Connection"})).orElseThrow(() -> new ServiceException(this.messageHelperBean.getMessage("Nie_znaleziono_konfiguracji_skrzynki_pocztowej_o_podanym_identyfikatorze", new Object[]{addOrUpdateEmailConfigurationDto.getId()})));
            auditBuilder.params((Map)this.emailConfigChangeAuditParamsBuilder(emailConfiguration, addOrUpdateEmailConfigurationDto).build());
            if (emailConfiguration.getDefaultConfiguration().booleanValue() && !addOrUpdateEmailConfigurationDto.isDefaultConfiguration()) {
                throw new ServiceException(this.messageHelperBean.getMessage("Nie_mozna_odznaczyc_konfiguracji_jako_domyslnej"));
            }
            EmailConfiguration updatedEmailConfiguration = this.emailConfigurationMapper.toEntity(addOrUpdateEmailConfigurationDto);
            this.emailConfigurationService.update((Object)updatedEmailConfiguration);
            if (emailConfiguration.getBufferedSender() != updatedEmailConfiguration.getBufferedSender() || !Objects.equals(emailConfiguration.getPeriod(), updatedEmailConfiguration.getPeriod())) {
                if (updatedEmailConfiguration.getBufferedSender().booleanValue()) {
                    this.emailService.startTimer(updatedEmailConfiguration);
                } else {
                    this.emailService.stopTimer(updatedEmailConfiguration);
                }
            }
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new ResponseEntity((Object)new RestResult(true), (HttpStatusCode)HttpStatus.OK);
    }

    @ApiOperation(value="(Admin) Deleting email configuration", notes="Deletes an email configuration with given id")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<RestResult> deleteEmailConfiguration(@ApiParam(value="Id of the email configuration", required=true) @PathVariable Long id, HttpServletRequest request) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_EMAIL_CONFIGURATION);
        this.authorizationHelper.assertFullAdministrationRights(() -> request.setAttribute("audit", (Object)auditBuilder.buildFailure()));
        auditBuilder.params((Map)ImmutableMap.of((Object)"EMAIL_CONFIGURATION_ID", (Object)id));
        try {
            EmailConfiguration emailConfiguration = Optional.ofNullable((EmailConfiguration)this.emailConfigurationService.get((Serializable)id, new String[]{"oauth2Connection"})).orElseThrow(() -> new ServiceException(this.messageHelperBean.getMessage("Nie_znaleziono_konfiguracji_skrzynki_pocztowej_o_podanym_identyfikatorze", new Object[]{id})));
            if (emailConfiguration.getDefaultConfiguration().booleanValue()) {
                throw new ServiceException(this.messageHelperBean.getMessage("Nie_mozna_usunac_domyslnej_konfiguracji"));
            }
            this.emailService.stopTimer(emailConfiguration);
            this.emailConfigurationService.delete((Object)emailConfiguration);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new ResponseEntity((Object)new RestResult(true), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
    }

    @ApiOperation(value="(Admin) Testing an email configuration", notes="Test an email configuration")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Forbidden")})
    @ResponseBody
    @PostMapping(value={"test"})
    public TestResultDto test(@ApiParam(value="Email configuration", required=true) @RequestBody AddOrUpdateEmailConfigurationDto addOrUpdateEmailConfigurationDto, @ApiParam(value="Send to (enter email address)", required=true) @RequestParam String sendTo, @ApiParam(value="Subject of the email message", required=true) @RequestParam String subject, @ApiParam(value="Content of the email message", required=true) @RequestParam String content) {
        String errorMessage = null;
        try {
            EmailMessage emailMessage = EmailMessage.builder().recipient(sendTo).subject(subject).content(content).isHtml(false).test(true).build();
            this.emailService.send(emailMessage, this.emailConfigurationMapper.toEntity(addOrUpdateEmailConfigurationDto));
        }
        catch (ConnectionRefreshException connectionRefreshException) {
            errorMessage = this.translationService.translate("oauth_refresh_error", TranslatorScope.SERVER);
            log.error("B\u0142\u0105d podczas testowania konfiguracji email", (Throwable)connectionRefreshException);
        }
        catch (Exception e) {
            errorMessage = this.translationService.translate("email_default_error_message", TranslatorScope.SERVER);
            log.error("B\u0142\u0105d podczas testowania konfiguracji email", (Throwable)e);
        }
        return new TestResultDto(errorMessage);
    }

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RestResult handleServiceException(ServiceException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={EmptyPropertyException.class})
    @ResponseStatus(value=HttpStatus.PARTIAL_CONTENT)
    @ResponseBody
    public RestResult handleEmptyPropertyException(EmptyPropertyException e) {
        log.info(e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public RestResult handleUnknownException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return new RestResult(false, e.getMessage());
    }

    private ImmutableMap.Builder<String, Object> emailConfigAuditParamsBuilder(AddOrUpdateEmailConfigurationDto addOrUpdateEmailConfigurationDto) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"EMAIL_CONFIGURATION_NAME", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getName(), "")).put((Object)"EMAIL_CONFIGURATION_EMAIL", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getEmail(), "")).put((Object)"EMAIL_CONFIGURATION_DEFAULT_CONFIGURATION", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.isDefaultConfiguration(), "")).put((Object)"EMAIL_CONFIGURATION_MAIL_SERVER", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getMailServer(), "")).put((Object)"EMAIL_CONFIGURATION_SMTP_MAIL_SERVER", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getSmtpMailServer(), "")).put((Object)"EMAIL_CONFIGURATION_SMTP_PORT_NUMBER", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getSmtpPortNumber(), "")).put((Object)"EMAIL_CONFIGURATION_SOURCE_ADDRESS", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getSourceAddress(), "")).put((Object)"EMAIL_CONFIGURATION_TIMEOUT", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getTimeout(), "")).put((Object)"EMAIL_CONFIGURATION_MAIL_USER", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getMailUser(), "")).put((Object)"EMAIL_CONFIGURATION_USE_SSL", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.isUseSSL(), "")).put((Object)"EMAIL_CONFIGURATION_USE_STARTTLS", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.isUseStartTLS(), "")).put((Object)"EMAIL_CONFIGURATION_SMTP_USER", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getSmtpUser(), "")).put((Object)"EMAIL_CONFIGURATION_DEBUG", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.isDebug(), "")).put((Object)"EMAIL_CONFIGURATION_EMAIL_AUTHENTICATION_METHOD", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getEmailAuthenticationMethod(), "")).put((Object)"EMAIL_CONFIGURATION_BUFFERED_SENDER", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.isBufferSender(), "")).put((Object)"EMAIL_CONFIGURATION_MAX_ATTEMPTS", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getMaxAttempts(), "")).put((Object)"EMAIL_CONFIGURATION_PERIOD", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getPeriod(), "")).put((Object)"EMAIL_CONFIGURATION_TRY_AFTER", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getTryAfter(), "")).put((Object)"EMAIL_CONFIGURATION_SEND_COPY", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.isSendCopy(), "")).put((Object)"EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getSendCopyRecipients(), "")).put((Object)"EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS_TYPE", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getSendCopyRecipientsType(), ""));
        if (addOrUpdateEmailConfigurationDto.getOauth2Connection() != null) {
            builder.put((Object)"OAUTH2_CONNECTION_ID", (Object)Objects.toString(addOrUpdateEmailConfigurationDto.getOauth2Connection(), ""));
        }
        return builder;
    }

    private ImmutableMap.Builder<String, Object> emailConfigChangeAuditParamsBuilder(EmailConfiguration oldConfiguration, AddOrUpdateEmailConfigurationDto addOrUpdateEmailConfigurationDto) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"EMAIL_CONFIGURATION_ID", (Object)Objects.toString(oldConfiguration.getId(), "")).put((Object)"EMAIL_CONFIGURATION_NAME", (Object)this.generateChangeString(oldConfiguration.getName(), addOrUpdateEmailConfigurationDto.getName())).put((Object)"EMAIL_CONFIGURATION_EMAIL", (Object)this.generateChangeString(oldConfiguration.getEmail(), addOrUpdateEmailConfigurationDto.getEmail())).put((Object)"EMAIL_CONFIGURATION_DEFAULT_CONFIGURATION", (Object)this.generateChangeString(oldConfiguration.getDefaultConfiguration(), addOrUpdateEmailConfigurationDto.isDefaultConfiguration())).put((Object)"EMAIL_CONFIGURATION_MAIL_SERVER", (Object)this.generateChangeString(oldConfiguration.getMailServer(), addOrUpdateEmailConfigurationDto.getMailServer())).put((Object)"EMAIL_CONFIGURATION_SMTP_MAIL_SERVER", (Object)this.generateChangeString(oldConfiguration.getSmtpMailServer(), addOrUpdateEmailConfigurationDto.getSmtpMailServer())).put((Object)"EMAIL_CONFIGURATION_SMTP_PORT_NUMBER", (Object)this.generateChangeString(oldConfiguration.getSmtpPortNumber(), addOrUpdateEmailConfigurationDto.getSmtpPortNumber())).put((Object)"EMAIL_CONFIGURATION_SOURCE_ADDRESS", (Object)this.generateChangeString(oldConfiguration.getSourceAddress(), addOrUpdateEmailConfigurationDto.getSourceAddress())).put((Object)"EMAIL_CONFIGURATION_TIMEOUT", (Object)this.generateChangeString(oldConfiguration.getTimeout(), addOrUpdateEmailConfigurationDto.getTimeout())).put((Object)"EMAIL_CONFIGURATION_MAIL_USER", (Object)this.generateChangeString(oldConfiguration.getMailServer(), addOrUpdateEmailConfigurationDto.getMailServer())).put((Object)"EMAIL_CONFIGURATION_USE_SSL", (Object)this.generateChangeString(oldConfiguration.getUseSSL(), addOrUpdateEmailConfigurationDto.isUseSSL())).put((Object)"EMAIL_CONFIGURATION_USE_STARTTLS", (Object)this.generateChangeString(oldConfiguration.getUseStartTLS(), addOrUpdateEmailConfigurationDto.isUseStartTLS())).put((Object)"EMAIL_CONFIGURATION_SMTP_USER", (Object)this.generateChangeString(oldConfiguration.getSmtpUser(), addOrUpdateEmailConfigurationDto.getSmtpUser())).put((Object)"EMAIL_CONFIGURATION_DEBUG", (Object)this.generateChangeString(oldConfiguration.getDebug(), addOrUpdateEmailConfigurationDto.isDebug())).put((Object)"EMAIL_CONFIGURATION_EMAIL_AUTHENTICATION_METHOD", (Object)this.generateChangeString(oldConfiguration.getEmailAuthenticationMethod(), addOrUpdateEmailConfigurationDto.getEmailAuthenticationMethod())).put((Object)"EMAIL_CONFIGURATION_BUFFERED_SENDER", (Object)this.generateChangeString(oldConfiguration.getBufferedSender(), addOrUpdateEmailConfigurationDto.isBufferSender())).put((Object)"EMAIL_CONFIGURATION_MAX_ATTEMPTS", (Object)this.generateChangeString(oldConfiguration.getMaxAttempts(), addOrUpdateEmailConfigurationDto.getMaxAttempts())).put((Object)"EMAIL_CONFIGURATION_PERIOD", (Object)this.generateChangeString(oldConfiguration.getPeriod(), addOrUpdateEmailConfigurationDto.getPeriod())).put((Object)"EMAIL_CONFIGURATION_TRY_AFTER", (Object)this.generateChangeString(oldConfiguration.getTryAfter(), addOrUpdateEmailConfigurationDto.getTryAfter())).put((Object)"EMAIL_CONFIGURATION_SEND_COPY", (Object)this.generateChangeString(oldConfiguration.getSendCopy(), addOrUpdateEmailConfigurationDto.isSendCopy())).put((Object)"EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS", (Object)this.generateChangeString(oldConfiguration.getSendCopyRecipients(), addOrUpdateEmailConfigurationDto.getSendCopyRecipients())).put((Object)"EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS_TYPE", (Object)this.generateChangeString(oldConfiguration.getSendCopyRecipientsType(), addOrUpdateEmailConfigurationDto.getSendCopyRecipientsType()));
        Long oldConnectionId = oldConfiguration.getOauth2Connection() != null ? oldConfiguration.getOauth2Connection().getId() : null;
        Long newConnectionId = addOrUpdateEmailConfigurationDto.getOauth2Connection() != null ? addOrUpdateEmailConfigurationDto.getOauth2Connection() : null;
        builder.put((Object)"OAUTH2_CONNECTION_ID", (Object)this.generateChangeString(oldConnectionId, newConnectionId));
        return builder;
    }

    private String generateChangeString(Object oldValue, Object newValue) {
        String oldValueString = Objects.toString(oldValue, "");
        String newValueString = Objects.toString(newValue, "");
        return oldValueString + ";" + newValueString;
    }
}

