/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action.plugins;

import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.plugin.PluginManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PluginConfigurationAction
extends Action {
    public static final String PLUGIN_ID_PARAMETER_NAME = "pluginId";
    public static final String PLUGIN_NAME_ATTRIBUTE_NAME = "pluginName";
    public static final String PLUGIN_RIGHTS_ATTRIBUTE_NAME = "pluginRights";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null || (String)session.getAttribute("username") == null) {
            return mapping.findForward("welcome");
        }
        String pluginId = request.getParameter(PLUGIN_ID_PARAMETER_NAME);
        List<PluginRight> rights = this.getResourcesForPlugin(pluginId);
        request.setAttribute(PLUGIN_RIGHTS_ATTRIBUTE_NAME, rights);
        String pluginName = PluginManager.getInstance().getPlugin(pluginId).getConfiguration().getName();
        request.setAttribute(PLUGIN_NAME_ATTRIBUTE_NAME, (Object)pluginName);
        if ("displayTag".equals(request.getParameter("source"))) {
            return mapping.findForward("showPluginRights");
        }
        return mapping.findForward("showPluginConfiguration");
    }

    List<PluginRight> getResourcesForPlugin(String pluginId) {
        Set authorizedUsers = Authorization.listRights((String)RightTreeBuilder.builder().system().plugins().custom((Object)pluginId).build(), (boolean)false);
        Set authorizedGroups = Authorization.listRights((String)RightTreeBuilder.builder().system().plugins().custom((Object)pluginId).build(), (boolean)true);
        ArrayList<PluginRight> rights = new ArrayList<PluginRight>();
        for (String user : authorizedUsers) {
            rights.add(new PluginRight(user, false, pluginId));
        }
        for (String group : authorizedGroups) {
            rights.add(new PluginRight(group, true, pluginId));
        }
        return rights;
    }

    public class PluginRight {
        private boolean group;
        private String pluginId;
        private String resource;

        public PluginRight() {
        }

        public PluginRight(String resource, boolean group, String pluginId) {
            this.resource = resource;
            this.group = group;
            this.pluginId = pluginId;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public String getResource() {
            return this.resource;
        }

        public boolean isGroup() {
            return this.group;
        }

        public void setGroup(boolean group) {
            this.group = group;
        }

        public void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        public void setResource(String resource) {
            this.resource = resource;
        }
    }
}

