/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.workflow.activities.ActivityStatus;
import com.plusmpm.database.workflow.activities.ActivityStatusManagerExtended;
import com.plusmpm.struts.action.ProcessActivityContext;
import com.plusmpm.struts.action.ProcessActivityResult;
import com.plusmpm.struts.action.util.MessageType;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.administration.configuration.SystemParameterFinder;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.form.service.SystemContextService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.i18n.xpdl.PackageTranslationHelper;
import com.suncode.pwfl.transaction.support.TransactionWrapper;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.ShaKey;
import com.suncode.pwfl.util.SharkUtils;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.dto.activity.DelegatedActivityDtoConverter;
import com.suncode.pwfl.web.dto.administration.SystemParameterDto;
import com.suncode.pwfl.web.support.UserAgentUtils;
import com.suncode.pwfl.web.util.SessionUtils;
import com.suncode.pwfl.workflow.form.FormBuilderService;
import com.suncode.pwfl.workflow.form.action.ActionUIFragment;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.internal.InternalProcessService;
import com.suncode.pwfl.workflow.process.internal.exception.ActivitySuspended;
import com.suncode.pwfl.workflow.process.internal.exception.AlreadyAccepted;
import com.suncode.pwfl.workflow.process.internal.exception.AlreadyAcceptedOrAcceptingByAnotherUser;
import com.suncode.pwfl.workflow.process.internal.exception.AlreadyAcceptingByAnotherUser;
import com.suncode.pwfl.workflow.process.internal.exception.ProcessLockTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.xpdl.elements.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class ProcessActivityMobileAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(ProcessActivityMobileAction.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static final ConcurrentHashMap<String, String> lockedActivities = new ConcurrentHashMap();
    private static ShaKey processKeyGenerator = (ShaKey)SpringContext.getBean(ShaKey.class);
    private static FormBuilderService formBuilderService = (FormBuilderService)SpringContext.getBean(FormBuilderService.class);
    private static SystemParameterFinder systemParameterFinder = (SystemParameterFinder)SpringContext.getBean(SystemParameterFinder.class);
    private static TransactionWrapper transactionWrapper = (TransactionWrapper)SpringContext.getBean(TransactionWrapper.class);
    private static InternalProcessService internalProcessService = (InternalProcessService)SpringContext.getBean(InternalProcessService.class);
    private static SystemContextService systemContextService = (SystemContextService)SpringContext.getBean(SystemContextService.class);
    private static DelegatedActivityDtoConverter delegatedActivityDtoConverter = (DelegatedActivityDtoConverter)SpringContext.getBean(DelegatedActivityDtoConverter.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProcessActivityResult result;
        HttpSession session = SessionUtils.getCurrentSession();
        ProcessActivityContext context = this.buildContext(request, session);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("processKey", context.getProcessId());
        auditParams.put("activityId", context.getActivityId());
        auditParams.putAll(UserAgentUtils.resolveUserAgentAuditParams(request));
        AuditBuilder audit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_OPEN_ACTIVITY).params(auditParams);
        try {
            result = (ProcessActivityResult)transactionWrapper.doInSharkTransaction(transaction -> {
                Locale locale = context.getLocale();
                String username = context.getUsername();
                try {
                    ProcessActivityResult processActivityResult = this.proceed(context, transaction);
                    return processActivityResult;
                }
                catch (AlreadyAccepted ex) {
                    log.error("Zadanie jest ju\u017c wykonane", (Throwable)ex);
                    this.setMessage(request, locale, username, "nie_moze_wykonac_tego_zadania_gdyz_zostalo_ono_juz_wykonane_lub_jest_aktualnie_wykonywane_przez_innego_uzytkownika");
                }
                catch (ActivitySuspended ex) {
                    log.error("Zadanie jest zawieszone", (Throwable)ex);
                    this.setMessage(request, locale, context.getUsername(), "nie_moze_wykonac_tego_zadania_gdyz_zadanie_jest_zawieszone");
                }
                catch (AlreadyAcceptedOrAcceptingByAnotherUser ex) {
                    log.error("Zadanie zosta\u0142o wykonane lub jest wykonywane przez innego u\u017cytkownika", (Throwable)ex);
                    this.setMessage(request, locale, username, "nie_moze_wykonac_tego_zadania_gdyz_zostalo_ono_juz_wykonane_lub_jest_aktualnie_wykonywane_przez_innego_uzytkownika");
                }
                catch (AlreadyAcceptingByAnotherUser ex) {
                    log.error("Zadanie jest wykonywane przez innego u\u017cytkownika", (Throwable)ex);
                    this.setMessage(request, locale, username, "nie_moze_wykonac_tego_zadania_gdyz_wykonywane_jest_ono_przez_innego_uzytkownika");
                }
                catch (ProcessLockTimeoutException e) {
                    log.error("Zadanie jest obecnie wykorzystywane przez inn\u0105 operacj\u0119 w systemie", (Throwable)e);
                    request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Zadanie_jest_obecnie_wykorzystywane_przez_inna_operacje_w_systemie_Sprobuj_ponownie_pozniej", (Locale)locale, (Object[])new Object[0]));
                    request.setAttribute("messageType", (Object)MessageType.WARNING);
                }
                catch (Exception exception) {
                    if (transaction != null) {
                        Shark.getInstance().emptyCaches(transaction);
                    }
                    throw exception;
                }
                finally {
                    if (username.equals(lockedActivities.get(context.getActivityId()))) {
                        lockedActivities.remove(context.getActivityId());
                    }
                }
                return ProcessActivityResult.builder().forwardResult(mapping.findForward("notask")).build();
            });
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            request.setAttribute("auditSuccess", (Object)false);
            request.setAttribute("audit", (Object)audit.buildFailure());
            throw ex;
        }
        if (result.getForwardResult() != null) {
            return result.getForwardResult();
        }
        request.setAttribute("realusername", (Object)result.getRealUsername());
        request.setAttribute("taskusername", (Object)context.getUsername());
        request.setAttribute("originaltaskusername", session.getAttribute("originalusername"));
        request.setAttribute("message", (Object)result.getMessage());
        request.setAttribute("processId", (Object)result.getProcessId());
        request.setAttribute("activityId", (Object)result.getActivityId());
        request.setAttribute("processRightKey", (Object)processKeyGenerator.get(result.getProcessId()));
        request.setAttribute("processDefId", (Object)result.getProcessDefId());
        request.setAttribute("activityDefId", (Object)result.getActivityDefId());
        request.setAttribute("processName", (Object)result.getProcessName());
        request.setAttribute("activityName", (Object)PackageTranslationHelper.getActivityName((String)result.getPackageId(), (String)result.getProcessDefId(), (String)result.getActivityDefId()));
        request.setAttribute("packageId", (Object)result.getPackageId());
        request.setAttribute("packageVersion", (Object)result.getPackageVersion());
        String processRightKey = processKeyGenerator.get(result.getProcessId());
        request.setAttribute("suncodeForm", (Object)formBuilderService.build(result.getProcessId(), result.getActivityId(), context.getUsername(), session.getId(), ActionUIFragment.FORM_MOBILE, processRightKey, context.getViewId(), context.getSource()));
        request.setAttribute("devMode", (Object)Boolean.valueOf(request.getParameter("devMode")));
        request.setAttribute("redirect", (Object)StringUtils.defaultString((String)request.getParameter("redirect")));
        request.setAttribute("activeTab", (Object)"ShowWorkListAction.do");
        request.setAttribute("systemParameters", (Object)this.getSystemParametersJson());
        request.setAttribute("systemContext", (Object)systemContextService.buildSystemContextJson());
        request.setAttribute("activityDelegations", (Object)this.getActivityDelegationsJson(context.getActivityId(), context.getUsername()));
        request.setAttribute("auditSuccess", (Object)true);
        request.setAttribute("audit", (Object)audit.buildSuccess());
        String skin = request.getParameter("skinOverride");
        request.setAttribute("skinOverride", (Object)skin);
        return mapping.findForward("task");
    }

    private ProcessActivityResult proceed(ProcessActivityContext context, SharkTransaction transaction) {
        WfAssignment currentAssignment = internalProcessService.checkIfCanOpen(transaction, context.getUsername(), context.getProcessId(), context.getActivityId());
        String processId = context.getProcessId();
        String activityId = context.getActivityId();
        String username = context.getUsername();
        WfActivity currentActivity = currentAssignment.activity(transaction);
        if (!currentAssignment.get_accepted_status(transaction)) {
            try {
                String activityState = currentActivity.state(transaction);
                if (activityState.compareToIgnoreCase("open.running") != 0) {
                    currentActivity.change_state(transaction, "open.running");
                }
                DBManagement.SaveAcceptedTime((String)activityId, (boolean)true);
                if (lockedActivities.putIfAbsent(activityId, username) != null) {
                    throw new AlreadyAcceptedOrAcceptingByAnotherUser();
                }
            }
            catch (Exception ex) {
                if (ex instanceof AlreadyAcceptedOrAcceptingByAnotherUser) {
                    throw ex;
                }
                String activityState = currentActivity.state(transaction);
                if (activityState.equals("open.running")) {
                    log.warn("Wyst\u0105pi\u0142 b\u0142\u0105d przy zmianie statusu:" + ex.getMessage() + "-" + ex.getLocalizedMessage());
                }
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        if (currentAssignment.get_accepted_status(transaction)) {
            ExecutionAdministration executionAdministration = SharkUtils.createExecutionAdministration((String)username);
            WfResource userResource = executionAdministration.getResource(transaction, username);
            currentAssignment = SharkFunctions.GetWfAssignment((SharkTransaction)transaction, (ExecutionAdministration)executionAdministration, (String)processId, (String)activityId, (String)username);
            if (currentAssignment == null) {
                throw new AlreadyAccepted();
            }
            if (!userResource.is_member_of_work_items(transaction, currentAssignment)) {
                throw new AlreadyAcceptingByAnotherUser();
            }
        }
        AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
        String processDefId = adminMisc.getProcessDefinitionId(transaction, processId);
        String activityDefId = adminMisc.getActivityDefinitionId(transaction, processId, activityId);
        Package pack = XpdlPackageManager.getInstance().getPackageByProcessId(transaction, processId);
        String message = context.getMessage();
        ActivityStatus activityStatus = ActivityStatusManagerExtended.getActivityCurrentStatus((String)processId, (String)activityId);
        if (activityStatus != null) {
            message = MessageHelper.getOptionalMessage((String)"ponowna_akceptacja_warn_msg");
        }
        String realUsername = Shark.getInstance().getAdminInterface().getUserGroupAdministration().getUserRealName(username);
        Process process = ServiceFactory.getProcessService().getProcess(processId, new String[0]);
        return ProcessActivityResult.builder().processId(processId).activityId(activityId).processDefId(processDefId).activityDefId(activityDefId).packageId(pack.getId()).packageVersion(pack.getInternalVersion()).realUsername(realUsername).message(message).processName(process.getName()).build();
    }

    private ProcessActivityContext buildContext(HttpServletRequest request, HttpSession session) {
        Locale locale = LocaleContextHolder.getLocale();
        String username = (String)session.getAttribute("username");
        String activityId = request.getParameter("activityId");
        String processId = request.getParameter("processId");
        return ProcessActivityContext.builder().processId(processId).activityId(activityId).username(username).locale(locale).request(request).session(session).build();
    }

    private void setMessage(HttpServletRequest request, Locale locale, String username, String message) {
        String formattedMessage = String.format("%s: %s %s.", MessageHelper.getOptionalMessage((String)"Uzytkownik", (Locale)locale, (Object[])new Object[0]), username, MessageHelper.getOptionalMessage((String)message, (Locale)locale, (Object[])new Object[0]));
        request.setAttribute("message", (Object)formattedMessage);
    }

    private String getSystemParametersJson() {
        List parameters = systemParameterFinder.getPublicSystemParameters(new String[0]);
        List parametersDto = parameters.stream().map(SystemParameterDto::create).sorted().collect(Collectors.toList());
        return StringEscapeUtils.escapeJavaScript((String)mapper.writeValueAsString(parametersDto));
    }

    private String getActivityDelegationsJson(String activityId, String userName) {
        List delegatedActs = ServiceFactory.getActivityService().getActivityDelegations(activityId, userName);
        if (CollectionUtils.isNotEmpty((Collection)delegatedActs)) {
            List delegatedActsDto = delegatedActs.stream().map(delegatedActivityDtoConverter::convertToDto).sorted().collect(Collectors.toList());
            return StringEscapeUtils.escapeJavaScript((String)mapper.writeValueAsString(delegatedActsDto));
        }
        return "{}";
    }
}

