/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.google.common.cache.Cache;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.web.support.form.cache.SearchFormCachedItem;
import com.suncode.pwfl.web.support.form.cache.SearchResultActions;
import com.suncode.pwfl.web.util.SessionUtils;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class NewAdvanceProcessSearchAction
extends Action {
    private static final SearchFormCache searchFormCache = (SearchFormCache)SpringContext.getBean(SearchFormCache.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("activeTab", (Object)"SearchForm.do");
        Date auditStartDate = new Date();
        ManualAuditBuilder manualAuditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_SEARCH_PROCESSES_OR_ACTIVITIES).started(auditStartDate).username(SessionUtils.getLoggedUserNameOrUnknown());
        Cache<String, SearchFormCachedItem> cache = searchFormCache.getCache(request.getSession(false));
        ConcurrentMap sessionCache = cache.asMap();
        String searchId = request.getParameter("searchId");
        String redirectUrl = request.getRequestURL() + "?" + request.getQueryString();
        request.setAttribute("redirectUrl", (Object)redirectUrl);
        if (request.getMethod().equals("POST")) {
            String encodedSearchFormModel = request.getParameter("searchFormModel");
            boolean isSearchFormPresent = StringUtils.isNotBlank((String)encodedSearchFormModel);
            if (StringUtils.isBlank((String)searchId) || !sessionCache.containsKey(searchId) && !isSearchFormPresent) {
                request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Niepoprawne_kryteria_wyszukiwania"));
                this.logAuditFail(manualAuditBuilder);
                return mapping.findForward("showErrorMessage");
            }
            if (!sessionCache.containsKey(searchId)) {
                cache.put((Object)searchId, (Object)new SearchFormCachedItem(encodedSearchFormModel, Collections.emptyList(), new SearchResultActions(false, false, false)));
            }
            return new ActionForward("NewAdvanceProcessSearch.do?searchId=" + searchId, true);
        }
        if (StringUtils.isBlank((String)searchId) || !sessionCache.containsKey(searchId)) {
            request.setAttribute("message", (Object)MessageHelper.getMessage((String)"Niepoprawne_kryteria_wyszukiwania"));
            this.logAuditFail(manualAuditBuilder);
            return mapping.findForward("showErrorMessage");
        }
        request.setAttribute("searchId", (Object)searchId);
        request.setAttribute("encodedSearchFormModel", (Object)((SearchFormCachedItem)sessionCache.get(searchId)).encodedSearchForm());
        request.setAttribute("auditStartDate", (Object)this.getFormattedDate(auditStartDate));
        return mapping.findForward("showResult");
    }

    private void logAuditFail(ManualAuditBuilder manualAuditBuilder) {
        manualAuditBuilder.success(false).build().log();
    }

    private String getFormattedDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        dateFormat.setTimeZone(TimeZone.getDefault());
        return dateFormat.format(date);
    }
}

