/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.struts.action;

import com.plusmpm.database.DBManagement;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.struts.form.CreateProcessForm;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.CoreTools;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.XpdlPackageManager;
import com.plusmpm.util.locale.ProcessLocale;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.language.LanguageUtils;
import com.suncode.pwfl.transaction.ExtendedSharkTransaction;
import com.suncode.pwfl.transaction.InternalSharkTransactionManager;
import com.suncode.pwfl.transaction.support.SharkTransactionInternalUtils;
import com.suncode.pwfl.util.SharkUtils;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfActivityIterator;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfAssignmentIterator;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.xpdl.elements.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class CreateProcessAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(CreateProcessAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            log.info("**********CreateProcessAction1*****************");
            Date dt = new Date();
            CreateProcessForm createProc = (CreateProcessForm)form;
            HttpSession session = request.getSession(false);
            if (session == null || session.getAttribute("username") == null) {
                return mapping.findForward("welcome");
            }
            String sUserName = (String)session.getAttribute("username");
            String processId = request.getParameter("processId");
            String processDescr = createProc.getProcessDescr();
            int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().workflow().processes().create().custom((Object)processId).build(), (String)sUserName, (boolean)false, (boolean)false);
            if (rights == 0) {
                String procMaskName;
                log.info("processId description1: " + processDescr);
                if (processId != null) {
                    processId = processId.trim();
                }
                log.info("processId in request is: " + processId);
                if (processId == null) {
                    throw new Exception("Need a valid process Id");
                }
                String packageId = createProc.getProcessPackageId();
                if (packageId != null) {
                    packageId = packageId.trim();
                }
                log.info("package id in request is: " + packageId);
                if (packageId == null && (packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(processId)) == null) {
                    throw new Exception("Need a valid package Id");
                }
                log.info(sUserName);
                String engineName = session.getServletContext().getInitParameter("Shark_Survey_client_enginename");
                log.info("Engine name:" + engineName);
                ExtendedSharkTransaction sharkTransaction = null;
                WfProcess proc = null;
                InternalSharkTransactionManager mgr = SharkTransactionInternalUtils.getInternalSharkTransactionManager();
                TransactionStatus txStatus = mgr.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
                try {
                    sharkTransaction = mgr.getSharkTransaction();
                    proc = SharkUtils.createSharkConnection((String)sUserName).createProcess((SharkTransaction)sharkTransaction, packageId, processId);
                    Package pack = SharkFunctions.getPackageManager().getPackageByWfProcess((SharkTransaction)sharkTransaction, proc);
                    Tools.SetDefaultVariablesForCreateProcess((SharkTransaction)sharkTransaction, (String)sUserName, (WfProcess)proc, (String)processId, (Package)pack);
                    proc.start((SharkTransaction)sharkTransaction);
                    DBManagement dbManagament = new DBManagement();
                    dbManagament.SaveVariableValuesToDB((SharkTransaction)sharkTransaction, pack, proc, null);
                    procMaskName = proc.name((SharkTransaction)sharkTransaction);
                    ProcessLocale.createProcessLocaleWithSubFlow((SharkTransaction)sharkTransaction, (String)proc.key((SharkTransaction)sharkTransaction), (String)procMaskName, (String)processId);
                    mgr.commit(txStatus);
                }
                catch (Exception ex) {
                    try {
                        if (proc != null) {
                            this.rollbackPmIdxData((SharkTransaction)sharkTransaction, proc.key((SharkTransaction)sharkTransaction));
                        }
                    }
                    catch (Exception e) {
                        log.error("Cannot rollback pmIdxData: " + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        mgr.rollback(txStatus);
                    }
                    throw ex;
                }
                Date dt2 = new Date();
                log.info("processCreated in: " + (dt2.getTime() - dt.getTime()));
                Date dtStart = new Date();
                String sProcessId = "";
                String sActivityId = "";
                boolean bCanMakeTask = false;
                WfActivityIterator oActivityIteratorOpen = proc.get_activities_in_state("open.running");
                WfActivity oActivityOpen = null;
                log.info("Liczba otwartych zada\u0144 z tego procesu:" + oActivityIteratorOpen.how_many());
                int iCnt = oActivityIteratorOpen.how_many();
                for (int z = 0; z < iCnt; ++z) {
                    oActivityOpen = oActivityIteratorOpen.get_next_object();
                    WfAssignmentIterator oAssignmentIterator = oActivityOpen.get_iterator_assignment();
                    WfAssignment oAssignment = null;
                    int iAssCnt = oAssignmentIterator.how_many();
                    if (iAssCnt == 0) {
                        WfProcess[] aWfProcess = oActivityOpen.get_sequence_performer(0);
                        block10: for (int x = 0; x < aWfProcess.length; ++x) {
                            WfProcess wfSubProcess = aWfProcess[x];
                            WfActivityIterator oActivityIterator = wfSubProcess.get_activities_in_state("open.not_running.not_started");
                            WfActivity oActivity = null;
                            int iSubProcessTaskCnt = oActivityIterator.how_many();
                            log.info("Liczba zadan podprocesu ktore mozna uruchomic:" + oActivityIterator.how_many());
                            for (int y = 0; y < iSubProcessTaskCnt; ++y) {
                                oActivity = oActivityIterator.get_next_object();
                                WfAssignmentIterator oSubProcessAssignmentIterator = oActivity.get_iterator_assignment();
                                WfAssignment oSubProcessAssignment = null;
                                int iSubProcessAssCnt = oSubProcessAssignmentIterator.how_many();
                                for (int k = 0; k < iSubProcessAssCnt; ++k) {
                                    String sPerformer;
                                    oSubProcessAssignment = oSubProcessAssignmentIterator.get_next_object();
                                    if (oSubProcessAssignment.assignee() == null || (sPerformer = oSubProcessAssignment.assignee().resource_key()).compareTo(sUserName) != 0) continue;
                                    sProcessId = wfSubProcess.key();
                                    sActivityId = oActivity.key();
                                    bCanMakeTask = true;
                                    break;
                                }
                                if (bCanMakeTask) continue block10;
                            }
                        }
                    } else {
                        for (int x = 0; x < iAssCnt; ++x) {
                            String sPerformer;
                            oAssignment = oAssignmentIterator.get_next_object();
                            if (oAssignment.assignee() == null || (sPerformer = oAssignment.assignee().resource_key()).compareTo(sUserName) != 0) continue;
                            sProcessId = proc.key();
                            sActivityId = oActivityOpen.key();
                            bCanMakeTask = true;
                            break;
                        }
                    }
                    if (bCanMakeTask) break;
                }
                WfActivityIterator oActivityIterator = proc.get_activities_in_state("open.not_running.not_started");
                WfActivity oActivity = null;
                iCnt = oActivityIterator.how_many();
                log.info("Liczba zadan ktore mozna uruchomic:" + oActivityIterator.how_many());
                for (int z = 0; z < iCnt; ++z) {
                    oActivity = oActivityIterator.get_next_object();
                    WfAssignmentIterator oAssignmentIterator = oActivity.get_iterator_assignment();
                    WfAssignment oAssignment = null;
                    int iAssCnt = oAssignmentIterator.how_many();
                    for (int x = 0; x < iAssCnt; ++x) {
                        String sPerformer;
                        oAssignment = oAssignmentIterator.get_next_object();
                        if (oAssignment.assignee() == null || (sPerformer = oAssignment.assignee().resource_key()).compareTo(sUserName) != 0) continue;
                        sProcessId = proc.key();
                        sActivityId = oActivity.key();
                        bCanMakeTask = true;
                        break;
                    }
                    if (bCanMakeTask) break;
                }
                Date dtEnd = new Date();
                log.info("Check performer after create new proces in:" + (dtEnd.getTime() - dtStart.getTime()));
                HashMap<String, String> params = new HashMap<String, String>();
                String procesName = LanguageUtils.getProcessName((String)procMaskName, (String)processId);
                params.put("processId", processId);
                params.put("processPackageId", packageId);
                params.put("procesName", procesName);
                request.setAttribute("audit", (Object)AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_PROCESS).success(true).params(params).build());
                log.info(MessageHelper.getMessage((String)"createNewProcess") + " - processId: " + processId + ", procesName: " + procesName);
                if (bCanMakeTask) {
                    String taskPathWithParams = String.format("/ProcesActivity.do?activityId=%s&processKey=%s", sActivityId, sProcessId);
                    return new ActionForward(taskPathWithParams, true);
                }
                return new ActionForward("/ShowWorkListAction.do", true);
            }
            log.info(MessageHelper.getMessage((String)"Brak_uprawnien_aby_utworzyc_proces"));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ERROR_MESSAGE", MessageHelper.getMessage((String)"Brak_uprawnien_aby_utworzyc_proces"));
            request.setAttribute("audit", (Object)AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_PROCESS).success(false).params(params).build());
            return mapping.findForward("failure");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ERROR_MESSAGE", e.getLocalizedMessage());
            request.setAttribute("audit", (Object)AuditBuilder.getInstance().type(AuditTypes.AUDIT_CREATE_PROCESS).success(false).params(params).build());
            return mapping.findForward("failure");
        }
    }

    private void rollbackPmIdxData(SharkTransaction sharkTransaction, String processId) {
        String procDefId = SharkFunctions.getProcessDefId((SharkTransaction)sharkTransaction, (String)processId);
        if (procDefId != null) {
            String pmIdxTable = CoreTools.GetProcessTypesTable((String)procDefId);
            CoreTools.rollbackPmIdxData((String)processId, (String)pmIdxTable);
        }
    }
}

