/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.filter;

import com.google.common.collect.ImmutableMap;
import com.plusmpm.util.SessionManager;
import com.suncode.pwfl.administration.user.Domain;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.web.security.UserAuthorization;
import com.suncode.pwfl.web.security.exception.BlockedUserException;
import com.suncode.pwfl.web.security.exception.CaptchaRequiredException;
import com.suncode.pwfl.web.security.exception.UserAuthorizationException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UrlPathHelper;

public class BasicAuthFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthFilter.class);
    private final UserAuthorization userAuthorization = (UserAuthorization)SpringContext.getBean(UserAuthorization.class);
    private final DomainService domainService = (DomainService)SpringContext.getBean(DomainService.class);
    private UrlPathHelper pathHelper = new UrlPathHelper();
    private final String HEADER_PREFIX = "Basic";
    private final List<String> excludes = Arrays.asList("/api/authentication/login", "/api/authentication/logout", "/api/authentication/domains", "/api/authentication/sso/login", "/api/init/database/embedded", "/api/init/database/standalone", "/api/translation/bundle/cached/plusworkflow", "/api/password/expired", "/api/captcha", "/api/password/policy/profile", "/api/password/available", "/api/password/change", "/api/password/recovery", "/api/users/unblock", "/api/password/ldap/change", "/api/mobile/version", "/api/authentication/login/redirect", "/api/password/self/assign", "/api/system/version");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String authorization = httpRequest.getHeader("Authorization");
        if (authorization == null || !authorization.toLowerCase().startsWith("Basic".toLowerCase())) {
            chain.doFilter(request, response);
            return;
        }
        String requestUrl = this.pathHelper.getPathWithinApplication(httpRequest);
        if (this.isExcluded(requestUrl)) {
            log.info("URL is excluded");
            chain.doFilter(request, response);
            return;
        }
        String base64Credentials = authorization.substring("Basic".length()).trim();
        byte[] credDecoded = Base64.getDecoder().decode(base64Credentials);
        String credentials = new String(credDecoded, StandardCharsets.UTF_8);
        String[] values = credentials.split(":", 2);
        String username = values[0];
        String password = values[1];
        Long domainId = null;
        String[] domainUser = username.split("/");
        if (domainUser.length == 2) {
            String domainName = domainUser[0];
            Domain domain = this.domainService.getByName(domainName, new String[0]);
            if (domain == null) {
                this.sendHttpResponse(httpResponse, 400, String.format("Domain %s does not exist", domainName));
                return;
            }
            domainId = domain.getId();
            username = domainUser[1];
        }
        if (SessionManager.isLoggedIn((String)username)) {
            this.sendHttpResponse(httpResponse, 409, "User is already logged in");
            return;
        }
        boolean success = false;
        try {
            this.userAuthorization.authorizeUserWithMetaResult(username, password, domainId, httpRequest, true, false);
            success = true;
        }
        catch (UserAuthorizationException e) {
            this.sendHttpResponse(httpResponse, 401, e.getMessage());
            return;
        }
        catch (BlockedUserException | CaptchaRequiredException e) {
            this.sendHttpResponse(httpResponse, 403, e.getMessage());
            return;
        }
        catch (Exception e) {
            this.sendHttpResponse(httpResponse, 500, e.getMessage());
            return;
        }
        finally {
            ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_BASIC_AUTH).username(username).params((Map)ImmutableMap.of((Object)"domainUser", (Object)username, (Object)"url_address", (Object)requestUrl)).success(success).build().log();
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            HttpSession session = ((HttpServletRequest)request).getSession();
            session.invalidate();
        }
    }

    private boolean isExcluded(String path) {
        return this.excludes.stream().anyMatch(path::equals);
    }

    private void sendHttpResponse(HttpServletResponse httpResponse, int statusCode, String responseMessage) throws IOException {
        httpResponse.setStatus(statusCode);
        PrintWriter writer = httpResponse.getWriter();
        writer.print(responseMessage);
        writer.flush();
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }
}

