/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration.systemMessages;

import com.suncode.pwfl.administration.systemMessage.SystemMessage;
import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class AddSystemMessageDto {
    private String message;
    private Date startDate;
    private Date finishDate;
    private String groupId;
    private boolean enabled;
    private boolean afterLogin;

    public SystemMessage toEntity() {
        return SystemMessage.builder().message(this.message).startDate(this.startDate != null ? this.startDate : new Date()).finishDate(this.finishDate).groupId(this.groupId).enabled(this.enabled).afterLogin(this.afterLogin).build();
    }

    public Map<String, Object> getAuditParams() {
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("SYSTEM_MESSAGE", Objects.toString(this.message, ""));
        params.put("SYSTEM_MESSAGE_START_DATE", this.startDate != null ? dateTimeFormatter.format(this.startDate) : "");
        params.put("SYSTEM_MESSAGE_FINISH_DATE", this.finishDate != null ? dateTimeFormatter.format(this.finishDate) : "");
        params.put("SYSTEM_MESSAGE_GROUP", Objects.toString(this.groupId, ""));
        params.put("SYSTEM_MESSAGE_ENABLED", this.enabled);
        params.put("SYSTEM_MESSAGE_AFTER_LOGIN", this.afterLogin);
        return params;
    }

    public static AddSystemMessageDtoBuilder builder() {
        return new AddSystemMessageDtoBuilder();
    }

    public String getMessage() {
        return this.message;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getFinishDate() {
        return this.finishDate;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAfterLogin() {
        return this.afterLogin;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAfterLogin(boolean afterLogin) {
        this.afterLogin = afterLogin;
    }

    public AddSystemMessageDto() {
    }

    @ConstructorProperties(value={"message", "startDate", "finishDate", "groupId", "enabled", "afterLogin"})
    public AddSystemMessageDto(String message, Date startDate, Date finishDate, String groupId, boolean enabled, boolean afterLogin) {
        this.message = message;
        this.startDate = startDate;
        this.finishDate = finishDate;
        this.groupId = groupId;
        this.enabled = enabled;
        this.afterLogin = afterLogin;
    }

    public static class AddSystemMessageDtoBuilder {
        private String message;
        private Date startDate;
        private Date finishDate;
        private String groupId;
        private boolean enabled;
        private boolean afterLogin;

        AddSystemMessageDtoBuilder() {
        }

        public AddSystemMessageDtoBuilder message(String message) {
            this.message = message;
            return this;
        }

        public AddSystemMessageDtoBuilder startDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public AddSystemMessageDtoBuilder finishDate(Date finishDate) {
            this.finishDate = finishDate;
            return this;
        }

        public AddSystemMessageDtoBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public AddSystemMessageDtoBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public AddSystemMessageDtoBuilder afterLogin(boolean afterLogin) {
            this.afterLogin = afterLogin;
            return this;
        }

        public AddSystemMessageDto build() {
            return new AddSystemMessageDto(this.message, this.startDate, this.finishDate, this.groupId, this.enabled, this.afterLogin);
        }

        public String toString() {
            return "AddSystemMessageDto.AddSystemMessageDtoBuilder(message=" + this.message + ", startDate=" + this.startDate + ", finishDate=" + this.finishDate + ", groupId=" + this.groupId + ", enabled=" + this.enabled + ", afterLogin=" + this.afterLogin + ")";
        }
    }
}

