/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.dto.administration.structure.position;

import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.dto.administration.RoleDto;
import com.suncode.pwfl.web.dto.administration.structure.organizationalUnit.OrganizationalUnitDto;
import com.suncode.pwfl.web.dto.administration.structure.position.PositionDto;
import com.suncode.pwfl.web.dto.administration.user.UserDto;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class StructurePositionDto {
    Long id;
    String positionName;
    String translatedPositionName;
    String positionSymbol;
    PositionDto higherPosition;
    OrganizationalUnitDto organizationalUnit;
    Set<RoleDto> roles;
    UserDto user;

    public static StructurePositionDto from(Position position) {
        StructureService structureService = ServiceFactory.getStructureService();
        return StructurePositionDto.builder().id(position.getId()).positionName(position.getName()).translatedPositionName(structureService.getPositionTranslation(position.getId(), TranslatedFieldType.NAME)).positionSymbol(position.getSymbol()).higherPosition(!Objects.isNull(position.getHigherPosition()) ? PositionDto.fromDomain(position.getHigherPosition()) : null).organizationalUnit(!Objects.isNull(position.getOrganizationalUnit()) ? OrganizationalUnitDto.from(position.getOrganizationalUnit()) : null).roles(!Objects.isNull(position.getRoles()) ? position.getRoles().stream().map(RoleDto::translatedFromDomain).collect(Collectors.toSet()) : null).user(!Objects.isNull(position.getUser()) ? UserDto.from(position.getUser()) : null).build();
    }

    @ConstructorProperties(value={"id", "positionName", "translatedPositionName", "positionSymbol", "higherPosition", "organizationalUnit", "roles", "user"})
    StructurePositionDto(Long id, String positionName, String translatedPositionName, String positionSymbol, PositionDto higherPosition, OrganizationalUnitDto organizationalUnit, Set<RoleDto> roles, UserDto user) {
        this.id = id;
        this.positionName = positionName;
        this.translatedPositionName = translatedPositionName;
        this.positionSymbol = positionSymbol;
        this.higherPosition = higherPosition;
        this.organizationalUnit = organizationalUnit;
        this.roles = roles;
        this.user = user;
    }

    public static StructurePositionDtoBuilder builder() {
        return new StructurePositionDtoBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getPositionName() {
        return this.positionName;
    }

    public String getTranslatedPositionName() {
        return this.translatedPositionName;
    }

    public String getPositionSymbol() {
        return this.positionSymbol;
    }

    public PositionDto getHigherPosition() {
        return this.higherPosition;
    }

    public OrganizationalUnitDto getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public Set<RoleDto> getRoles() {
        return this.roles;
    }

    public UserDto getUser() {
        return this.user;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPositionName(String positionName) {
        this.positionName = positionName;
    }

    public void setTranslatedPositionName(String translatedPositionName) {
        this.translatedPositionName = translatedPositionName;
    }

    public void setPositionSymbol(String positionSymbol) {
        this.positionSymbol = positionSymbol;
    }

    public void setHigherPosition(PositionDto higherPosition) {
        this.higherPosition = higherPosition;
    }

    public void setOrganizationalUnit(OrganizationalUnitDto organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public void setRoles(Set<RoleDto> roles) {
        this.roles = roles;
    }

    public void setUser(UserDto user) {
        this.user = user;
    }

    public static class StructurePositionDtoBuilder {
        private Long id;
        private String positionName;
        private String translatedPositionName;
        private String positionSymbol;
        private PositionDto higherPosition;
        private OrganizationalUnitDto organizationalUnit;
        private Set<RoleDto> roles;
        private UserDto user;

        StructurePositionDtoBuilder() {
        }

        public StructurePositionDtoBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public StructurePositionDtoBuilder positionName(String positionName) {
            this.positionName = positionName;
            return this;
        }

        public StructurePositionDtoBuilder translatedPositionName(String translatedPositionName) {
            this.translatedPositionName = translatedPositionName;
            return this;
        }

        public StructurePositionDtoBuilder positionSymbol(String positionSymbol) {
            this.positionSymbol = positionSymbol;
            return this;
        }

        public StructurePositionDtoBuilder higherPosition(PositionDto higherPosition) {
            this.higherPosition = higherPosition;
            return this;
        }

        public StructurePositionDtoBuilder organizationalUnit(OrganizationalUnitDto organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        public StructurePositionDtoBuilder roles(Set<RoleDto> roles) {
            this.roles = roles;
            return this;
        }

        public StructurePositionDtoBuilder user(UserDto user) {
            this.user = user;
            return this;
        }

        public StructurePositionDto build() {
            return new StructurePositionDto(this.id, this.positionName, this.translatedPositionName, this.positionSymbol, this.higherPosition, this.organizationalUnit, this.roles, this.user);
        }

        public String toString() {
            return "StructurePositionDto.StructurePositionDtoBuilder(id=" + this.id + ", positionName=" + this.positionName + ", translatedPositionName=" + this.translatedPositionName + ", positionSymbol=" + this.positionSymbol + ", higherPosition=" + this.higherPosition + ", organizationalUnit=" + this.organizationalUnit + ", roles=" + this.roles + ", user=" + this.user + ")";
        }
    }
}

