/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.xpdl;

import com.plusmpm.util.XpdlPackageManager;
import com.plusmpm.util.workflowData.XpdlTools;
import com.suncode.pwfl.form.util.PackageUtils;
import com.suncode.pwfl.web.dto.xpdl.TypeIncompatibilityDto;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.xpdl.elements.DataField;
import org.enhydra.shark.xpdl.elements.DataFields;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.enhydra.shark.xpdl.elements.WorkflowProcesses;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"xpdlInfo"})
public class PackageInfoController {
    private static final Logger log = LoggerFactory.getLogger(PackageInfoController.class);
    @Autowired
    private SessionFactory sessionFactory;

    @RequestMapping(value={"checkLoaded"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getCheckXpdl(@RequestParam String xpdlFilename) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            String packageId = Shark.getInstance().getRepositoryManager().getPackageId(xpdlFilename);
            if (packageId != null) {
                Package packageObj = XpdlPackageManager.getInstance().getPackage(packageId);
                if (packageObj != null) {
                    response.put("success", true);
                    response.put("loaded", true);
                    response.put("packageId", packageObj.getId());
                } else {
                    response.put("success", true);
                    response.put("loaded", false);
                }
            } else {
                response.put("success", false);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            response.put("success", false);
        }
        return response;
    }

    @RequestMapping(value={"databaseChanges/id"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TypeIncompatibilityDto> getDatabaseChangesById(@RequestParam(value="packageId") String packageId) throws Exception {
        String xpdlFilename = XpdlPackageManager.getInstance().getFileNameByPackageId(packageId);
        return this.getDatabaseChangesByFilename(xpdlFilename);
    }

    @RequestMapping(value={"databaseChanges/filename"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TypeIncompatibilityDto> getDatabaseChangesByFilename(@RequestParam(value="xpdlFilename") String xpdlFilename) throws Exception {
        String absolutePath = XpdlPackageManager.XPDL_REPOSITORY_ABSOLUTE_PATH + File.separator + xpdlFilename;
        String xpdl = FileUtils.readFileToString((File)new File(absolutePath), (Charset)StandardCharsets.UTF_8);
        return this.getDatabaseChangesByXpdl(xpdl);
    }

    @RequestMapping(value={"databaseChanges/xpdl"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TypeIncompatibilityDto> getDatabaseChangesByXpdl(@RequestParam(value="xpdl") String xpdl) {
        Package packageObj = PackageUtils.buildPackage((String)xpdl);
        return this.getDatabaseChanges(packageObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TypeIncompatibilityDto> getDatabaseChanges(Package packageObj) {
        Session session = this.sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        try {
            LinkedList<TypeIncompatibilityDto> incompatiblesList = new LinkedList<TypeIncompatibilityDto>();
            WorkflowProcesses processes = packageObj.getWorkflowProcesses();
            for (int i = 0; i < processes.size(); ++i) {
                WorkflowProcess process = (WorkflowProcess)processes.get(i);
                String processId = process.getId();
                String processTableName = XpdlTools.getTableName((String)processId);
                if (!XpdlTools.checkTableExists((String)processTableName, (Session)session) || XpdlTools.isTableEmpty((String)processTableName, (Session)session)) continue;
                DataFields dataFields = process.getDataFields();
                for (int j = 0; j < dataFields.size(); ++j) {
                    DataField dataField = (DataField)dataFields.get(j);
                    Optional<TypeIncompatibilityDto> incompatibilityDto = this.findTypeIncompatibility(processId, dataField, session);
                    if (!incompatibilityDto.isPresent()) continue;
                    incompatiblesList.add(incompatibilityDto.get());
                }
            }
            transaction.rollback();
            LinkedList<TypeIncompatibilityDto> linkedList = incompatiblesList;
            return linkedList;
        }
        finally {
            if (session.isOpen()) {
                session.close();
            }
        }
    }

    private Optional<TypeIncompatibilityDto> findTypeIncompatibility(String processDefId, DataField dataField, Session session) {
        String variableId = dataField.getId();
        if (XpdlTools.checkColumnExists((String)XpdlTools.getTableName((String)processDefId), (String)variableId, (Session)session)) {
            String variableClassName = dataField.getDataType().getJavaType();
            String currentColumnClassName = XpdlTools.getColumnClassName((String)XpdlTools.getTableName((String)processDefId), (String)variableId, (Session)session);
            if (!XpdlTools.isPmidxClassCompatibleWithClass((String)currentColumnClassName, (String)variableClassName)) {
                return Optional.of(TypeIncompatibilityDto.builder().processDefId(processDefId).variableId(variableId).build());
            }
        }
        return Optional.empty();
    }
}

