/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.view;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.plusmpm.database.AdvanceSearchVariableDto;
import com.plusmpm.database.AdvanceSearchVariableTable;
import com.plusmpm.database.UserSearchViewProtectionTable;
import com.plusmpm.database.variableDistinguish.VariableDistinguishTable;
import com.plusmpm.struts.form.AdvanceVariableForm;
import com.plusmpm.util.operationPanel.OperationPanelView;
import com.suncode.plugin.dashboard.web.support.DynamicListResult;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.experimental.Experimental;
import com.suncode.pwfl.experimental.ExperimentalFeature;
import com.suncode.pwfl.export.extension.ExportExtension;
import com.suncode.pwfl.export.model.ExportColumn;
import com.suncode.pwfl.export.model.ExportColumnBuilder;
import com.suncode.pwfl.export.model.ExportModel;
import com.suncode.pwfl.export.service.ExportService;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.operationPanel.OperationPanelParameterTableWrapper;
import com.suncode.pwfl.operationPanel.OperationPanelService;
import com.suncode.pwfl.operationPanel.OperationPanelTableWrapper;
import com.suncode.pwfl.operationPanel.UserViewDataDto;
import com.suncode.pwfl.search.AdvanceProcessSearchDBHelper;
import com.suncode.pwfl.search.AdvanceProcessSearchVariablesTypesProvider;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.ViewVariablesToSearchModelMapper;
import com.suncode.pwfl.search.dynamic.DynamicViewService;
import com.suncode.pwfl.search.dynamic.ProcessSearchView;
import com.suncode.pwfl.search.dynamic.ProcessSearchViewService;
import com.suncode.pwfl.search.dynamic.ProcessSearchViewType;
import com.suncode.pwfl.search.dynamic.dto.DynamicViewDto;
import com.suncode.pwfl.util.DtoComparator;
import com.suncode.pwfl.util.Paginator;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.view.ViewFetchType;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.view.dto.ViewDto;
import com.suncode.pwfl.view.exception.OperationPanelNotFoundException;
import com.suncode.pwfl.view.exception.OperationPanelParameterNotFoundException;
import com.suncode.pwfl.view.exception.SearchProtectionViewDoesNotExist;
import com.suncode.pwfl.view.exception.UserSearchViewTableNotFoundException;
import com.suncode.pwfl.view.exception.UserSearchViewTableProtectionAlreadyExistsException;
import com.suncode.pwfl.view.exception.VariableDistinguishNotFoundException;
import com.suncode.pwfl.view.exception.ViewDoesNotExistException;
import com.suncode.pwfl.view.service.advancedSearchVariables.AdvanceSearchVariableService;
import com.suncode.pwfl.view.service.variableDistinguish.VariableDistinguishService;
import com.suncode.pwfl.view.service.viewProtection.ViewProtectionService;
import com.suncode.pwfl.view.service.viewRights.ViewRightsService;
import com.suncode.pwfl.web.dto.workflow.view.GadgetViewDto;
import com.suncode.pwfl.web.dto.workflow.view.ViewProtectionDto;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.AdvanceSearchVariableMapper;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.distinction.DistinctionUtil;
import com.suncode.pwfl.web.support.distinction.dto.ConditionDto;
import com.suncode.pwfl.web.support.form.cache.SearchFormCache;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.ProcessType;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"view"})
public class ViewController {
    private static final Logger log = LoggerFactory.getLogger(ViewController.class);
    private final Map<UUID, List<ViewDto>> exportCache = new HashMap<UUID, List<ViewDto>>();
    private final ViewService viewService;
    private final ExportService exportService;
    private final OperationPanelService operationPanelService;
    private final VariableDistinguishService variableDistinguishService;
    private final ViewProtectionService viewProtectionService;
    private final AdvanceSearchVariableService advanceSearchVariableService;
    private final AdvanceSearchVariableMapper advanceSearchVariableMapper;
    private final SearchFormCache searchFormCache;
    private final AdvanceProcessSearchDBHelper advanceProcessSearchDBHelper;
    private final ViewVariablesToSearchModelMapper viewVariablesToSearchModelMapper;
    private final MessageHelperBean messageHelper;
    private final ViewRightsService viewRightsService;
    private final Experimental experimental;
    private final DynamicViewService dynamicViewService;
    private final ProcessSearchViewService processSearchViewService;
    private final ProcessService processService;
    private final UserService userService;
    private final AdvanceProcessSearchVariablesTypesProvider advanceProcessSearchVariablesTypesProvider;
    private final AuthorizationHelper authorizationHelper;

    @ResponseBody
    @RequestMapping(value={"shouldseeallviews"})
    public Boolean getShouldSeeAllViews() {
        return this.viewService.shouldSeeAllViews();
    }

    @ResponseBody
    @RequestMapping(value={"cansavegroupacceptation"})
    public Boolean getCanSaveGroupAcceptation(@RequestParam String processDefinitionId) {
        return this.authorizationHelper.hasSearchProcessAccess(processDefinitionId);
    }

    @ResponseBody
    @RequestMapping(value={"{viewId}"})
    public ViewDto getView(@PathVariable String viewId) throws ViewDoesNotExistException {
        if (!this.viewRightsService.hasRightsToView(Long.valueOf(viewId))) {
            throw new NotFullRightsException();
        }
        return this.viewService.getUserSearchView(viewId);
    }

    @ResponseBody
    @RequestMapping(value={"private"})
    public List<ViewDto> getPrivateViews() {
        return this.viewService.getViews(ViewFetchType.PRIVATE);
    }

    @ResponseBody
    @RequestMapping(value={"public"})
    public List<ViewDto> getPublicViews() {
        return this.viewService.getViews(ViewFetchType.PUBLIC);
    }

    @ResponseBody
    @RequestMapping(value={"all"})
    public List<ViewDto> getAllViews() {
        this.authorizationHelper.assertFullSystemRights(() -> {});
        return this.viewService.getViews(ViewFetchType.ALL);
    }

    @ResponseBody
    @RequestMapping(value={"foruser"})
    public List<ViewDto> getViewsForUser() {
        return this.viewService.getViewsForUser(UserContext.current().getUser().getUserName());
    }

    @ResponseBody
    @RequestMapping(value={"myViews"})
    public List<ViewDto> getUserViews() {
        String loggedUserName = UserContext.current().getUser().getUserName();
        if (this.experimental.hasFeature(ExperimentalFeature.VIEW_EDIT_PERMISSION)) {
            return this.getEditableViews(loggedUserName);
        }
        return this.viewService.getMyViewsForUser(loggedUserName);
    }

    @RequestMapping(value={"myViews/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteUserView(HttpServletRequest request, @PathVariable Long id) throws UserSearchViewTableNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_VIEW).params((Map)new ImmutableMap.Builder().put((Object)"viewId", (Object)id).build());
        try {
            this.viewService.deleteView(id);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"myViews/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResult changeUserView(HttpServletRequest request, @PathVariable Long id, @RequestBody ViewDto viewDto) throws UserSearchViewTableNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_VIEW);
        ViewDto view = this.viewService.getView(id);
        if (view == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new UserSearchViewTableNotFoundException(this.messageHelper.getMessage("Widok_nie_istnieje"));
        }
        HashMap<String, Object> auditParameters = new HashMap<String, Object>();
        auditParameters.put("viewId", id);
        auditParameters.put("viewName", view.getName() + ";" + viewDto.getName());
        auditParameters.put("viewDescription", view.getDescription() + ";" + viewDto.getDescription());
        auditBuilder.params(auditParameters);
        try {
            this.viewService.changeView(id, viewDto);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"myViews/{id}/protections"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<ViewProtectionDto> getUserSearchViewProtections(@PathVariable Long id, @RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="isGroup") String sortBy, @RequestParam(required=false, defaultValue="DESC") SortDirection sortDirection) {
        List viewProtectionForView = this.viewProtectionService.getViewProtections(id).stream().map(ViewProtectionDto::fromEntity).sorted((Comparator<ViewProtectionDto>)DtoComparator.of(ViewProtectionDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(viewProtectionForView).viewPageByOffset(start, limit);
    }

    @RequestMapping(value={"myViews/{id}/protections/canEdit"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean getUserSearchViewProtection(@PathVariable Long id) {
        return this.getEditableViews(UserContext.current().getUser().getUserName()).stream().anyMatch(view -> view.getId().equals(id));
    }

    @RequestMapping(value={"myViews/panel/parameters"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<OperationPanelParameterTableWrapper> getPanelParameters(@RequestParam Integer start, @RequestParam Integer limit, @RequestParam(required=false, defaultValue="id") String orderBy, @RequestParam(required=false, defaultValue="ASC") SortDirection orderDirection) {
        OperationPanelTableWrapper operationPanel = this.operationPanelService.getOperationPanelForUser(UserContext.current().getUser().getUserName());
        LinkedList parameters = operationPanel != null ? this.operationPanelService.getOperationPanelParameters(operationPanel.getId()) : new LinkedList();
        List parametersDto = parameters.stream().sorted(DtoComparator.of(OperationPanelParameterTableWrapper.class, (String)orderBy, (SortDirection)orderDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(parametersDto).viewPageByOffset(start, limit);
    }

    @RequestMapping(value={"myViews/panel"}, method={RequestMethod.GET})
    @ResponseBody
    public OperationPanelTableWrapper getUserPanel() throws OperationPanelParameterNotFoundException {
        OperationPanelTableWrapper operationPanel = this.operationPanelService.getOperationPanelForUser(UserContext.current().getUser().getUserName());
        if (operationPanel == null) {
            operationPanel = this.createOperationPanel();
        }
        return operationPanel;
    }

    @RequestMapping(value={"myViews/panel/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResult updateUserPanel(HttpServletRequest request, @PathVariable Long id, @RequestBody OperationPanelTableWrapper panelTableWrapper) throws OperationPanelParameterNotFoundException {
        OperationPanelTableWrapper operationPanel = this.operationPanelService.getOperationPanelForUser(UserContext.current().getUser().getUserName());
        if (operationPanel == null) {
            operationPanel = this.createOperationPanel();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("panelId", operationPanel.getId());
        params.put("panelName", operationPanel.getName() + ";" + panelTableWrapper.getName());
        params.put("panelDescription", operationPanel.getDescription() + ";" + panelTableWrapper.getDescription());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_PANEL).params(params);
        try {
            this.operationPanelService.updateOperationPanel(id, panelTableWrapper);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    private OperationPanelTableWrapper createOperationPanel() {
        long id = this.operationPanelService.createOperationPanel(UserContext.current().getUser().getUserName());
        return this.operationPanelService.getOperationPanel(Long.valueOf(id));
    }

    @RequestMapping(value={"myViews/panel/elements"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UserViewDataDto> getPanelElements() {
        return this.operationPanelService.getUserViewData();
    }

    @RequestMapping(value={"myViews/panel/parameter/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deletePanelParameter(HttpServletRequest request, @PathVariable Long id) throws OperationPanelParameterNotFoundException {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_PANEL_PARAMETER);
        HashMap<String, Object> auditParameters = new HashMap<String, Object>();
        auditParameters.put("panelParameterId", id);
        auditBuilder.params(auditParameters);
        OperationPanelParameterTableWrapper parameter = this.operationPanelService.getOperationPanelParameter(id);
        if (parameter == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new OperationPanelParameterNotFoundException(this.messageHelper.getMessage("Parametr_nie_istnieje"));
        }
        auditParameters.put("parameterName", parameter.getName());
        auditBuilder.params(auditParameters);
        try {
            this.operationPanelService.deleteParam(id);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"myViews/panel/parameter/{id}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResult changePanelParameter(HttpServletRequest request, @PathVariable Long id, @RequestBody OperationPanelParameterTableWrapper parameter) throws OperationPanelParameterNotFoundException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("panelParameterId", StringUtils.defaultString((String)String.valueOf(id)));
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_PANEL_PARAMETER).params(params);
        OperationPanelParameterTableWrapper oldParameter = this.operationPanelService.getOperationPanelParameter(id);
        params.put("parameterName", oldParameter.getName() + ";" + parameter.getName());
        params.put("parameterType", OperationPanelView.GetElementTypeViewById((String)oldParameter.getType()) + ";" + OperationPanelView.GetElementTypeViewById((String)parameter.getType()));
        params.put("parameterParam", oldParameter.getParams() + ";" + parameter.getParams());
        params.put("parameterIsCount", oldParameter.getIsCount() + ";" + parameter.getIsCount());
        auditBuilder.params(params);
        try {
            this.operationPanelService.changePanelParameter(id, parameter);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"myViews/panel/parameter"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult addPanelParameter(HttpServletRequest request, @RequestBody OperationPanelParameterTableWrapper parameter) throws OperationPanelParameterNotFoundException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("parameterName", parameter.getName());
        params.put("parameterType", OperationPanelView.GetElementTypeViewById((String)parameter.getType()));
        params.put("parameterParam", parameter.getTranslatedParams());
        params.put("parameterIsCount", parameter.getIsCount());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_PANEL_PARAMETER).params(params);
        try {
            long id = this.operationPanelService.addParameter(parameter);
            params.put("panelParameterId", id);
            auditBuilder.params(params);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"myViews/{id}/protections/{protectionId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteUserSearchViewProtection(HttpServletRequest request, @PathVariable Long id, @PathVariable Long protectionId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_VIEW_PROTECTION).params((Map)ImmutableMap.of((Object)"protectionId", (Object)protectionId, (Object)"viewId", (Object)id));
        try {
            this.viewProtectionService.deleteSearchViewProtection(protectionId);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"myViews/{id}/protections/{protectionId}"}, method={RequestMethod.PATCH})
    @ResponseBody
    public RestResult editUserSearchViewProtection(HttpServletRequest request, @PathVariable Long id, @PathVariable Long protectionId, @RequestBody ViewProtectionDto protectionDto) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_EDIT_VIEW_PROTECTION);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("protectionId", protectionId);
        auditParams.put("viewId", id);
        auditParams.put("permissionLevel", protectionDto.getPermissionLevel());
        try {
            UserSearchViewProtectionTable oldViewProtection = this.viewProtectionService.getViewProtection(protectionId);
            auditParams.put("oldPermissionLevel", oldViewProtection.getPermissionLevel());
            auditBuilder.params(auditParams);
            this.viewProtectionService.editSearchViewProtection(protectionDto.toEntity());
        }
        catch (Exception e) {
            auditBuilder.params(auditParams);
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"myViews/{id}/protections"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult addUserSearchViewProtection(HttpServletRequest request, @PathVariable Long id, @RequestBody ViewProtectionDto viewProtectionDto) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("viewId", id);
        params.put("protectionName", viewProtectionDto.getShareUserId());
        params.put("protectionIsGroup", viewProtectionDto.getIsGroup());
        params.put("permissionLevel", viewProtectionDto.getPermissionLevel());
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_VIEW_PROTECTION).params(params);
        try {
            Long protectionId = this.viewProtectionService.addViewProtection(viewProtectionDto.toEntity());
            params.put("protectionId", protectionId);
            auditBuilder.params(params);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"myViews/{id}/protections/export/{extension}"}, method={RequestMethod.GET})
    @ResponseBody
    public void exportUserSearchViewProtectionForView(@PathVariable Long id, HttpServletResponse response, @RequestParam(required=false, defaultValue="shareUserId") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @PathVariable String extension) throws IOException {
        List protections = this.viewProtectionService.getViewProtections(id).stream().sorted(DtoComparator.of(UserSearchViewProtectionTable.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Grupa")).data(protections).by(userSearchViewProtectionTable -> this.messageHelper.getMessage(userSearchViewProtectionTable.getIsGroup())).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Uzytkownik_grupa")).data(protections).by(UserSearchViewProtectionTable::getShareUserId).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Udostepnienia_widoku")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"myViews/{id}/variables"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<VariableDistinguishTable> getUserSearchViewVariables(@PathVariable Long id, @RequestParam(defaultValue="variableName") String sortBy, @RequestParam(defaultValue="ASC") SortDirection sortDirection, @RequestParam Integer start, @RequestParam Integer limit) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        List<VariableDistinguishTable> variables = this.variableDistinguishService.getVariableDistinguishTablesForView(id).stream().sorted(DtoComparator.of(VariableDistinguishTable.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        variables.forEach(distinction -> {
            try {
                distinction.setConditionDtoList((List)mapper.readValue(distinction.getVariableValue(), (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, ConditionDto.class)));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        DistinctionUtil.formatConditionsToDisplay(variables);
        return Paginator.forAll(variables).viewPageByOffset(start, limit);
    }

    @RequestMapping(value={"myViews/{id}/export/variables/{extension}"})
    public void exportVariableDistinguishTable(HttpServletResponse response, @PathVariable Long id, @RequestParam(required=false, defaultValue="variableName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @PathVariable String extension) throws IOException {
        List variableDistinguishTablesForView = this.variableDistinguishService.getVariableDistinguishTablesForView(id).stream().sorted(DtoComparator.of(VariableDistinguishTable.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        DistinctionUtil.formatConditionsToDisplay(variableDistinguishTablesForView);
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_zmiennej")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getVariableName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Wartosc")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getVariableValue).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Ikonka")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getImagePath).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Sposob_wyswietlania")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getViewVariableViewType).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Format_wyswietlania")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getViewVariableFormat).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Kolor")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getColor).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Kolor_tla")).data(variableDistinguishTablesForView).by(VariableDistinguishTable::getBackgroundColor).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Wyroznione_zmienne")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"myViews/{id}/variables/{variableId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteVariableDistinguishTable(HttpServletRequest request, @PathVariable Long id, @PathVariable Long variableId) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_DELETE_VARIABLE_DISTINGUISH);
        HashMap<String, Object> auditParameters = new HashMap<String, Object>();
        auditParameters.put("variableDistinguishId", variableId);
        auditParameters.put("viewId", id);
        auditBuilder.params(auditParameters);
        VariableDistinguishTable variable = this.variableDistinguishService.getVariableDistinguish(variableId);
        if (variable == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new ServiceException(this.messageHelper.getMessage("Wyroznienie_zmiennej_nie_istnieje"));
        }
        auditParameters.put("variableName", variable.getVariableName());
        auditBuilder.params(auditParameters);
        try {
            this.variableDistinguishService.deleteVariableDistinguish(variableId);
        }
        catch (Exception e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw e;
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new RestResult(true);
    }

    @RequestMapping(value={"myViews/{id}/advanced/variables"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<AdvanceSearchVariableDto> getAdvanceSearchVariablesForView(@PathVariable Long id, @RequestParam(defaultValue="name") String orderBy, @RequestParam(defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        if (!this.viewRightsService.hasRightsToView(id)) {
            throw new NotFullRightsException();
        }
        String processDefinitionId = this.advanceSearchVariableService.getProcessDefinitionIdForView(id);
        List advanceSearchVariables = this.advanceSearchVariableService.getAdvanceSearchVariablesForView(id).stream().map(variable -> this.advanceSearchVariableMapper.fromEntity((AdvanceSearchVariableTable)variable, processDefinitionId)).sorted((Comparator<AdvanceSearchVariableDto>)DtoComparator.of(AdvanceSearchVariableDto.class, (String)orderBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        return Paginator.forAll(advanceSearchVariables).viewPageByOffset(start, limit);
    }

    @RequestMapping(value={"myViews/{id}/advanced/variables/distinguish"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<AdvanceSearchVariableDto> getAdvanceSearchVariablesForViewDistinguish(@PathVariable Long id, @RequestParam(defaultValue="name") String orderBy, @RequestParam(defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit) {
        if (!this.viewRightsService.hasRightsToView(id)) {
            throw new NotFullRightsException();
        }
        String processDefinitionId = this.advanceSearchVariableService.getProcessDefinitionIdForView(id);
        List advanceSearchVariables = this.advanceSearchVariableService.getAdvanceSearchVariablesForView(id).stream().map(variable -> this.advanceSearchVariableMapper.fromEntity((AdvanceSearchVariableTable)variable, processDefinitionId)).sorted((Comparator<AdvanceSearchVariableDto>)DtoComparator.of(AdvanceSearchVariableDto.class, (String)orderBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        List viewVariables = advanceSearchVariables.stream().map(variable -> {
            AdvanceVariableForm advanceVariableForm = new AdvanceVariableForm();
            advanceVariableForm.setName(variable.getName());
            return advanceVariableForm;
        }).collect(Collectors.toList());
        boolean isProcessDefIdPresent = viewVariables.stream().anyMatch(variable -> variable.getName().equals("procDefId"));
        if (!isProcessDefIdPresent && StringUtils.isNotBlank((CharSequence)processDefinitionId)) {
            AdvanceVariableForm processDefIdVariable = new AdvanceVariableForm();
            processDefIdVariable.setName("procDefId");
            processDefIdVariable.setValue(processDefinitionId);
            viewVariables.add(processDefIdVariable);
        }
        Map extendedTypeVariables = this.advanceProcessSearchVariablesTypesProvider.getTypesForAdvanceSearchVariables(viewVariables).getExtendedTypeVariables();
        List variablesToDistinguish = advanceSearchVariables.stream().filter(variable -> this.isVariableValidForDistinguishing((AdvanceSearchVariableDto)variable, (String)extendedTypeVariables.get(variable.getName()))).collect(Collectors.toList());
        return Paginator.forAll(variablesToDistinguish).viewPageByOffset(start, limit);
    }

    private boolean isVariableValidForDistinguishing(AdvanceSearchVariableDto advanceSearchVariableDto, String extendedType) {
        if (advanceSearchVariableDto.getName().equals("taskUser") || advanceSearchVariableDto.getName().equals("procInitiator")) {
            return false;
        }
        if (extendedType != null) {
            return !extendedType.equals("USERNAME");
        }
        return true;
    }

    @RequestMapping(value={"myViews/export/{extension}"})
    public void exportMyViews(HttpServletResponse response, @RequestParam(required=false, defaultValue="") String query, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @PathVariable String extension, @RequestParam(required=false) UUID id) throws IOException {
        List<Object> views;
        if (id == null) {
            query = query.toLowerCase().trim();
            views = this.filterViews(this.viewService.getMyViewsForUser(UserContext.current().getUser().getUserName()), query).stream().sorted(DtoComparator.of(ViewDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
            this.exportViews(views, sortBy, sortDirection, response, extension);
        } else {
            views = this.getCachedViews(id);
        }
        this.exportMyViews(views, sortBy, sortDirection, response, extension);
    }

    @RequestMapping(value={"myViews/export/{extension}"}, method={RequestMethod.POST})
    @ResponseBody
    public URI exportMyViews(HttpServletRequest request, @RequestBody List<ViewDto> views, @PathVariable String extension, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) {
        return this.getRedirectUri(request, views);
    }

    @RequestMapping(value={"myViews/panel/export/{extension}"})
    public void exportPanelParameters(HttpServletResponse response, @RequestParam(required=false, defaultValue="id") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @PathVariable String extension) throws IOException {
        OperationPanelTableWrapper operationPanel = this.operationPanelService.getOperationPanelForUser(UserContext.current().getUser().getUserName());
        if (operationPanel == null) {
            throw new OperationPanelNotFoundException(this.messageHelper.getMessage("Panel_nie_istnieje"));
        }
        List parameters = this.operationPanelService.getOperationPanelParameters(operationPanel.getId()).stream().sorted(DtoComparator.of(OperationPanelParameterTableWrapper.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa_elementu")).data(parameters).by(OperationPanelParameterTableWrapper::getName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Typ_parametru")).data(parameters).by(OperationPanelParameterTableWrapper::getTranslatedType).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Element_panelu")).data(parameters).by(OperationPanelParameterTableWrapper::getTranslatedParams).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Czy_liczyc")).data(parameters).by(operationPanelParameterTableWrapper -> this.messageHelper.getMessage(String.valueOf(operationPanelParameterTableWrapper.getIsCount()))).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Pozycja")).data(parameters).by(operationPanelParameterTableWrapper -> String.valueOf(operationPanelParameterTableWrapper.getPosition())).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Parametry_panelu")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"private/export/{extension}"})
    public void exportPrivateViews(HttpServletResponse response, @RequestParam(value="query", required=false, defaultValue="") String rawQuery, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id, @PathVariable String extension) throws IOException {
        List<Object> views;
        if (id == null) {
            String query = rawQuery.trim().toLowerCase();
            views = this.filterViews(this.viewService.getViews(ViewFetchType.PRIVATE), query).stream().sorted(DtoComparator.of(ViewDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        } else {
            views = this.getCachedViews(id);
        }
        this.exportViews(views, sortBy, sortDirection, response, extension);
    }

    @RequestMapping(value={"private/export/{extension}"}, method={RequestMethod.POST})
    @ResponseBody
    public URI exportPrivateViews(HttpServletRequest request, @RequestBody List<ViewDto> views, @PathVariable String extension) throws URISyntaxException {
        return this.getRedirectUri(request, views);
    }

    @RequestMapping(value={"public/export/{extension}"})
    public void exportPublicViews(HttpServletResponse response, @RequestParam(value="query", required=false, defaultValue="") String rawQuery, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id, @PathVariable String extension) throws IOException {
        List<Object> views;
        if (id == null) {
            String query = rawQuery.trim().toLowerCase();
            views = this.filterViews(this.viewService.getViews(ViewFetchType.PUBLIC), query).stream().sorted(DtoComparator.of(ViewDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        } else {
            views = this.getCachedViews(id);
        }
        this.exportViews(views, sortBy, sortDirection, response, extension);
    }

    @RequestMapping(value={"public/export/{extension}"}, method={RequestMethod.POST})
    @ResponseBody
    public URI exportPublicViews(HttpServletRequest request, @RequestBody List<ViewDto> views, @PathVariable String extension, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws URISyntaxException {
        return this.getRedirectUri(request, views);
    }

    @RequestMapping(value={"all/export/{extension}"})
    public void exportAllViews(HttpServletResponse response, @RequestParam(value="query", required=false, defaultValue="") String rawQuery, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection, @RequestParam(required=false) UUID id, @PathVariable String extension) throws IOException {
        List<Object> views;
        this.authorizationHelper.assertFullSystemRights(() -> {});
        if (id == null) {
            String query = rawQuery.trim().toLowerCase();
            views = this.filterViews(this.viewService.getViews(ViewFetchType.ALL), query).stream().sorted(DtoComparator.of(ViewDto.class, (String)sortBy, (SortDirection)sortDirection).withIgnoreCase(true)).collect(Collectors.toList());
        } else {
            views = this.getCachedViews(id);
        }
        this.exportViews(views, sortBy, sortDirection, response, extension);
    }

    @RequestMapping(value={"all/export/{extension}"}, method={RequestMethod.POST})
    @ResponseBody
    public URI exportAllViews(HttpServletRequest request, @RequestBody List<ViewDto> views, @PathVariable String extension, @RequestParam(required=false, defaultValue="translatedName") String sortBy, @RequestParam(required=false, defaultValue="ASC") SortDirection sortDirection) throws URISyntaxException {
        return this.getRedirectUri(request, views);
    }

    private URI getRedirectUri(HttpServletRequest request, List<ViewDto> views) {
        UUID id;
        while (this.exportCache.containsKey(id = UUID.randomUUID())) {
        }
        this.exportCache.put(id, views);
        URI redirectUri = URI.create(request.getRequestURI());
        redirectUri = redirectUri.getQuery() != null ? URI.create(request.getRequestURI() + String.format("&id=%s", id)) : URI.create(request.getRequestURI() + String.format("?id=%s", id));
        return redirectUri;
    }

    private List<ViewDto> getCachedViews(UUID id) {
        List<ViewDto> viewsToExport = this.exportCache.get(id);
        this.exportCache.remove(id);
        return viewsToExport;
    }

    private List<ViewDto> filterViews(List<ViewDto> views, String query) {
        return views.stream().filter(view -> view.getTranslatedName().toLowerCase().contains(query) || view.getTranslatedDescription().toLowerCase().contains(query) || view.getOwnerUsername().toLowerCase().contains(query)).collect(Collectors.toList());
    }

    private void exportViews(List<ViewDto> sortedViews, String sortBy, SortDirection sortDirection, HttpServletResponse response, String extension) throws IOException {
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa")).data(sortedViews).by(ViewDto::getTranslatedName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis")).data(sortedViews).by(ViewDto::getTranslatedDescription).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Wlasciciel")).data(sortedViews).by(ViewDto::getOwnerUsername).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Widoki")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    private void exportMyViews(List<ViewDto> sortedViews, String sortBy, SortDirection sortDirection, HttpServletResponse response, String extension) throws IOException {
        List<ExportColumn> columns = Arrays.asList(ExportColumnBuilder.create().name(this.messageHelper.getMessage("Nazwa")).data(sortedViews).by(ViewDto::getTranslatedName).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Opis")).data(sortedViews).by(ViewDto::getTranslatedDescription).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Zrodlo_wyszukiwania")).data(sortedViews).by(ViewDto::getSource).build(), ExportColumnBuilder.create().name(this.messageHelper.getMessage("Poziom_dostepu")).data(sortedViews).by(ViewDto::getTranslatedAccessLevel).build());
        ExportModel model = ExportModel.builder().title(this.messageHelper.getMessage("Widoki")).columns(columns).build();
        ExportExtension extensionEnum = ExportExtension.valueOf((String)extension.toUpperCase());
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", String.format("attachment; filename=\"export.%s\"", extensionEnum.getExtension()));
        this.exportService.export(model, extensionEnum, (OutputStream)response.getOutputStream());
    }

    @ResponseBody
    @RequestMapping(value={"/gadget/views"}, method={RequestMethod.GET})
    public DynamicListResult getUserViewsForGadget() {
        DynamicListResult views = new DynamicListResult();
        UserContext userContext = UserContext.current();
        if (userContext.name() == null) {
            return views;
        }
        List userViews = this.viewService.getViews(ViewFetchType.PRIVATE);
        userViews.addAll(this.viewService.getViews(ViewFetchType.PUBLIC));
        userViews = userViews.stream().collect(Collectors.toMap(ViewDto::getId, Function.identity(), (existing, replacement) -> existing)).values().stream().collect(Collectors.toList());
        for (ViewDto view : userViews) {
            String translatedName = StringUtils.isNotBlank((CharSequence)view.getTranslatedName()) ? view.getTranslatedName() : view.getName();
            views.addEntry(translatedName, (Object)view.getId());
        }
        if (this.experimental.hasFeature(ExperimentalFeature.PROCESS_DASHBOARDS)) {
            User user = this.userService.getUser(userContext.getUser().getUserName(), new String[0]);
            List dynamicViewDtos = this.dynamicViewService.getDynamicViewsForUser(user);
            dynamicViewDtos.sort(Comparator.comparing(DynamicViewDto::getViewName));
            for (DynamicViewDto dynamicViewDto : dynamicViewDtos) {
                views.addEntry(dynamicViewDto.getViewName(), (Object)dynamicViewDto.getViewId());
            }
        }
        return views;
    }

    @ResponseBody
    @RequestMapping(value={"/gadget/{viewId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getViewForGadget(@PathVariable Long viewId, HttpServletRequest request) {
        try {
            ViewDto view = this.viewService.getUserSearchView(viewId.toString());
            String userName = UserContext.current().getUser().getUserName();
            if (!this.viewRightsService.hasRightsToView(viewId.toString(), view.getOwnerUsername(), userName)) {
                NoRightsResult noRightsResult = NoRightsResult.builder().right("view").build();
                return new ResponseEntity((Object)noRightsResult, HttpStatus.FORBIDDEN);
            }
            List searchVariablesForView = this.advanceProcessSearchDBHelper.getSearchVariablesForView(viewId);
            Optional<AdvanceSearchVariableTable> processDefVariableTable = searchVariablesForView.stream().filter(advanceSearchVariableTable -> advanceSearchVariableTable.getName().equals("procDefId")).findFirst();
            String processDefId = processDefVariableTable.map(AdvanceSearchVariableTable::getValue).orElse(null);
            if (!this.viewRightsService.hasRightsToProcessInView(processDefId, view.getOwnerUsername(), userName)) {
                NoRightsResult noRightsResult = NoRightsResult.builder().message(this.messageHelper.getMessage("brak_uprawnien_do_procesu_w_widoku", new Object[]{userName, processDefId})).right("process").build();
                return new ResponseEntity((Object)noRightsResult, HttpStatus.FORBIDDEN);
            }
            String searchId = UUID.randomUUID().toString();
            GadgetViewDto gadgetViewDto = GadgetViewDto.builder().viewId(viewId).translatedName(Jsoup.clean((String)view.getTranslatedName(), (Safelist)Safelist.basic())).searchId(searchId).encodedSearchFormModel(this.getEncodedSearchFormModel(request, viewId, searchId, searchVariablesForView)).build();
            return new ResponseEntity((Object)gadgetViewDto, HttpStatus.OK);
        }
        catch (ViewDoesNotExistException e) {
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/gadget/dynamic"}, method={RequestMethod.GET})
    public ResponseEntity<?> getDynamicViewForGadget(@RequestParam String processDefId, @RequestParam ProcessSearchViewType processSearchViewType, HttpServletRequest request) {
        Optional processSearchView = this.processSearchViewService.findViewForProcessDefIdAndType(processDefId, processSearchViewType);
        if (!processSearchView.isPresent()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        String encodedSearchFormModel = this.processSearchViewService.encodeSearchFormModel((ProcessSearchView)processSearchView.get());
        Cache<String, String> cache = this.searchFormCache.getCache(request.getSession(false));
        ConcurrentMap sessionCache = cache.asMap();
        String searchId = UUID.randomUUID().toString();
        sessionCache.put(searchId, encodedSearchFormModel);
        ProcessType processType = (ProcessType)this.processService.getProcessTypesForProcessDefIds(Collections.singletonList(processDefId)).get(0);
        DynamicViewDto dynamicViewDto = this.dynamicViewService.getDynamicViewDto(processType, processSearchViewType);
        GadgetViewDto gadgetViewDto = GadgetViewDto.builder().translatedName(Jsoup.clean((String)dynamicViewDto.getViewName(), (Safelist)Safelist.basic())).searchId(searchId).encodedSearchFormModel(encodedSearchFormModel).dynamic(true).build();
        return new ResponseEntity((Object)gadgetViewDto, HttpStatus.OK);
    }

    private String getEncodedSearchFormModel(HttpServletRequest request, Long viewId, String searchId, List<AdvanceSearchVariableTable> searchVariablesForView) throws ViewDoesNotExistException, JsonProcessingException {
        SearchFormModelDto searchFormModel = this.viewVariablesToSearchModelMapper.map(searchVariablesForView);
        ObjectMapper mapper = new ObjectMapper();
        String encodedSearchFormModel = Base64.getEncoder().encodeToString(mapper.writeValueAsString((Object)searchFormModel).getBytes(StandardCharsets.UTF_8));
        this.searchFormCache.cacheSearchForm(request.getSession(false), searchId, encodedSearchFormModel);
        return encodedSearchFormModel;
    }

    private List<ViewDto> getEditableViews(String loggedUserName) {
        return this.viewService.getAllEditableViewsForUser(loggedUserName);
    }

    @ExceptionHandler(value={UserSearchViewTableNotFoundException.class, OperationPanelNotFoundException.class, OperationPanelParameterNotFoundException.class, VariableDistinguishNotFoundException.class, SearchProtectionViewDoesNotExist.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public RestResult handleNotFoundException(Exception e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={UserSearchViewTableProtectionAlreadyExistsException.class, ServiceException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public RestResult handleAlreadyExistException(Exception e) {
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"viewService", "exportService", "operationPanelService", "variableDistinguishService", "viewProtectionService", "advanceSearchVariableService", "advanceSearchVariableMapper", "searchFormCache", "advanceProcessSearchDBHelper", "viewVariablesToSearchModelMapper", "messageHelper", "viewRightsService", "experimental", "dynamicViewService", "processSearchViewService", "processService", "userService", "advanceProcessSearchVariablesTypesProvider", "authorizationHelper"})
    @Autowired
    public ViewController(ViewService viewService, ExportService exportService, OperationPanelService operationPanelService, VariableDistinguishService variableDistinguishService, ViewProtectionService viewProtectionService, AdvanceSearchVariableService advanceSearchVariableService, AdvanceSearchVariableMapper advanceSearchVariableMapper, SearchFormCache searchFormCache, AdvanceProcessSearchDBHelper advanceProcessSearchDBHelper, ViewVariablesToSearchModelMapper viewVariablesToSearchModelMapper, MessageHelperBean messageHelper, ViewRightsService viewRightsService, Experimental experimental, DynamicViewService dynamicViewService, ProcessSearchViewService processSearchViewService, ProcessService processService, UserService userService, AdvanceProcessSearchVariablesTypesProvider advanceProcessSearchVariablesTypesProvider, AuthorizationHelper authorizationHelper) {
        this.viewService = viewService;
        this.exportService = exportService;
        this.operationPanelService = operationPanelService;
        this.variableDistinguishService = variableDistinguishService;
        this.viewProtectionService = viewProtectionService;
        this.advanceSearchVariableService = advanceSearchVariableService;
        this.advanceSearchVariableMapper = advanceSearchVariableMapper;
        this.searchFormCache = searchFormCache;
        this.advanceProcessSearchDBHelper = advanceProcessSearchDBHelper;
        this.viewVariablesToSearchModelMapper = viewVariablesToSearchModelMapper;
        this.messageHelper = messageHelper;
        this.viewRightsService = viewRightsService;
        this.experimental = experimental;
        this.dynamicViewService = dynamicViewService;
        this.processSearchViewService = processSearchViewService;
        this.processService = processService;
        this.userService = userService;
        this.advanceProcessSearchVariablesTypesProvider = advanceProcessSearchVariablesTypesProvider;
        this.authorizationHelper = authorizationHelper;
    }

    static class NoRightsResult {
        private String message;
        private String right;

        public static NoRightsResultBuilder builder() {
            return new NoRightsResultBuilder();
        }

        public String getMessage() {
            return this.message;
        }

        public String getRight() {
            return this.right;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setRight(String right) {
            this.right = right;
        }

        public NoRightsResult() {
        }

        @ConstructorProperties(value={"message", "right"})
        public NoRightsResult(String message, String right) {
            this.message = message;
            this.right = right;
        }

        public static class NoRightsResultBuilder {
            private String message;
            private String right;

            NoRightsResultBuilder() {
            }

            public NoRightsResultBuilder message(String message) {
                this.message = message;
                return this;
            }

            public NoRightsResultBuilder right(String right) {
                this.right = right;
                return this;
            }

            public NoRightsResult build() {
                return new NoRightsResult(this.message, this.right);
            }

            public String toString() {
                return "ViewController.NoRightsResult.NoRightsResultBuilder(message=" + this.message + ", right=" + this.right + ")";
            }
        }
    }
}

