/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.search;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.plusmpm.enhydra.shark.WfActivityManager;
import com.plusmpm.i18n.I18Nxpdl;
import com.plusmpm.util.ActionButtons;
import com.plusmpm.util.XpdlPackageManager;
import com.plusmpm.util.workflowData.ActivityData;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.database.DBUtils;
import com.suncode.pwfl.form.service.FormTemplateService;
import com.suncode.pwfl.form.template.FormTemplate;
import com.suncode.pwfl.form.template.Item;
import com.suncode.pwfl.form.template.ItemStyles;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.util.Sneaky;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.view.dto.ViewDto;
import com.suncode.pwfl.view.exception.ViewDoesNotExistException;
import com.suncode.pwfl.web.controller.api.workflow.search.cache.SearchResultMeta;
import com.suncode.pwfl.web.dto.workflow.search.AcceptanceButtonDto;
import com.suncode.pwfl.web.dto.workflow.search.GroupAcceptanceContextDto;
import com.suncode.pwfl.web.search.model.SearchFormModelDto;
import com.suncode.pwfl.web.search.model.ValueSearchModelDto;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.exception.ActivityAlreadyCompletedException;
import com.suncode.pwfl.workflow.activity.exception.ActivityIsNotSuspendedException;
import com.suncode.pwfl.workflow.activity.indexer.ActivityIndexingService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessEntity;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.process.exception.FailedBulkProcessDeleteException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.xpdl.elements.Package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdvanceProcessSearchGroupOperationsHelper {
    private static final Logger log = LoggerFactory.getLogger(AdvanceProcessSearchGroupOperationsHelper.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ViewService viewService;
    @Autowired
    private MessageHelperBean messageHelper;
    @Autowired
    private ActivityIndexingService activityIndexingService;
    @Autowired
    private FormTemplateService formTemplateService;

    @Transactional
    public long abortProcesses(Set<String> processIds, String userName, String operationSource) {
        long abortedProcessesCount = 0L;
        for (String processId : processIds) {
            Process process = this.processService.getProcess(processId, new String[]{"processDefinition"});
            Map<String, Object> params = this.buildAbortOrDeleteProcessAuditParams(processId, process, operationSource);
            try {
                log.info("Aborting process:" + processId);
                if (!process.getState().getStateText().startsWith("open")) {
                    log.info("Nie mo\u017cna anulowa\u0107 procesu kt\u00f3ry nie zosta\u0142 uruchomiony.");
                    throw new ServiceException(this.messageHelper.getMessage("Nie_mozna_anulowac_procesu_ktory_nie_zostal_uruchomiony"));
                }
                this.processService.abort(processId, true);
                ++abortedProcessesCount;
                this.buildAudit(AuditTypes.AUDIT_ABORT_PROCESS, true, params, userName).log();
            }
            catch (ServiceException e) {
                log.error(e.getMessage());
                this.buildAudit(AuditTypes.AUDIT_ABORT_PROCESS, false, params, userName).log();
            }
        }
        this.processService.abortGroupInElastic(new ArrayList<String>(processIds));
        return abortedProcessesCount;
    }

    @Transactional
    public long deleteProcesses(Set<String> processIds, String userName, String operationSource) {
        long deletedProcessesCount;
        HashMap<String, AuditWrapper> audits = new HashMap<String, AuditWrapper>();
        ArrayList failedDeleteAttempts = new ArrayList();
        try {
            for (String processId2 : processIds) {
                Object params;
                try {
                    Process process = this.processService.getProcess(processId2, new String[]{"processDefinition"});
                    params = this.buildAbortOrDeleteProcessAuditParams(processId2, process, operationSource);
                    log.info("Delete process:" + processId2);
                    audits.put(processId2, this.buildAudit(AuditTypes.AUDIT_DELETE_PROCESS, true, (Map<String, Object>)params, userName));
                }
                catch (Exception e) {
                    log.error("B\u0142\u0105d podczas tworzenia audytu");
                    params = ImmutableMap.of((Object)"ProcessId", (Object)processId2, (Object)"operation_source", (Object)operationSource, (Object)"is_group_operation", (Object)"Tak");
                    audits.put(processId2, this.buildAudit(AuditTypes.AUDIT_DELETE_PROCESS, false, (Map<String, Object>)params, userName));
                }
            }
            this.processService.deleteProcesses(new ArrayList<String>(processIds));
            deletedProcessesCount = processIds.size();
        }
        catch (FailedBulkProcessDeleteException e) {
            failedDeleteAttempts.addAll(e.getFailedProcessIds());
            deletedProcessesCount = processIds.size() - failedDeleteAttempts.size();
        }
        audits.forEach((processId, audit) -> {
            if (failedDeleteAttempts.contains(processId)) {
                audit.setAuditSuccess(false);
            }
            audit.log();
        });
        return deletedProcessesCount;
    }

    @Transactional
    public long suspendActivities(Set<SearchResultMeta> searchResultMetas, String userName, String operationSource) {
        long suspendedActivitiesCount = 0L;
        for (SearchResultMeta searchResultMeta : searchResultMetas) {
            ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_SUSPEND_ACTIVITY);
            auditBuilder.username(userName);
            auditBuilder.started(new Date());
            try {
                String processId = searchResultMeta.getProcessId();
                String activityId = searchResultMeta.getActivityId();
                Activity activity = this.activityService.getActivity(activityId, searchResultMeta.getActivityId(), new String[]{"process"});
                auditBuilder.params(this.buildSuspendOrResumeActivitiesAuditParams(activity, operationSource));
                try {
                    log.info("Suspending activity:" + processId);
                    if (!activity.getState().getStateText().startsWith("open")) {
                        log.info("Nie mo\u017cna zawiesi\u0107 zadania kt\u00f3re nie zosta\u0142o uruchomione lub si\u0119 zako\u0144czy\u0142o.");
                        throw new ServiceException(this.messageHelper.getMessage("Nie_mozna_zawiesic_zadania_ktore_nie_jest_uruchomione_lub_sie_zakonczylo"));
                    }
                    this.activityService.suspendActivity(activityId, processId, true);
                    ++suspendedActivitiesCount;
                    auditBuilder.success(true).build().log();
                }
                catch (ServiceException | ActivityAlreadyCompletedException e) {
                    auditBuilder.success(false).build().log();
                    log.error(e.getMessage());
                }
            }
            catch (Exception e) {
                log.error("B\u0142\u0105d podczas tworzenia audytu");
                Map<String, Object> params = this.buildFailedActivityParams(searchResultMeta, operationSource);
                auditBuilder.params(params).success(false).build().log();
                throw e;
            }
        }
        this.activityIndexingService.indexSync(this.getActivitiesToIndexMap(searchResultMetas), true);
        return suspendedActivitiesCount;
    }

    @Transactional
    public long resumeActivities(Set<SearchResultMeta> searchResultMetas, String userName, String operationSource) {
        long resumedActivitiesCount = 0L;
        for (SearchResultMeta searchResultMeta : searchResultMetas) {
            ManualAuditBuilder auditBuilder = ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_RESUME_ACTIVITY);
            auditBuilder.username(userName);
            auditBuilder.started(new Date());
            try {
                String processId = searchResultMeta.getProcessId();
                String activityId = searchResultMeta.getActivityId();
                Activity activity = this.activityService.getActivity(activityId, searchResultMeta.getActivityId(), new String[0]);
                auditBuilder.params(this.buildSuspendOrResumeActivitiesAuditParams(activity, operationSource));
                try {
                    log.info("Resuming activity:" + processId);
                    if (!activity.getState().getStateText().startsWith("open.not_running.suspended")) {
                        log.info("Nie mo\u017cna przywrocic zadania kt\u00f3ry nie jest zawieszone");
                        throw new ServiceException(this.messageHelper.getMessage("Nie_mozna_przywrocic_zadania_ktore_nie_jest_zawieszone"));
                    }
                    this.activityService.resumeActivity(activityId, processId, true);
                    auditBuilder.success(true).build().log();
                    ++resumedActivitiesCount;
                }
                catch (ServiceException | ActivityIsNotSuspendedException e) {
                    auditBuilder.success(false).build().log();
                    log.error(e.getMessage());
                }
            }
            catch (Exception e) {
                log.error("B\u0142\u0105d podczas tworzenia audytu");
                Map<String, Object> params = this.buildFailedActivityParams(searchResultMeta, operationSource);
                auditBuilder.params(params).success(false).build().log();
                throw e;
            }
        }
        this.activityIndexingService.indexSync(this.getActivitiesToIndexMap(searchResultMetas), true);
        return resumedActivitiesCount;
    }

    private Map<String, List<String>> getActivitiesToIndexMap(Set<SearchResultMeta> searchResultMetas) {
        return searchResultMetas.stream().collect(Collectors.groupingBy(SearchResultMeta::getProcessId, Collectors.mapping(SearchResultMeta::getActivityId, Collectors.toList())));
    }

    private Map<String, Object> buildAbortOrDeleteProcessAuditParams(String processId, Process process, String operationSource) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String processDefinitionId = process.getProcessDefinition().getProcessDefinitionId();
        String processName = process.getRawName();
        String packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(processDefinitionId);
        params.put("ProcessId", processId);
        params.put("package_name", packageId);
        params.put("process_name", processName);
        params.put("processDefId", processDefinitionId);
        params.put("operation_source", operationSource);
        params.put("is_group_operation", "Tak");
        return params;
    }

    private Map<String, Object> buildSuspendOrResumeActivitiesAuditParams(Activity activity, String operationSource) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ProcessEntity process = activity.getProcess();
        String processDefinitionId = process.getProcessDefinition().getProcessDefinitionId();
        String packageId = XpdlPackageManager.getInstance().getPackageIdByProcessDefinitionId(processDefinitionId);
        params.put("ProcessId", process.getProcessId());
        params.put("package_name", packageId);
        params.put("operation_source", operationSource);
        params.put("is_group_operation", "Tak");
        params.put("ActivityId", activity.getActivityId());
        return params;
    }

    private Map<String, Object> buildFailedActivityParams(SearchResultMeta searchResultMeta, String operationSource) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ProcessId", searchResultMeta.getProcessId());
        params.put("ActivityId", searchResultMeta.getActivityId());
        params.put("operation_source", operationSource);
        params.put("is_group_operation", "Tak");
        return params;
    }

    private AuditWrapper buildAudit(AuditTypes auditType, boolean success, Map<String, Object> params, String userName) {
        return ManualAuditBuilder.getInstance().type(auditType).success(success).started(new Date()).username(userName).params(params).build();
    }

    public GroupAcceptanceContextDto getGroupAcceptanceContextDto(SearchFormModelDto searchFormModelDto, Long viewId) {
        boolean processAndActivityDefinitionsMatch;
        List<AcceptanceButtonDto> displayedAcceptanceButtons = new ArrayList<AcceptanceButtonDto>();
        String messageTemplate = "%s. " + this.messageHelper.getMessage("acceptManyTasksDisabled.info");
        if (viewId == null) {
            return new GroupAcceptanceContextDto(false, displayedAcceptanceButtons, null);
        }
        try {
            ViewDto userSearchView = this.viewService.getUserSearchView(String.valueOf(viewId));
            if (!userSearchView.isAcceptManyTasks()) {
                return new GroupAcceptanceContextDto(false, displayedAcceptanceButtons, null);
            }
        }
        catch (ViewDoesNotExistException e) {
            log.error("Nie uda\u0142o si\u0119 pobra\u0107 widoku o id: " + viewId, (Throwable)e);
            return new GroupAcceptanceContextDto(false, displayedAcceptanceButtons, null);
        }
        String processDefinitionId = searchFormModelDto.getProcessVariablesSearchModel().getProcessDefinitionId();
        String[] processType = searchFormModelDto.getProcessDetailsSearchModel().getProcessDefinitionId().getValues();
        ValueSearchModelDto activityNameSearchValueModel = searchFormModelDto.getActivityDetailsSearchModel().getName();
        if (activityNameSearchValueModel.isRangeActive()) {
            return new GroupAcceptanceContextDto(false, displayedAcceptanceButtons, String.format(messageTemplate, this.messageHelper.getMessage("acceptManyTasksDisabled.rangeActivitySearch")));
        }
        String activityName = activityNameSearchValueModel.getValue();
        if (activityName == null) {
            String[] activityNameValues = searchFormModelDto.getActivityDetailsSearchModel().getName().getValues();
            if (activityNameValues.length > 1) {
                return new GroupAcceptanceContextDto(false, displayedAcceptanceButtons, String.format(messageTemplate, this.messageHelper.getMessage("acceptManyTasksDisabled.toManyActivities")));
            }
            if (activityNameValues.length == 1 && StringUtils.isNotBlank((CharSequence)activityNameValues[0])) {
                activityName = activityNameValues[0];
            }
        }
        if (activityName == null) {
            return new GroupAcceptanceContextDto(false, displayedAcceptanceButtons, String.format(messageTemplate, this.messageHelper.getMessage("acceptManyTasksDisabled.noActivity")));
        }
        String validProcessDefinitionId = null;
        if (StringUtils.isNotBlank((CharSequence)processDefinitionId)) {
            validProcessDefinitionId = processDefinitionId;
        } else if (processType.length == 1 && StringUtils.isNotBlank((CharSequence)processType[0])) {
            validProcessDefinitionId = processType[0];
        }
        if (validProcessDefinitionId == null) {
            return new GroupAcceptanceContextDto(false, displayedAcceptanceButtons, String.format(messageTemplate, this.messageHelper.getMessage("acceptManyTasksDisabled.noProcess")));
        }
        if (DBUtils.isExactQuery((String)activityName) && StringUtils.isBlank((CharSequence)(activityName = DBUtils.getExactQueryValue((String)activityName)))) {
            return new GroupAcceptanceContextDto(false, displayedAcceptanceButtons, String.format(messageTemplate, this.messageHelper.getMessage("acceptManyTasksDisabled.noActivity")));
        }
        ActivityData activityData = new ActivityData();
        List acceptanceButtons = activityData.GetActivityAdditionalButtonsByActivityName(validProcessDefinitionId, activityName);
        boolean bl = processAndActivityDefinitionsMatch = acceptanceButtons != null;
        if (!processAndActivityDefinitionsMatch) {
            return new GroupAcceptanceContextDto(false, displayedAcceptanceButtons, String.format(messageTemplate, this.messageHelper.getMessage("acceptManyTasksDisabled.wrongActivity")));
        }
        List acceptanceButtonsTemplates = acceptanceButtons.isEmpty() ? Collections.emptyList() : this.getAcceptanceButtonsTemplates((ActionButtons)acceptanceButtons.get(0));
        displayedAcceptanceButtons = acceptanceButtons.stream().filter(button -> {
            String destination = button.getDestination();
            return StringUtils.isBlank((CharSequence)destination) || destination.equals("ALL") || destination.equals("GROUPFORM");
        }).map(button -> new AcceptanceButtonDto(button.getButtonName(), button.getActionName(), this.getAcceptanceButtonColor(acceptanceButtonsTemplates, (ActionButtons)button), this.getAcceptanceButtonIcon(acceptanceButtonsTemplates, (ActionButtons)button))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(displayedAcceptanceButtons)) {
            displayedAcceptanceButtons.add(new AcceptanceButtonDto(this.messageHelper.getMessage("Zatwierdz"), "", "", ""));
        }
        return new GroupAcceptanceContextDto(true, displayedAcceptanceButtons, null);
    }

    private List<Item> getAcceptanceButtonsTemplates(ActionButtons button) {
        LinkedList<Item> acceptanceButtons = new LinkedList<Item>();
        Package acPackage = XpdlPackageManager.getInstance().getPackageByProcessDefinitionId(button.getProcessDefId());
        String templatePath = this.formTemplateService.buildFormTemplateFilePath(acPackage, button.getProcessDefId(), button.getActivityDefId());
        try (FileReader reader = new FileReader(templatePath);){
            FormTemplate formTemplate = this.formTemplateService.parseFormTemplate((Reader)reader);
            formTemplate.getRows().forEach(row -> {
                List items = row.getItems().stream().filter(item -> item.getType().equals("ACTION_ACCEPT_BUTTON")).collect(Collectors.toCollection(LinkedList::new));
                acceptanceButtons.addAll(items);
            });
        }
        return acceptanceButtons;
    }

    private String getAcceptanceButtonColor(List<Item> acceptanceButtonsTemplates, ActionButtons button) {
        if (acceptanceButtonsTemplates.isEmpty()) {
            return "";
        }
        Optional<Item> acceptanceButtonColorItem = acceptanceButtonsTemplates.stream().filter(template -> template.getId().equals(button.getActionName())).findFirst();
        if (!acceptanceButtonColorItem.isPresent()) {
            return "";
        }
        ItemStyles styles = acceptanceButtonColorItem.get().getStyles();
        return styles == null ? "" : StringUtils.defaultString((String)acceptanceButtonColorItem.get().getStyles().getColor());
    }

    private String getAcceptanceButtonIcon(List<Item> acceptanceButtonsTemplates, ActionButtons button) {
        if (acceptanceButtonsTemplates.isEmpty()) {
            return "";
        }
        Optional<Item> acceptanceButtonIconItem = acceptanceButtonsTemplates.stream().filter(template -> template.getId().equals(button.getActionName())).findFirst();
        if (!acceptanceButtonIconItem.isPresent()) {
            return "";
        }
        ItemStyles styles = acceptanceButtonIconItem.get().getStyles();
        if (styles == null) {
            return "";
        }
        String iconString = StringUtils.defaultString((String)acceptanceButtonIconItem.get().getStyles().getIcon());
        return !iconString.contains("DIVANTE_ICON_") ? iconString : iconString.split("DIVANTE_ICON_")[1];
    }

    public long acceptActivities(List<SearchResultMeta> searchResultMetas, String userName, String actionName, boolean all) {
        AtomicLong acceptedActivitiesCount = new AtomicLong();
        for (SearchResultMeta searchResultMeta : searchResultMetas) {
            String activityId = searchResultMeta.getActivityId();
            String processId = searchResultMeta.getProcessId();
            Map<String, Object> params = this.buildAcceptActivityAuditParams(processId, activityId, actionName);
            try {
                Sneaky.throwing(() -> {
                    WfActivityManager wfActivityManager = new WfActivityManager(activityId, processId, userName, actionName);
                    wfActivityManager.setIgnoreOwnership(true);
                    wfActivityManager.setXpdl(new I18Nxpdl(LocaleContextHolder.getLocale()));
                    wfActivityManager.acceptActivity();
                    this.buildAudit(AuditTypes.AUDIT_ACCEPT_ACTIVITY, true, params, userName).log();
                    acceptedActivitiesCount.getAndIncrement();
                });
            }
            catch (Throwable t) {
                log.error("B\u0142\u0105d podczas akcepatacji zadania od id: " + activityId + "z procesu o id: " + processId, t);
                this.buildAudit(AuditTypes.AUDIT_ACCEPT_ACTIVITY, false, params, userName).log();
            }
        }
        this.activityIndexingService.indexSync(this.getActivitiesToIndexMap(Sets.newHashSet(searchResultMetas)), true);
        return acceptedActivitiesCount.get();
    }

    private Map<String, Object> buildAcceptActivityAuditParams(String processId, String activityId, String actionName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        params.put("activityId", activityId);
        params.put("checkForm", "");
        params.put("actionName", actionName);
        return params;
    }
}

