/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.workflow.process;

import com.suncode.pwfl.process.variables.ProcessVariableService;
import com.suncode.pwfl.web.search.model.SearchFormVariableDefinitionDto;
import com.suncode.pwfl.workflow.process.ProcessService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"processes/variables"})
public class VariableController {
    @Autowired
    private ProcessVariableService processVariableService;
    @Autowired
    private ProcessService processService;

    @RequestMapping(value={"{processDefId}"})
    @ResponseBody
    public List<SearchFormVariableDefinitionDto> getVariablesForProcessDefinition(@PathVariable String processDefId) {
        return this.processVariableService.getVariablesForProcessDefinition(processDefId);
    }

    @ResponseBody
    @RequestMapping(value={"{processId}/values"}, method={RequestMethod.POST})
    public Map<String, Object> getAdvanceSearchResultValues(@PathVariable String processId, @RequestBody List<String> columnIds) throws IOException {
        Map processContext = this.processService.getProcessContext(processId);
        HashMap<String, Object> newDocumentIndexes = new HashMap<String, Object>();
        for (String name : columnIds) {
            Object indexValue = processContext.get(name);
            newDocumentIndexes.put(name, indexValue);
        }
        return newDocumentIndexes;
    }
}

