/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.useraccount;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.plusmpm.database.variableDistinguish.VariableDistinguishDB;
import com.plusmpm.database.variableDistinguish.VariableDistinguishTable;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.i18n.MessageHelperBean;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.view.exception.VariableDistinguishNotFoundException;
import com.suncode.pwfl.view.service.viewRights.ViewRightsService;
import com.suncode.pwfl.web.security.exception.NotFullRightsException;
import com.suncode.pwfl.web.support.ajax.RestResult;
import com.suncode.pwfl.web.support.distinction.DistinctionUtil;
import com.suncode.pwfl.web.support.distinction.dto.DistinctionDto;
import com.suncode.pwfl.web.util.JsonMessage;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/distinction"})
public class DistinctionController {
    private static final Logger log = LoggerFactory.getLogger(DistinctionController.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final ViewRightsService viewRightsService;
    private final MessageHelperBean messageHelper;

    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public JsonMessage addDistinction(HttpServletRequest request, @RequestBody DistinctionDto data) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_ADD_VARIABLE_DISTINGUISH);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("viewId", data.getViewId());
        auditParams.put("variableName", data.getVariableName());
        auditParams.put("variableType", StringUtils.defaultString((String)data.getDisplayType()));
        auditParams.put("variableFormat", StringUtils.defaultString((String)data.getDisplayFormat()));
        auditParams.put("variableColor", data.getColor());
        auditBuilder.params(auditParams);
        if (!this.viewRightsService.hasRightsToView(data.getViewId())) {
            auditBuilder.buildFailure(request);
            throw new NotFullRightsException();
        }
        try {
            VariableDistinguishTable distinction = new VariableDistinguishTable();
            distinction.setViewId(String.valueOf(data.getViewId()));
            distinction.setVariableId(data.getVariableId());
            distinction.setVariableName(data.getVariableName());
            distinction.setImagePath(data.getImagePath());
            distinction.setVariableViewType(data.getDisplayType());
            distinction.setVariableFormat(data.getDisplayFormat());
            distinction.setColor(data.getColor());
            distinction.setBackgroundColor(data.getBackgroundColor());
            ObjectWriter ow = this.mapper.writer();
            String conditions = ow.writeValueAsString((Object)data.getConditions());
            distinction.setVariableValue(conditions);
            long variableId = VariableDistinguishDB.addVariableDistinguish((VariableDistinguishTable)distinction);
            auditParams.put("variableDistinguishId", variableId);
            auditBuilder.params(auditParams);
        }
        catch (JsonProcessingException e) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            log.error(e.getMessage(), (Throwable)e);
        }
        request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
        return new JsonMessage();
    }

    @ResponseBody
    @RequestMapping(value={"/{distinctionId}"}, method={RequestMethod.GET})
    public DistinctionDto getDistinction(@PathVariable Long distinctionId) {
        try {
            DistinctionDto distinction = DistinctionUtil.getDistinction((Long)distinctionId);
            if (!this.viewRightsService.hasRightsToView(distinction.getViewId())) {
                throw new NotFullRightsException();
            }
            return distinction;
        }
        catch (JsonParseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (JsonMappingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @ResponseBody
    @RequestMapping(value={"change/{distinctionId}"}, method={RequestMethod.POST})
    public JsonMessage changeDistinction(HttpServletRequest request, @PathVariable Long distinctionId, @RequestBody DistinctionDto data) {
        AuditBuilder auditBuilder = AuditBuilder.getInstance().type(AuditTypes.AUDIT_UPDATE_VARIABLE_DISTINGUISH);
        VariableDistinguishTable distinction = VariableDistinguishDB.getVariablesDistinguishById((Long)distinctionId);
        HashMap<String, Object> auditParams = new HashMap<String, Object>();
        auditParams.put("variableDistinguishId", distinctionId);
        auditBuilder.params(auditParams);
        if (distinction == null) {
            request.setAttribute("audit", (Object)auditBuilder.buildFailure());
            throw new VariableDistinguishNotFoundException(MessageHelper.getMessage((String)"Wyroznienie_zmiennej_nie_istnieje"));
        }
        if (!this.viewRightsService.hasRightsToView(Long.valueOf(Long.parseLong(distinction.getViewId())))) {
            auditBuilder.buildFailure(request);
            throw new NotFullRightsException();
        }
        auditParams.put("viewId", data.getViewId());
        auditParams.put("variableName", distinction.getVariableName() + ";" + data.getVariableName());
        auditParams.put("variableType", StringUtils.defaultString((String)distinction.getVariableViewType()) + ";" + StringUtils.defaultString((String)data.getDisplayType()));
        auditParams.put("variableFormat", StringUtils.defaultString((String)distinction.getVariableFormat()) + ";" + StringUtils.defaultString((String)data.getDisplayFormat()));
        auditParams.put("variableColor", distinction.getColor() + ";" + data.getColor());
        auditBuilder.params(auditParams);
        try {
            distinction.setViewId(String.valueOf(data.getViewId()));
            distinction.setVariableId(data.getVariableId());
            distinction.setVariableName(data.getVariableName());
            distinction.setImagePath(data.getImagePath());
            distinction.setVariableViewType(data.getDisplayType());
            distinction.setVariableFormat(data.getDisplayFormat());
            distinction.setColor(data.getColor());
            distinction.setBackgroundColor(data.getBackgroundColor());
            ObjectWriter ow = this.mapper.writer();
            String conditions = ow.writeValueAsString((Object)data.getConditions());
            distinction.setVariableValue(conditions);
            VariableDistinguishDB.changeVariableDistinguish((VariableDistinguishTable)distinction);
            request.setAttribute("audit", (Object)auditBuilder.buildSuccess());
            return new JsonMessage();
        }
        catch (Exception e) {
            auditBuilder.buildFailure(request);
            log.error(e.getMessage(), (Throwable)e);
            return new JsonMessage();
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{distinctionId}"}, method={RequestMethod.DELETE})
    public void deleteDistinction(@PathVariable Long distinctionId) {
        VariableDistinguishTable distinction = VariableDistinguishDB.getVariablesDistinguishById((Long)distinctionId);
        if (distinction == null) {
            throw new VariableDistinguishNotFoundException(this.messageHelper.getMessage("Wyroznienie_zmiennej_nie_istnieje"));
        }
        if (!this.viewRightsService.hasRightsToView(Long.valueOf(Long.parseLong(distinction.getViewId())))) {
            throw new NotFullRightsException();
        }
        VariableDistinguishDB.deleteVariableDistinguish((VariableDistinguishTable)distinction);
    }

    @ExceptionHandler(value={ServiceException.class, VariableDistinguishNotFoundException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public JsonMessage handleBadRequest(Exception e) {
        log.info(e.getMessage());
        return new JsonMessage(false, e.getMessage());
    }

    @ExceptionHandler(value={NotFullRightsException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public RestResult handleNotFullRightsException(NotFullRightsException e) {
        log.info(this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
        return new RestResult(false, this.messageHelper.getMessage("Brak_uprawnien_do_wykonania_akcji"));
    }

    @ConstructorProperties(value={"viewRightsService", "messageHelper"})
    @Autowired
    public DistinctionController(ViewRightsService viewRightsService, MessageHelperBean messageHelper) {
        this.viewRightsService = viewRightsService;
        this.messageHelper = messageHelper;
    }
}

