/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.system;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.plusmpm.database.authorization.RightTreeBuilder;
import com.plusmpm.util.Authorization;
import com.suncode.pwfl.audit.builder.AuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.configuration.ConfigurationExportService;
import com.suncode.pwfl.configuration.ConfigurationImportService;
import com.suncode.pwfl.configuration.ConfigurationTypes;
import com.suncode.pwfl.configuration.dto.ConfigurationDtoRoot;
import com.suncode.pwfl.configuration.dto.plugins.PluginConfigurationDtoRoot;
import com.suncode.pwfl.configuration.plugins.PluginConfigurationService;
import com.suncode.pwfl.configuration.plugins.PluginConfigurationTransferSupportService;
import com.suncode.pwfl.core.type.support.RuntimeTypeAdapterFactory;
import com.suncode.pwfl.plugin.modules.configurationTransfer.PluginConfigurationTransferDefinition;
import com.suncode.pwfl.web.security.AuthorizationHelper;
import com.suncode.pwfl.web.util.JsonMessage;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/system/configuration/transfer"})
public class ConfigurationTransferController {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationTransferController.class);
    @Autowired
    private ConfigurationImportService configurationImportService;
    @Autowired
    private ConfigurationExportService configurationExportService;
    @Autowired
    private PluginConfigurationService pluginConfigurationService;
    @Autowired
    private PluginConfigurationTransferSupportService pluginConfigurationTransferSupportService;
    @Autowired
    private AuthorizationHelper authorizationHelper;

    @RequestMapping(value={"export/configuration"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> exportConfigurationForType(@RequestParam ConfigurationTypes type) {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        List config = this.configurationExportService.exportConfiguration(type);
        Gson gson = this.prepareGsonForPlugins();
        String json = gson.toJson((Object)config);
        return new ResponseEntity((Object)json, HttpStatus.OK);
    }

    @RequestMapping(value={"root"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<String> getRootConfig() {
        this.authorizationHelper.assertFullAdministrationRights(() -> {});
        Gson gson = this.prepareGsonForPlugins();
        String json = gson.toJson((Object)new ConfigurationDtoRoot());
        return new ResponseEntity((Object)json, HttpStatus.OK);
    }

    @ResponseBody
    @RequestMapping
    public ResponseEntity<String> getBase(HttpSession session, HttpServletRequest request) throws SQLException {
        if (this.loggedUserHasAdminRights(session)) {
            AuditBuilder configTransferAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CONFIG_TRANSFER_GET_FROM_BASE);
            ConfigurationDtoRoot config = this.configurationExportService.getBaseConfiguration();
            Gson gson = this.prepareGsonForPlugins();
            String json = gson.toJson((Object)config);
            request.setAttribute("audit", (Object)configTransferAudit.success(true).build());
            return new ResponseEntity((Object)json, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @RequestMapping(value={"export"}, method={RequestMethod.POST})
    public ResponseEntity<JsonMessage> exportConf(HttpSession session, HttpServletRequest request, @RequestBody String config) throws SQLException {
        if (this.loggedUserHasAdminRights(session)) {
            AuditBuilder configTransferAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CONFIG_TRANSFER_EXPORT);
            try {
                Gson gson = this.prepareGsonForPlugins();
                ConfigurationDtoRoot root = (ConfigurationDtoRoot)gson.fromJson(config, ConfigurationDtoRoot.class);
                this.configurationExportService.cleanAndValidConfig(root);
                JsonMessage response = new JsonMessage();
                response.setData((Object)gson.toJson((Object)root));
                response.setSuccess(true);
                request.setAttribute("audit", (Object)configTransferAudit.success(true).build());
                return new ResponseEntity((Object)response, HttpStatus.OK);
            }
            catch (Exception e) {
                return this.configTransferError(request, configTransferAudit, e);
            }
        }
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST})
    public ResponseEntity<JsonMessage> importConf(HttpSession session, @RequestBody String config, @RequestParam(value="defaultPassword", required=false) String defaultPassword, @RequestParam(value="defaultGroup", required=false) String defaultGroup, @RequestParam(value="deactivateScheduledTasks", required=false, defaultValue="true") Boolean deactivateScheduledTasks) throws SQLException {
        if (this.loggedUserHasAdminRights(session)) {
            try {
                Gson gson = this.prepareGsonForPlugins();
                ConfigurationDtoRoot root = (ConfigurationDtoRoot)gson.fromJson(config, ConfigurationDtoRoot.class);
                this.configurationImportService.importConfiguration(root, defaultPassword, defaultGroup, deactivateScheduledTasks.booleanValue());
                JsonMessage response = new JsonMessage();
                response.setSuccess(true);
                return new ResponseEntity((Object)response, HttpStatus.OK);
            }
            catch (Exception e) {
                JsonMessage response = new JsonMessage();
                response.setErrorMsg(e.getMessage() != null ? e.getMessage() : "Error:" + e);
                response.setSuccess(false);
                log.error(e.getMessage(), (Throwable)e);
                return new ResponseEntity((Object)response, HttpStatus.OK);
            }
        }
        return new ResponseEntity(HttpStatus.FORBIDDEN);
    }

    @RequestMapping(value={"clean"}, method={RequestMethod.POST})
    public ResponseEntity<JsonMessage> cleanConf(HttpServletRequest request, @RequestBody String config) {
        AuditBuilder configTransferAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CONFIG_TRANSFER_GET_FROM_FILE);
        try {
            Gson gson = this.prepareGsonForPlugins();
            ConfigurationDtoRoot root = (ConfigurationDtoRoot)gson.fromJson(config, ConfigurationDtoRoot.class);
            this.configurationImportService.removeUnnecessaryElements(root);
            JsonMessage response = new JsonMessage();
            response.setData((Object)gson.toJson((Object)root));
            response.setSuccess(true);
            request.setAttribute("audit", (Object)configTransferAudit.success(true).build());
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception e) {
            return this.configTransferError(request, configTransferAudit, e);
        }
    }

    @ResponseBody
    @RequestMapping(value={"availablePlugins"}, method={RequestMethod.GET})
    public List<String> availablePlugins() {
        return this.pluginConfigurationTransferSupportService.getAvailablePluginsToTransfer();
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ResponseEntity<JsonMessage> handleHttpMessageNotReadableException(HttpServletRequest request, Exception e) {
        AuditBuilder configTransferAudit = AuditBuilder.getInstance().type(AuditTypes.AUDIT_CONFIG_TRANSFER_GET_FROM_FILE);
        return this.configTransferError(request, configTransferAudit, e);
    }

    private ResponseEntity<JsonMessage> configTransferError(HttpServletRequest request, AuditBuilder configTransferAudit, Exception e) {
        JsonMessage response = new JsonMessage();
        response.setErrorMsg(e.getMessage() != null ? e.getMessage() : "Error:" + e);
        response.setSuccess(false);
        log.error(e.getMessage(), (Throwable)e);
        request.setAttribute("audit", (Object)configTransferAudit.success(false).build());
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    private boolean loggedUserHasAdminRights(HttpSession session) throws SQLException {
        String username = (String)session.getAttribute("username");
        int rights = Authorization.checkRight((String)RightTreeBuilder.builder().system().admin().build(), (String)username, (boolean)false, (boolean)false);
        return rights == 0;
    }

    private Gson prepareGsonForPlugins() {
        RuntimeTypeAdapterFactory pluginDtoAdapterFactory = RuntimeTypeAdapterFactory.of(PluginConfigurationDtoRoot.class, (String)"pluginId");
        List pluginConfigDefinitions = this.pluginConfigurationService.getAllPluginTransferDefinitions();
        for (PluginConfigurationTransferDefinition pluginConfigDef : pluginConfigDefinitions) {
            if (pluginConfigDef.getConfigurationDtoRootClass() == null) continue;
            Class clazz = pluginConfigDef.getConfigurationDtoRootClass();
            pluginDtoAdapterFactory.registerSubtype(clazz, pluginConfigDef.getPluginId());
        }
        pluginDtoAdapterFactory.registerSubtype(PluginConfigurationDtoRoot.class, "com.suncode.noplugin-default");
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping().registerTypeAdapterFactory((TypeAdapterFactory)pluginDtoAdapterFactory);
        return gsonBuilder.create();
    }
}

