/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.controller.api.security.sso;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.servlet.authorization.UserAuthorizationResponse;
import com.plusmpm.servlet.authorization.UserAuthorizationServlet;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.security.AuthenticationResult;
import com.suncode.pwfl.security.Authenticator;
import com.suncode.pwfl.security.AuthenticatorRegistry;
import com.suncode.pwfl.security.RedirectEvent;
import com.suncode.pwfl.security.SSOLogoutStatusCode;
import com.suncode.pwfl.web.support.UserAgentUtils;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.naming.AuthenticationException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/authentication/sso"})
public class SsoAuthenticationController {
    private static final Logger log = LoggerFactory.getLogger(SsoAuthenticationController.class);
    private static ObjectMapper mapper = new ObjectMapper();
    public static String LOGOUT_BY_SSO_SESSION_KEY = "logoutBySSO";
    @Autowired
    private AuthenticatorRegistry authenticatorRegistry;

    @RequestMapping(value={"login"})
    @ResponseBody
    public void login(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws ServletException, IOException {
        UserAuthorizationResponse authorizationResult;
        AuthenticationResult authenticationResult;
        Date started = new Date();
        String redirectUrl = (String)session.getAttribute("redirectUrl");
        session.invalidate();
        String provider = request.getParameter("provider");
        Authenticator authenticator = this.getAuthenticator(request, provider);
        if (authenticator == null) {
            log.error("Provider {} has not been registered.", (Object)provider);
            authenticationResult = new AuthenticationResult(provider, false, null, MessageHelper.getMessage((String)"authentication.sso.providerNotRegistered", (Object[])new Object[]{provider}), null);
        } else {
            authenticationResult = this.getAuthenticationResult(request, authenticator, provider);
        }
        try {
            if (!authenticationResult.isSuccess()) {
                this.createAudit(request, authenticationResult, started);
                throw new AuthenticationException();
            }
            authorizationResult = UserAuthorizationServlet.authorizeUser(request, response, authenticationResult);
            if (authorizationResult.getSuccess().booleanValue()) {
                authenticator.afterSuccessLogIn(request);
                if (StringUtils.isBlank((CharSequence)redirectUrl)) {
                    redirectUrl = "/ShowDefaultView.do";
                }
                response.sendRedirect(request.getContextPath() + redirectUrl);
                return;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String failureMessage = StringUtils.isNotBlank((CharSequence)authenticationResult.getFailureMessage()) ? authenticationResult.getFailureMessage() : MessageHelper.getMessage((String)"authentication.sso.failure", (Object[])new Object[]{request.getParameter("provider")});
            authorizationResult = UserAuthorizationResponse.builder().success(false).license(true).msg(failureMessage).build();
        }
        String failedAuthUrl = this.getAuthenticationFailedRedirectUrl(request, provider);
        if (StringUtils.isNotBlank((CharSequence)failedAuthUrl)) {
            response.sendRedirect(request.getContextPath() + failedAuthUrl);
            return;
        }
        request.setAttribute("externalAuthorizationResult", (Object)mapper.writeValueAsString((Object)authorizationResult));
        request.setAttribute("redirectUrl", (Object)"/LoginManual.do");
        request.getRequestDispatcher("/Login.do").forward((ServletRequest)request, (ServletResponse)response);
    }

    @RequestMapping(value={"logout"})
    @ResponseBody
    public void logout(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws Exception {
        String username = (String)session.getAttribute("username");
        String provider = request.getParameter("provider");
        Authenticator authenticator = this.getAuthenticator(request, provider);
        if (authenticator == null) {
            log.error("Provider {} has not been registered.", (Object)provider);
            throw new AuthenticationException();
        }
        String logoutResponse = authenticator.getLogoutResponse(request);
        if (StringUtils.isNotBlank((CharSequence)logoutResponse)) {
            boolean valid = authenticator.validLogoutResponse(request, response, logoutResponse);
            if (valid) {
                request.getSession().setAttribute(LOGOUT_BY_SSO_SESSION_KEY, (Object)true);
                request.getRequestDispatcher("/Logout.do").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            throw new Exception("Logout response invalid");
        }
        String logoutRequest = authenticator.getLogoutRequest(request);
        if (StringUtils.isNotBlank((CharSequence)logoutRequest)) {
            boolean requestValid = authenticator.validLogoutRequest(request, response, logoutRequest, username);
            if (requestValid) {
                session.invalidate();
                authenticator.sendLogoutResponse(request, response, logoutRequest, SSOLogoutStatusCode.SUCCESS);
                return;
            }
            throw new Exception("Logout request invalid");
        }
        throw new Exception("Logout request or response not found");
    }

    private AuthenticationResult getAuthenticationResult(HttpServletRequest request, Authenticator authenticator, String provider) {
        AuthenticationResult authenticationResult = authenticator.authenticate(request);
        authenticationResult.setAuthenticator(provider);
        authenticationResult.setUserCreationStrategyDuringAuthentication(authenticator.getUserCreationStrategyDuringAuthentication());
        return authenticationResult;
    }

    private Authenticator getAuthenticator(HttpServletRequest request, String provider) {
        try {
            if (StringUtils.isBlank((CharSequence)provider)) {
                log.error("Provider has not been specified in request.");
                return null;
            }
            return this.authenticatorRegistry.getAuthenticator(provider);
        }
        catch (Throwable e) {
            log.error("Could not authenticate with {}.", (Object)provider);
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private String getAuthenticationFailedRedirectUrl(HttpServletRequest request, String provider) {
        Authenticator authenticator = this.getAuthenticator(request, provider);
        if (authenticator == null) {
            return "";
        }
        return (String)authenticator.getRedirections().get(RedirectEvent.AUTHENTICATION_FAILED);
    }

    private void createAudit(HttpServletRequest request, AuthenticationResult authenticationResult, Date started) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String userName = authenticationResult.getUserName();
        params.put("username", userName == null ? "" : userName);
        params.put("domainId", authenticationResult.getAuthenticator());
        params.putAll(UserAgentUtils.resolveUserAgentAuditParams(request));
        ManualAuditBuilder.getInstance().type(AuditTypes.AUDIT_AUTO_LOG_IN).started(started).stopped(new Date()).success(authenticationResult.isSuccess()).params(params).ipAddress((String)StringUtils.defaultIfEmpty((CharSequence)request.getRemoteAddr(), (CharSequence)ManualAuditBuilder.UNKNOWN)).build().log();
    }
}

